/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.sod.bag.ChannelSeismogram;
import edu.sc.seis.sod.bag.FlippedChannel;
import edu.sc.seis.sod.bag.NegativeSensitivity;
import edu.sc.seis.sod.bag.OrientationUtil;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;

public class PolarityCheck {
    public static boolean check(Channel chan, LocalSeismogramImpl seis, InstrumentSensitivity sensitivity) throws FissuresException {
        return FlippedChannel.check(chan) && NegativeSensitivity.check(sensitivity);
    }

    public static ChannelSeismogram correct(Channel chan, LocalSeismogramImpl seis, InstrumentSensitivity sensitivity) throws FissuresException {
        if (NegativeSensitivity.check(sensitivity) && FlippedChannel.check(chan)) {
            return new ChannelSeismogram(OrientationUtil.flip(chan), seis, new InstrumentSensitivity(-1.0f * sensitivity.getSensitivityValue(), sensitivity.getFrequency()));
        }
        if (NegativeSensitivity.check(sensitivity)) {
            return NegativeSensitivity.correct(chan, seis, sensitivity);
        }
        if (FlippedChannel.check(chan)) {
            return FlippedChannel.correct(chan, seis, sensitivity);
        }
        return new ChannelSeismogram(chan, seis, sensitivity);
    }
}

