/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.bag.TauPUtil;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.LocationUtil;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.util.display.EventUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseRequest {
    private String beginPhase;
    private String endPhase;
    private Duration beginOffset;
    private Duration endOffset;
    private double beginOffsetRatio;
    private double endOffsetRatio;
    private Duration beginOffsetRatioMinimum;
    private Duration endOffsetRatioMinimum;
    private boolean negateBeginOffsetRatio = false;
    private boolean negateEndOffsetRatio = false;
    private TauPUtil util;
    private RequestFilter prevRequestFilter;
    private Location prevOriginLoc;
    private Location prevSiteLoc;
    private Instant prevOriginTime;
    private static Logger logger = LoggerFactory.getLogger(PhaseRequest.class);
    private static final String ORIGIN = "origin";

    protected PhaseRequest(String beginPhase, String endPhase, String model) throws TauModelException {
        this.beginPhase = beginPhase;
        this.endPhase = endPhase;
        this.util = TauPUtil.getTauPUtil(model);
    }

    public PhaseRequest(String beginPhase, Duration beginOffest, String endPhase, Duration endOffset, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = beginOffest;
        this.endOffset = endOffset;
    }

    public PhaseRequest(String beginPhase, Duration beginOffset, String endPhase, double endOffestRatio, Duration endOffsetMinimum, boolean negateEndOffsetRatio, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = beginOffset;
        this.endOffset = null;
        this.endOffsetRatio = endOffestRatio;
        this.endOffsetRatioMinimum = endOffsetMinimum;
        this.negateEndOffsetRatio = negateEndOffsetRatio;
    }

    public PhaseRequest(String beginPhase, double beginOffestRatio, Duration beginOffsetMinimum, boolean negateBeginOffsetRatio, String endPhase, Duration endOffset, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = null;
        this.beginOffsetRatio = beginOffestRatio;
        this.beginOffsetRatioMinimum = beginOffsetMinimum;
        this.negateBeginOffsetRatio = negateBeginOffsetRatio;
        this.endOffset = endOffset;
    }

    public PhaseRequest(String beginPhase, double beginOffestRatio, Duration beginOffsetMinimum, boolean negateBeginOffsetRatio, String endPhase, double endOffestRatio, Duration endOffsetMinimum, boolean negateEndOffsetRatio, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = null;
        this.beginOffsetRatio = beginOffestRatio;
        this.beginOffsetRatioMinimum = beginOffsetMinimum;
        this.negateBeginOffsetRatio = negateBeginOffsetRatio;
        this.endOffset = null;
        this.endOffsetRatio = endOffestRatio;
        this.endOffsetRatioMinimum = endOffsetMinimum;
        this.negateEndOffsetRatio = negateEndOffsetRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFilter generateRequest(CacheEvent event, Channel channel) throws Exception {
        OriginImpl origin = EventUtil.extractOrigin(event);
        if (channel.getStationCode() == null) {
            throw new Error("station is null " + String.valueOf(channel));
        }
        PhaseRequest phaseRequest = this;
        synchronized (phaseRequest) {
            if (this.prevRequestFilter != null && origin.getOriginTime().equals(this.prevOriginTime) && LocationUtil.areEqual(origin.getLocation(), this.prevOriginLoc) && LocationUtil.areSameLocation(channel, this.prevSiteLoc)) {
                return new RequestFilter(channel, this.prevRequestFilter.startTime, this.prevRequestFilter.endTime);
            }
        }
        double begin = this.getArrivalTime(this.beginPhase, channel, origin);
        double end = this.getArrivalTime(this.endPhase, channel, origin);
        if (begin == -1.0 || end == -1.0) {
            return null;
        }
        Instant originDate = origin.getOriginTime();
        Instant bDate = originDate.plus(TimeUtils.durationFromSeconds((double)begin));
        Instant eDate = originDate.plus(TimeUtils.durationFromSeconds((double)end));
        Duration bInterval = this.beginOffset != null ? this.beginOffset : PhaseRequest.getTimeIntervalFromRatio(bDate, eDate, this.beginOffsetRatio, this.beginOffsetRatioMinimum, this.negateBeginOffsetRatio);
        Duration eInterval = this.endOffset != null ? this.endOffset : PhaseRequest.getTimeIntervalFromRatio(bDate, eDate, this.endOffsetRatio, this.endOffsetRatioMinimum, this.negateEndOffsetRatio);
        bDate = bDate.plus(bInterval);
        eDate = eDate.plus(eInterval);
        PhaseRequest phaseRequest2 = this;
        synchronized (phaseRequest2) {
            this.prevOriginLoc = origin.getLocation();
            this.prevSiteLoc = Location.of(channel);
            this.prevOriginTime = origin.getOriginTime();
            if (channel.getStationCode() == null) {
                throw new Error("station is null " + String.valueOf(channel));
            }
            this.prevRequestFilter = new RequestFilter(channel, bDate, eDate);
            if (this.prevRequestFilter.getChannelId().getStationCode() == null) {
                throw new Error("station is null " + String.valueOf(this.prevRequestFilter));
            }
        }
        logger.info("Generated request from " + String.valueOf(bDate) + " to " + String.valueOf(eDate) + " for " + StationIdUtil.toStringNoDates(channel.getStation()));
        if (this.prevRequestFilter.getChannelId().getStationCode() == null) {
            throw new Error("station is null " + String.valueOf(this.prevRequestFilter));
        }
        return this.prevRequestFilter;
    }

    private double getArrivalTime(String phase, Channel chan, OriginImpl origin) throws TauPException {
        if (phase.equals(ORIGIN)) {
            return 0.0;
        }
        String[] phases = new String[]{phase};
        List<Arrival> arrivals = this.util.calcTravelTimes(chan, origin, phases);
        if (arrivals.size() == 0) {
            return -1.0;
        }
        return Math.rint(1000.0 * arrivals.get(0).getTime()) / 1000.0;
    }

    public static Duration getTimeIntervalFromRatio(Instant startPhaseTime, Instant endPhaseTime, double ratio, Duration minimumTime, boolean negate) {
        Duration interval = Duration.ofNanos(Math.round((double)Duration.between(startPhaseTime, endPhaseTime).toNanos() * ratio));
        if (interval.toNanos() < minimumTime.toNanos()) {
            return PhaseRequest.negateIfTrue(minimumTime, negate);
        }
        return PhaseRequest.negateIfTrue(interval, negate);
    }

    public static Duration negateIfTrue(Duration interval, boolean negate) {
        if (negate) {
            return interval.negated();
        }
        return interval;
    }

    public String getBeginPhase() {
        return this.beginPhase;
    }

    public String getEndPhase() {
        return this.endPhase;
    }

    public Duration getBeginOffset() {
        return this.beginOffset;
    }

    public Duration getEndOffset() {
        return this.endOffset;
    }

    public double getBeginOffsetRatio() {
        return this.beginOffsetRatio;
    }

    public double getEndOffsetRatio() {
        return this.endOffsetRatio;
    }

    public Duration getBeginOffsetRatioMinimum() {
        return this.beginOffsetRatioMinimum;
    }

    public Duration getEndOffsetRatioMinimum() {
        return this.endOffsetRatioMinimum;
    }

    public boolean isNegateBeginOffsetRatio() {
        return this.negateBeginOffsetRatio;
    }

    public boolean isNegateEndOffsetRatio() {
        return this.negateEndOffsetRatio;
    }
}

