/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.bag.Cut;
import edu.sc.seis.sod.bag.PhaseNonExistent;
import edu.sc.seis.sod.bag.TauPUtil;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseCut {
    TauPUtil timeCalc;
    String beginPhase;
    Duration beginOffset;
    String endPhase;
    Duration endOffset;
    Logger logger = LoggerFactory.getLogger(PhaseCut.class);

    public PhaseCut(TauPUtil timeCalc, String beginPhase, Duration beginOffset, String endPhase, Duration endOffset) {
        this.timeCalc = timeCalc;
        this.beginPhase = beginPhase;
        this.beginOffset = beginOffset;
        this.endPhase = endPhase;
        this.endOffset = endOffset;
    }

    public LocalSeismogramImpl cut(Location stationLoc, OriginImpl origin, LocalSeismogramImpl seis) throws TauPException, PhaseNonExistent, FissuresException {
        List<Arrival> beginArrivals = this.timeCalc.calcTravelTimes(stationLoc, origin, new String[]{this.beginPhase});
        List<Arrival> endArrivals = this.timeCalc.calcTravelTimes(stationLoc, origin, new String[]{this.endPhase});
        Instant beginTime = null;
        Instant endTime = null;
        Instant originTime = origin.getOriginTime();
        if (beginArrivals.size() == 0) {
            DistAz distAz = new DistAz(stationLoc, origin.getLocation());
            throw new PhaseNonExistent("Phase " + this.beginPhase + " does not exist at this distance, " + distAz.getDelta() + " degrees");
        }
        beginTime = originTime.plus(TimeUtils.durationFromSeconds((double)beginArrivals.get(0).getTime()));
        beginTime = beginTime.plus(this.beginOffset);
        if (endArrivals.size() == 0) {
            DistAz distAz = new DistAz(stationLoc, origin.getLocation());
            throw new PhaseNonExistent("Phase " + this.endPhase + " does not exist at this distance, " + distAz.getDelta() + " degrees");
        }
        endTime = originTime.plus(TimeUtils.durationFromSeconds((double)endArrivals.get(0).getTime()));
        endTime = endTime.plus(this.endOffset);
        Cut cut = new Cut(beginTime, endTime);
        return cut.apply(seis);
    }
}

