/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.ToDoException;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.station.OrientationRangeImpl;
import java.util.ArrayList;
import java.util.List;

public class OrientationUtil {
    public static Orientation of(Channel chan) {
        return new Orientation(chan.getAzimuth().getValue(), chan.getDip().getValue());
    }

    public static List<Channel> inOrientation(OrientationRangeImpl orient, List<Channel> chans) {
        double degDist = QuantityImpl.createQuantityImpl(orient.angular_distance).convertTo(UnitImpl.DEGREE).getValue();
        ArrayList<Channel> results = new ArrayList<Channel>();
        for (Channel chan : chans) {
            Orientation chanOrient = OrientationUtil.of(chan);
            double dist = OrientationUtil.angleBetween(orient.center, chanOrient);
            if (!(dist <= degDist)) continue;
            results.add(chan);
        }
        return results;
    }

    public static boolean areEqual(Channel one, Channel two) {
        return OrientationUtil.areEqual(OrientationUtil.of(one), OrientationUtil.of(two));
    }

    public static boolean areEqual(Orientation one, Orientation two) {
        return one.azimuth == two.azimuth && one.dip == two.dip;
    }

    public static boolean areOrthogonal(Channel one, Channel two) {
        return OrientationUtil.areOrthogonal(OrientationUtil.of(one), OrientationUtil.of(two));
    }

    public static boolean areOrthogonal(Orientation one, Orientation two) {
        return OrientationUtil.areOrthogonal(one, two, 1.0E-4);
    }

    public static boolean areOrthogonal(Orientation one, Orientation two, double tol) {
        double dist = OrientationUtil.angleBetween(one, two);
        return Math.abs(dist - 90.0) < tol;
    }

    public static double angleBetween(Orientation one, Orientation two) {
        return SphericalCoords.distance((double)one.dip, (double)one.azimuth, (double)two.dip, (double)two.azimuth);
    }

    public static Orientation getUp() {
        return new Orientation(0.0f, -90.0f);
    }

    public static Orientation getNorth() {
        return new Orientation(0.0f, 0.0f);
    }

    public static Orientation getEast() {
        return new Orientation(90.0f, 0.0f);
    }

    public static Orientation flip(Orientation orient) {
        return new Orientation(-1.0f * orient.dip, (orient.azimuth + 180.0f) % 360.0f);
    }

    public static Channel flip(Channel chan) {
        Orientation flipped = OrientationUtil.flip(Orientation.of(chan));
        Channel out = new Channel(chan.getStation(), chan.getLocCode(), chan.getChannelCode());
        out.setAzimuth(flipped.getAzimuth());
        out.setDip(flipped.getDip());
        out.setSampleRate(chan.getSampleRate());
        out.setDepth(chan.getDepth());
        out.setLatitude(chan.getLatitude());
        out.setLongitude(chan.getLongitude());
        out.setElevation(chan.getElevation());
        out.setStartDateTime(chan.getStartDateTime());
        out.setEndDateTime(chan.getEndDateTime());
        throw new ToDoException("set other channel props");
    }

    public static String toString(Orientation orientation) {
        return "az=" + orientation.azimuth + ", dip=" + orientation.dip;
    }
}

