/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import com.oregondsp.signalProcessing.fft.RDFT;

public class OregonDspFFT {
    public static float[] forward(float[] realData) {
        int N;
        int log2N = 5;
        for (N = 32; N < realData.length; N *= 2) {
            ++log2N;
        }
        float[] in = new float[N];
        float[] out = new float[N];
        System.arraycopy(realData, 0, in, 0, realData.length);
        RDFT rdft = new RDFT(log2N);
        rdft.evaluate(in, out);
        return out;
    }

    public static float[] inverse(float[] realData) {
        int N;
        int log2N = 5;
        for (N = 32; N < realData.length; N *= 2) {
            ++log2N;
        }
        float[] in = new float[N];
        float[] out = new float[N];
        System.arraycopy(realData, 0, in, 0, realData.length);
        RDFT rdft = new RDFT(log2N);
        rdft.evaluateInverse(in, out);
        return out;
    }

    public static float[] correlate(float[] x, float[] y) {
        int N;
        int log2N = 5;
        for (N = 32; N < x.length; N *= 2) {
            ++log2N;
        }
        while (N < y.length) {
            ++log2N;
            N *= 2;
        }
        float[] xIn = new float[N];
        float[] yIn = new float[N];
        System.arraycopy(x, 0, xIn, 0, x.length);
        System.arraycopy(y, 0, yIn, 0, y.length);
        RDFT rdft = new RDFT(log2N);
        float[] xforward = new float[N];
        rdft.evaluate(xIn, xforward);
        xIn = null;
        float[] yforward = new float[N];
        rdft.evaluate(yIn, yforward);
        yIn = null;
        float[] ans = new float[N];
        ans[0] = xforward[0] * yforward[0];
        ans[N / 2] = xforward[N / 2] * yforward[N / 2];
        for (int j = 1; j < N / 2; ++j) {
            float a = xforward[j];
            float b = xforward[N - j];
            float c = yforward[j];
            float d = yforward[N - j];
            ans[j] = a * c + b * d;
            ans[N - j] = -a * d + b * c;
        }
        xforward = null;
        yforward = null;
        float[] out = new float[N];
        rdft.evaluateInverse(ans, out);
        return out;
    }

    public static float[] convolve(float[] x, float[] y, float delta) {
        int N;
        int log2N = 5;
        for (N = 32; N < x.length; N *= 2) {
            ++log2N;
        }
        while (N < y.length) {
            ++log2N;
            N *= 2;
        }
        float[] xIn = new float[N];
        float[] yIn = new float[N];
        System.arraycopy(x, 0, xIn, 0, x.length);
        System.arraycopy(y, 0, yIn, 0, y.length);
        RDFT rdft = new RDFT(log2N);
        float[] xforward = new float[N];
        rdft.evaluate(xIn, xforward);
        xIn = null;
        float[] yforward = new float[N];
        rdft.evaluate(yIn, yforward);
        yIn = null;
        float[] ans = new float[N];
        ans[0] = xforward[0] * yforward[0];
        ans[N / 2] = xforward[N / 2] * yforward[N / 2];
        for (int j = 1; j < N / 2; ++j) {
            float a = xforward[j];
            float b = xforward[N - j];
            float c = yforward[j];
            float d = yforward[N - j];
            ans[j] = a * c - b * d;
            ans[N - j] = a * d + b * c;
        }
        float[] out = new float[N];
        rdft.evaluateInverse(ans, out);
        int i = 0;
        while (i < ans.length) {
            int n = i++;
            out[n] = out[n] * delta;
        }
        return out;
    }
}

