/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.sod.bag.Arithmatic;
import edu.sc.seis.sod.bag.ChannelSeismogram;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;

public class NegativeSensitivity {
    public static boolean check(InstrumentSensitivity sensitivity) {
        return sensitivity.getSensitivityValue() < 0.0f;
    }

    public static boolean check(QuantityImpl sensitivity) {
        return sensitivity.getValue() < 0.0;
    }

    public static ChannelSeismogram correct(Channel chan, LocalSeismogramImpl seis, InstrumentSensitivity sensitivity) throws FissuresException {
        if (NegativeSensitivity.check(sensitivity)) {
            return new ChannelSeismogram(chan, Arithmatic.mul(seis, -1.0f), new InstrumentSensitivity(-1.0f * sensitivity.getSensitivityValue(), sensitivity.getFrequency()));
        }
        return new ChannelSeismogram(chan, seis, sensitivity);
    }
}

