/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.station.ChannelId;
import java.io.Serializable;
import java.time.Instant;

public class LongShortTrigger
implements Serializable {
    private String seisId;
    private ChannelId channelId;
    private Instant when;
    private float value;
    private int index;
    private float sta;
    private float lta;

    public LongShortTrigger(LocalSeismogramImpl seis, int index, float value, float sta, float lta) {
        this(seis.getChannelID(), seis.get_id(), index, value, seis.getBeginTime().plus(seis.getSampling().getPeriod().multipliedBy(index)), sta, lta);
    }

    public LongShortTrigger(ChannelId channelId, String seisId, int index, float value, Instant when, float sta, float lta) {
        this.seisId = seisId;
        this.channelId = channelId;
        this.index = index;
        this.when = when;
        this.value = value;
        this.sta = sta;
        this.lta = lta;
    }

    public int getIndex() {
        return this.index;
    }

    public float getValue() {
        return this.value;
    }

    public Instant getWhen() {
        return this.when;
    }

    public String getSeisId() {
        return this.seisId;
    }

    public String getChannelId() {
        return this.seisId;
    }

    public float getSTA() {
        return this.sta;
    }

    public float getLTA() {
        return this.lta;
    }

    public String toString() {
        return "" + this.getValue();
    }
}

