/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.bag.LongShortTrigger;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import java.time.Duration;
import java.util.LinkedList;

public class LongShortStoN {
    protected Duration longTime;
    protected Duration shortTime;
    protected Duration delay;
    protected float threshold;
    protected Duration meanTime;

    public LongShortStoN(Duration longTime, Duration shortTime, float threshold) {
        this(longTime, shortTime, threshold, shortTime.multipliedBy(2L));
    }

    public LongShortStoN(Duration longTime, Duration shortTime, float threshold, Duration delay) {
        this(longTime, shortTime, threshold, delay, Duration.ofSeconds(100L));
    }

    public LongShortStoN(Duration longTime, Duration shortTime, float threshold, Duration delay, Duration meanTime) {
        if (longTime.toNanos() <= shortTime.toNanos()) {
            throw new IllegalArgumentException("longTime must be longer than shortTime, longTime=" + String.valueOf(longTime) + "  shortTime=" + String.valueOf(shortTime));
        }
        if (delay.toNanos() < shortTime.toNanos()) {
            throw new IllegalArgumentException("delay must be longer than shortTime, shortTime=" + String.valueOf(shortTime) + "  delay=" + String.valueOf(delay));
        }
        this.longTime = longTime;
        this.shortTime = shortTime;
        this.threshold = threshold;
        this.delay = delay;
        this.meanTime = meanTime;
    }

    public LongShortTrigger[] calcTriggers(LocalSeismogramImpl seis) throws FissuresException {
        float ratio;
        float dat;
        int i;
        float mean;
        LinkedList<LongShortTrigger> out = new LinkedList<LongShortTrigger>();
        float[] seisData = seis.get_as_floats();
        double dt = TimeUtils.durationToDoubleSeconds((Duration)seis.getSampling().getPeriod());
        int nlta = (int)(TimeUtils.durationToDoubleSeconds((Duration)this.longTime) / dt) + 1;
        int nsta = (int)(TimeUtils.durationToDoubleSeconds((Duration)this.shortTime) / dt) + 1;
        int ntdly = (int)(TimeUtils.durationToDoubleSeconds((Duration)this.delay) / dt) + 1;
        int nmean = (int)(TimeUtils.durationToDoubleSeconds((Duration)this.meanTime) / dt) + 1;
        if (Duration.between(seis.getBeginTime(), seis.getEndTime()).toNanos() < this.delay.toNanos() || nsta > ntdly || ntdly > seis.getNumPoints()) {
            return new LongShortTrigger[0];
        }
        float csta = 1.0f / (float)nsta;
        float clta = 1.0f / (float)nlta;
        float cmean = 1.0f / (float)nmean;
        float mean1 = mean = 0.0f;
        float sta = 0.0f;
        float lta = 0.0f;
        float trg = 0.0f;
        boolean hold = false;
        for (i = 0; i < 2 * nsta; ++i) {
            mean += (seisData[i] - mean) * cmean;
            dat = seisData[i] - mean;
            mean1 += (dat - mean1) * cmean;
            sta += (Math.abs(dat -= mean1) - sta) * csta;
            lta += (Math.abs(dat) - lta) * csta;
            ratio = sta / lta;
        }
        for (i = 2 * nsta; i < seisData.length; ++i) {
            mean += (seisData[i] - mean) * cmean;
            dat = seisData[i] - mean;
            mean1 += (dat - mean1) * cmean;
            dat = Math.abs(dat - mean1);
            sta += (dat - sta) * csta;
            if (trg != 1.0f || !hold) {
                lta += (dat - lta) * clta;
            }
            ratio = sta / lta;
            if (!(ratio >= this.threshold)) continue;
            LongShortTrigger trigger = new LongShortTrigger(seis, i, ratio, sta, lta);
            out.add(trigger);
        }
        LongShortTrigger[] trigger = out.toArray(new LongShortTrigger[0]);
        return trigger;
    }

    public LongShortTrigger[] calcTriggersTJO(LocalSeismogramImpl seis) throws FissuresException {
        int j;
        LinkedList<LongShortTrigger> out = new LinkedList<LongShortTrigger>();
        float[] seisData = seis.get_as_floats();
        double dt = TimeUtils.durationToDoubleSeconds((Duration)seis.getSampling().getPeriod());
        int nlta = (int)(TimeUtils.durationToDoubleSeconds((Duration)this.longTime) / dt) + 1;
        int nsta = (int)(TimeUtils.durationToDoubleSeconds((Duration)this.shortTime) / dt) + 1;
        int ntdly = (int)(TimeUtils.durationToDoubleSeconds((Duration)this.delay) / dt) + 1;
        if (Duration.between(seis.getBeginTime(), seis.getEndTime()).toNanos() < this.delay.toNanos() || nsta > ntdly || ntdly > seis.getNumPoints()) {
            return new LongShortTrigger[0];
        }
        int n100 = (int)(100.0 / dt) + 1;
        float clta = 1.0f / (float)nlta;
        float csta = 1.0f / (float)nsta;
        float xmean = 0.0f;
        float ylta = 0.0f;
        float prevylta = 0.0f;
        float ysta = 0.0f;
        float prevysta = 0.0f;
        for (j = 0; j < nsta && j < ntdly; ++j) {
            ysta += seisData[ntdly - j - 1];
        }
        for (j = 0; j < nlta && j < ntdly; ++j) {
            ylta += seisData[ntdly - j - 1];
        }
        int nmean = 0;
        for (nmean = 0; nmean < n100 && nmean < ntdly; ++nmean) {
            xmean += seisData[ntdly - nmean - 1];
        }
        for (int i = ntdly; i < seisData.length; ++i) {
            if (nmean == n100) {
                xmean -= seisData[i - n100];
            } else {
                ++nmean;
            }
            prevylta = ylta;
            float nextData = Math.abs(seisData[i] - (xmean += seisData[i]) / (float)nmean);
            ylta = clta * nextData + (1.0f - clta) * prevylta - (i < nlta ? 0.0f : clta * Math.abs(seisData[i - nlta] - xmean / (float)nmean));
            prevysta = ysta;
            ysta = csta * nextData + (1.0f - csta) * prevysta - (i < nsta ? 0.0f : csta * Math.abs(seisData[i - nsta] - xmean / (float)nmean));
            float ratio = ylta != 0.0f ? ysta / ylta : (ysta != 0.0f ? this.threshold : 0.0f);
            if (!(ratio >= this.threshold)) continue;
            LongShortTrigger trigger = new LongShortTrigger(seis, i, ratio, ysta, ylta);
            out.add(trigger);
        }
        LongShortTrigger[] trigger = out.toArray(new LongShortTrigger[0]);
        return trigger;
    }
}

