/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import java.time.Duration;

public class IterDeconResult {
    Duration alignShift;
    float[][] corrSave;
    int maxBumps;
    boolean useAbsVal;
    float tol;
    float gwidth;
    float[] numerator;
    float[] denominator;
    float dt;
    float[] amps;
    int[] shifts;
    float[] residual;
    public float[] predicted;
    float[] spikes;
    float residualPower;
    float numeratorPower;
    int bump;

    public IterDeconResult(int maxBumps, boolean useAbsVal, float tol, float gwidth, float[] numerator, float[] denominator, float dt, float[] amps, int[] shifts, float[] residual, float[] predicted, float[][] corrSave, float[] spikes, float residualPower, float numeratorPower, int bump) {
        this.maxBumps = maxBumps;
        this.useAbsVal = useAbsVal;
        this.tol = tol;
        this.gwidth = gwidth;
        this.numerator = numerator;
        this.denominator = denominator;
        this.dt = dt;
        this.amps = amps;
        this.shifts = shifts;
        this.residual = residual;
        this.predicted = predicted;
        this.corrSave = corrSave;
        this.spikes = spikes;
        this.residualPower = residualPower;
        this.numeratorPower = numeratorPower;
        this.bump = bump;
    }

    public float getPercentMatch() {
        float numPower = this.getNumeratorPower();
        return 100.0f * (numPower - this.getResidualPower()) / numPower;
    }

    public int getMaxBumps() {
        return this.maxBumps;
    }

    public boolean isUseAbsVal() {
        return this.useAbsVal;
    }

    public float getTol() {
        return this.tol;
    }

    public float getGWidth() {
        return this.gwidth;
    }

    public float[] getNumerator() {
        return this.numerator;
    }

    public float[] getDenominator() {
        return this.denominator;
    }

    public float getDelta() {
        return this.dt;
    }

    public float[] getAmps() {
        return this.amps;
    }

    public int[] getShifts() {
        return this.shifts;
    }

    public float[] getResidual() {
        return this.residual;
    }

    public float[] getPredicted() {
        return this.predicted;
    }

    public float[][] getCorrSave() {
        return this.corrSave;
    }

    public void setAlignShift(Duration alignShift) {
        this.alignShift = alignShift;
    }

    public Duration getAlignShift() {
        return this.alignShift;
    }

    public float[] getSpikes() {
        return this.spikes;
    }

    public float getResidualPower() {
        return this.residualPower;
    }

    public float getNumeratorPower() {
        return this.numeratorPower;
    }

    public int getBump() {
        return this.bump;
    }
}

