/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.sod.bag.Arithmatic;
import edu.sc.seis.sod.bag.ChannelSeismogram;
import edu.sc.seis.sod.bag.OrientationUtil;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;

public class FlippedChannel {
    private static double tol = 0.01;

    public static ChannelSeismogram correct(Channel chan, LocalSeismogramImpl seis) throws FissuresException {
        return FlippedChannel.correct(chan, seis, null);
    }

    public static ChannelSeismogram correct(Channel chan, LocalSeismogramImpl seis, InstrumentSensitivity sens) throws FissuresException {
        if (FlippedChannel.check(chan)) {
            return new ChannelSeismogram(OrientationUtil.flip(chan), Arithmatic.mul(seis, -1.0f), null);
        }
        return new ChannelSeismogram(chan, seis, sens);
    }

    public static boolean check(Channel chan) {
        return chan.getCode().charAt(2) == 'Z' && FlippedChannel.check(OrientationUtil.getUp(), chan) || chan.getCode().charAt(2) == 'N' && FlippedChannel.check(OrientationUtil.getNorth(), chan) || chan.getCode().charAt(2) == 'E' && FlippedChannel.check(OrientationUtil.getEast(), chan);
    }

    public static boolean check(Orientation correct, Channel chan) {
        return OrientationUtil.angleBetween(correct, Orientation.of(chan)) >= 180.0 - tol;
    }
}

