/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.bag.LocalSeismogramFunction;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.seismogram.EncodedData;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import edu.sc.seis.sod.model.seismogram.TimeSeriesDataSel;
import edu.sc.seis.sod.util.time.RangeTool;
import edu.sc.seis.sod.util.time.ReduceTool;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;

public class Cut
implements LocalSeismogramFunction {
    private Instant begin;
    private Instant end;
    public static final UnitImpl SEC_PER_SEC = UnitImpl.divide(UnitImpl.SECOND, UnitImpl.SECOND);

    public Cut(Instant begin, Instant end) {
        this.begin = begin;
        this.end = end;
    }

    public Cut(RequestFilter request) {
        this(request.startTime, request.endTime);
    }

    @Override
    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        if (!this.overlaps(seis)) {
            return null;
        }
        if (seis.getBeginTime().equals(this.getBegin()) && seis.getEndTime().equals(this.getEnd())) {
            return seis;
        }
        LocalSeismogramImpl tmpSeis = this.applyEncoded(seis);
        int beginIndex = this.getBeginIndex(tmpSeis);
        int endIndex = this.getEndIndex(tmpSeis);
        return Cut.cut(tmpSeis, beginIndex, endIndex);
    }

    public static LocalSeismogramImpl cut(LocalSeismogramImpl seis, int beginIndex, int endIndex) throws FissuresException {
        LocalSeismogramImpl outSeis;
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > seis.getNumPoints()) {
            endIndex = seis.getNumPoints();
        }
        if ((seis = Cut.cutEncoded(seis, beginIndex, endIndex)).can_convert_to_short()) {
            short[] outS = new short[endIndex - beginIndex + 1];
            short[] inS = seis.get_as_shorts();
            System.arraycopy(inS, beginIndex, outS, 0, endIndex - beginIndex + 1);
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, outS);
        } else if (seis.can_convert_to_long()) {
            int[] outI = new int[endIndex - beginIndex + 1];
            int[] inI = seis.get_as_longs();
            System.arraycopy(inI, beginIndex, outI, 0, endIndex - beginIndex + 1);
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, outI);
        } else if (seis.can_convert_to_float()) {
            float[] outF = new float[endIndex - beginIndex + 1];
            float[] inF = seis.get_as_floats();
            System.arraycopy(inF, beginIndex, outF, 0, endIndex - beginIndex + 1);
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, outF);
        } else {
            double[] outD = new double[endIndex - beginIndex + 1];
            double[] inD = seis.get_as_doubles();
            System.arraycopy(inD, beginIndex, outD, 0, endIndex - beginIndex + 1);
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, outD);
        }
        outSeis.begin_time = seis.getBeginTime().plus(seis.getSampling().getPeriod().multipliedBy(beginIndex));
        return outSeis;
    }

    public boolean overlaps(LocalSeismogramImpl seis) {
        return this.begin.isBefore(seis.getEndTime()) && this.end.isAfter(seis.getBeginTime());
    }

    protected int getEndIndex(LocalSeismogramImpl seis) {
        Duration sampPeriod = seis.getSampling().getPeriod();
        Duration endShift = Duration.between(seis.getBeginTime(), this.end);
        double endShiftSecs = TimeUtils.durationToDoubleSeconds((Duration)endShift) / TimeUtils.durationToDoubleSeconds((Duration)sampPeriod);
        int endIndex = (int)Math.floor(endShiftSecs);
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (endIndex >= seis.getNumPoints()) {
            endIndex = seis.getNumPoints() - 1;
        }
        return endIndex;
    }

    protected int getBeginIndex(LocalSeismogramImpl seis) {
        Duration sampPeriod = seis.getSampling().getPeriod();
        Duration beginShift = Duration.between(seis.getBeginTime(), this.begin);
        double beginShiftSecs = TimeUtils.durationToDoubleSeconds((Duration)beginShift) / TimeUtils.durationToDoubleSeconds((Duration)sampPeriod);
        int beginIndex = (int)Math.ceil(beginShiftSecs);
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (beginIndex >= seis.getNumPoints()) {
            beginIndex = seis.getNumPoints() - 1;
        }
        return beginIndex;
    }

    public String toString() {
        return "Cut from " + String.valueOf(this.begin) + " to " + String.valueOf(this.end);
    }

    public Instant getBegin() {
        return this.begin;
    }

    public Instant getEnd() {
        return this.end;
    }

    public RequestFilter apply(RequestFilter original) {
        RequestFilter result = new RequestFilter(original.channelId, original.startTime, original.endTime);
        if (this.begin.isAfter(original.getEndTime()) || this.end.isBefore(original.getStartTime())) {
            return null;
        }
        result.startTime = this.begin.isAfter(original.getStartTime()) ? this.begin : original.startTime;
        result.endTime = this.end.isBefore(original.getEndTime()) ? this.end : original.endTime;
        return result;
    }

    public LocalSeismogramImpl applyEncoded(LocalSeismogramImpl seis) throws FissuresException {
        if (!seis.is_encoded()) {
            return seis;
        }
        if (!this.overlaps(seis)) {
            return null;
        }
        int beginIndex = this.getBeginIndex(seis);
        int endIndex = this.getEndIndex(seis);
        return Cut.cutEncoded(seis, beginIndex, endIndex);
    }

    public static LocalSeismogramImpl cutEncoded(LocalSeismogramImpl seis, int beginIndex, int endIndex) throws FissuresException {
        if (!seis.is_encoded()) {
            return seis;
        }
        ArrayList<EncodedData> outData = new ArrayList<EncodedData>();
        EncodedData[] ed = seis.get_as_encoded();
        int currentPoint = 0;
        int firstUsedPoint = -1;
        int pointsInNewSeis = 0;
        for (int i = 0; i < ed.length && currentPoint <= endIndex; currentPoint += ed[i].num_points, ++i) {
            if (currentPoint + ed[i].num_points <= beginIndex) continue;
            outData.add(ed[i]);
            pointsInNewSeis += ed[i].num_points;
            if (firstUsedPoint != -1) continue;
            firstUsedPoint = currentPoint;
        }
        TimeSeriesDataSel ds = new TimeSeriesDataSel();
        ds.encoded_values(outData.toArray(new EncodedData[outData.size()]));
        LocalSeismogramImpl outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, ds);
        outSeis.begin_time = seis.getBeginTime().plus(seis.getSampling().getPeriod().multipliedBy(firstUsedPoint));
        outSeis.num_points = pointsInNewSeis;
        return outSeis;
    }

    public static LocalSeismogramImpl[] coarseCut(RequestFilter[] aFilterseq, LocalSeismogramImpl[] seis) throws FissuresException {
        ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
        RequestFilter[] mergedRequest = ReduceTool.merge(aFilterseq);
        for (int i = 0; i < mergedRequest.length; ++i) {
            Cut c = new Cut(mergedRequest[i]);
            for (int j = 0; j < seis.length; ++j) {
                LocalSeismogramImpl tmpSeis = c.applyEncoded(seis[j]);
                if (tmpSeis == null) continue;
                out.add(tmpSeis);
            }
        }
        return out.toArray(new LocalSeismogramImpl[0]);
    }

    public static LocalSeismogramImpl[] cutOverlap(LocalSeismogramImpl[] seis) throws FissuresException {
        LocalSeismogramImpl[] tmp = new LocalSeismogramImpl[seis.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = seis[i];
        }
        seis = tmp;
        ReduceTool.LSMerger merger = new ReduceTool.LSMerger();
        for (int i = 0; i < seis.length; ++i) {
            boolean changeMade;
            if (seis[i] == null) continue;
            do {
                changeMade = false;
                for (int j = i + 1; j < seis.length; ++j) {
                    Cut cut;
                    if (seis[j] == null) continue;
                    if (ReduceTool.contains(seis[i], seis[j])) {
                        seis[j] = null;
                        changeMade = true;
                        continue;
                    }
                    if (ReduceTool.contains(seis[j], seis[i])) {
                        seis[i] = seis[j];
                        seis[j] = null;
                        changeMade = true;
                        continue;
                    }
                    if (!RangeTool.areOverlapping(seis[i], seis[j])) continue;
                    Instant iEnd = seis[i].getEndTime();
                    Instant iBegin = seis[i].getBeginTime();
                    Duration halfSample = seis[i].getSampling().getPeriod().dividedBy(2L);
                    if (iEnd.isBefore(seis[j].getEndTime())) {
                        cut = new Cut(iEnd.plus(halfSample), seis[j].getEndTime());
                        seis[j] = cut.apply(seis[j]);
                    } else {
                        cut = new Cut(seis[j].getBeginTime(), iBegin.minus(halfSample));
                        seis[j] = cut.apply(seis[j]);
                    }
                    if (seis[j] != null) {
                        seis[i] = merger.merge(seis[i], seis[j]);
                        seis[j] = null;
                    }
                    changeMade = true;
                }
            } while (changeMade);
        }
        ArrayList<LocalSeismogramImpl> results = new ArrayList<LocalSeismogramImpl>(seis.length);
        for (int i = 0; i < seis.length; ++i) {
            if (seis[i] == null) continue;
            results.add(seis[i]);
        }
        return results.toArray(new LocalSeismogramImpl[0]);
    }
}

