/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import java.time.Duration;
import java.time.Instant;

public class Calculus {
    public static int[] difference(int[] data) {
        int[] out = new int[data.length - 1];
        for (int i = 0; i < out.length; ++i) {
            out[i] = data[i + 1] - data[i];
        }
        return out;
    }

    public static LocalSeismogramImpl difference(LocalSeismogramImpl seis) throws FissuresException {
        int[] seisData = seis.get_as_longs();
        int[] out = Calculus.difference(seisData);
        return new LocalSeismogramImpl((SeismogramAttrImpl)seis, out);
    }

    public static LocalSeismogramImpl differentiate(LocalSeismogramImpl seis) throws FissuresException {
        LocalSeismogramImpl outSeis;
        Object[] data;
        SamplingImpl samp = seis.getSampling();
        double sampPeriod = TimeUtils.durationToDoubleSeconds((Duration)samp.getPeriod());
        if (seis.can_convert_to_float()) {
            data = seis.get_as_floats();
            float[] out = new float[data.length - 1];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (float)((double)(data[i + 1] - data[i]) / sampPeriod);
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, out);
        } else {
            data = seis.get_as_doubles();
            double[] out = new double[data.length - 1];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (data[i + 1] - data[i]) / sampPeriod;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, out);
        }
        outSeis.y_unit = UnitImpl.divide(UnitImpl.createUnitImpl(outSeis.y_unit), UnitImpl.SECOND);
        Instant begin = outSeis.getBeginTime();
        outSeis.begin_time = begin = begin.plus(samp.getPeriod().dividedBy(2L));
        return outSeis;
    }

    public static LocalSeismogramImpl integrate(LocalSeismogramImpl seis) throws FissuresException {
        LocalSeismogramImpl outSeis;
        SamplingImpl samp = seis.getSampling();
        double sampPeriod = TimeUtils.durationToDoubleSeconds((Duration)samp.getPeriod());
        if (seis.can_convert_to_float()) {
            float[] data = seis.get_as_floats();
            float[] out = new float[data.length];
            out[0] = 0.0f;
            for (int i = 1; i < out.length; ++i) {
                out[i] = out[i - 1] + (data[i - 1] + data[i]) / 2.0f * (float)sampPeriod;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, out);
        } else {
            double[] data = seis.get_as_doubles();
            double[] out = new double[data.length];
            out[0] = 0.0;
            for (int i = 1; i < out.length; ++i) {
                out[i] = out[i - 1] + (data[i - 1] + data[i]) / 2.0 * sampPeriod;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, out);
        }
        outSeis.y_unit = UnitImpl.multiply(UnitImpl.createUnitImpl(outSeis.y_unit), UnitImpl.SECOND);
        return outSeis;
    }
}

