/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestChannelUtil {
    public static final String[] DEFAULT_SITE_CODE_HEURISTIC = new String[]{"00", "  ", "", "01", "02", "10"};
    public static final String[] DEFAULT_GAIN_CODE_HEURISTIC = new String[]{"H", "L"};
    public static final String[] DEFAULT_BAND_CODE_HEURISTIC = new String[]{"B", "H", "L", "M", "S", "V", "E", "U"};
    public static final String[] DEFAULT_ORIENTATION_CODES = new String[]{"Z", "N", "E", "1", "2", "3", "U", "V", "W"};
    public static final float DEFAULT_MAX_DIP_OFFSET = 5.0f;
    protected String[] siteCodeHeuristic = DEFAULT_SITE_CODE_HEURISTIC;
    protected String[] gainCodeHeuristic = DEFAULT_GAIN_CODE_HEURISTIC;
    protected String[] bandCodeHeuristic = DEFAULT_BAND_CODE_HEURISTIC;
    protected String[] orientationCodeHeuristic = DEFAULT_ORIENTATION_CODES;
    protected float maxDipOffset = 5.0f;
    private static Logger logger = LoggerFactory.getLogger((String)BestChannelUtil.class.getName());

    public float getMaxDipOffset() {
        return this.maxDipOffset;
    }

    public void setMaxDipOffset(float maxDipOffset) {
        this.maxDipOffset = maxDipOffset;
    }

    public String[] getOrientationCodeHeuristic() {
        return this.orientationCodeHeuristic;
    }

    public void setOrientationCodeHeuristic(String[] orientationCodes) {
        this.orientationCodeHeuristic = orientationCodes;
    }

    public void setSiteCodeHeuristic(String[] siteCodeHeuristic) {
        this.siteCodeHeuristic = siteCodeHeuristic;
    }

    public void setGainCodeHeuristic(String[] gainCodeHeuristic) {
        this.gainCodeHeuristic = gainCodeHeuristic;
    }

    public void setBandCodeHeuristic(String[] bandCodeHeuristic) {
        this.bandCodeHeuristic = bandCodeHeuristic;
    }

    public String[] getSiteCodeHeuristic() {
        return this.siteCodeHeuristic;
    }

    public String[] getGainCodeHeuristic() {
        return this.gainCodeHeuristic;
    }

    public String[] getBandCodeHeuristic() {
        return this.bandCodeHeuristic;
    }

    public Channel getBestVerticalChannel(List<Channel> inChanList) {
        return this.getBestChannel(this.getAllVertical(inChanList));
    }

    public Channel getBestChannel(List<Channel> inChanList) {
        for (int i = 0; i < this.siteCodeHeuristic.length; ++i) {
            ArrayList<Channel> siteChans = new ArrayList<Channel>();
            for (Channel c : inChanList) {
                if (!c.getLocCode().equals(this.siteCodeHeuristic[i])) continue;
                siteChans.add(c);
            }
            if (siteChans.size() == 0) continue;
            for (int j = 0; j < this.bandCodeHeuristic.length; ++j) {
                ArrayList<Channel> bandChans = new ArrayList<Channel>();
                for (Channel c : siteChans) {
                    if (!ChannelIdUtil.getBandCode(c.getCode()).equals(this.bandCodeHeuristic[j])) continue;
                    bandChans.add(c);
                }
                if (bandChans.size() == 0) continue;
                for (int k = 0; k < this.gainCodeHeuristic.length; ++k) {
                    ArrayList<Channel> gainChans = new ArrayList<Channel>();
                    for (Channel c : bandChans) {
                        if (!ChannelIdUtil.getGainCode(c.getCode()).equals(this.gainCodeHeuristic[k])) continue;
                        gainChans.add(c);
                    }
                    if (gainChans.size() == 0) continue;
                    for (int m = 0; m < this.orientationCodeHeuristic.length; ++m) {
                        for (Channel vChan : gainChans) {
                            if (!ChannelIdUtil.getOrientationCode(vChan.getCode()).equals(this.orientationCodeHeuristic[m])) continue;
                            return vChan;
                        }
                    }
                }
            }
        }
        if (inChanList.size() != 0) {
            return inChanList.get(0);
        }
        return null;
    }

    public Channel[] getBestMotionVector(List<Channel> inChanList) {
        for (int i = 0; i < this.siteCodeHeuristic.length; ++i) {
            ArrayList<Channel> siteChans = new ArrayList<Channel>();
            for (Channel siteChan : inChanList) {
                if (!siteChan.getLocCode().equals(this.siteCodeHeuristic[i])) continue;
                siteChans.add(siteChan);
            }
            if (siteChans.size() == 0) continue;
            for (int j = 0; j < this.bandCodeHeuristic.length; ++j) {
                ArrayList<Channel> bandChans = new ArrayList<Channel>();
                for (Channel c : siteChans) {
                    if (!ChannelIdUtil.getBandCode(c.getCode()).equals(this.bandCodeHeuristic[j])) continue;
                    bandChans.add(c);
                }
                if (bandChans.size() == 0) continue;
                for (int k = 0; k < this.gainCodeHeuristic.length; ++k) {
                    ArrayList<Channel> gainChans = new ArrayList<Channel>();
                    for (Channel c : bandChans) {
                        if (!ChannelIdUtil.getGainCode(c.getCode()).equals(this.gainCodeHeuristic[k])) continue;
                        gainChans.add(c);
                    }
                    if (gainChans.size() == 0) continue;
                    List<Channel> vList = this.getAllVertical(gainChans);
                    List<Channel> hList = this.getAllHorizontal(gainChans);
                    for (int m = 0; m < this.orientationCodeHeuristic.length; ++m) {
                        for (Channel vChan : vList) {
                            if (!ChannelIdUtil.getOrientationCode(vChan.getCode()).equals(this.orientationCodeHeuristic[m])) continue;
                            Channel[] out = new Channel[3];
                            out[0] = vChan;
                            int found = 1;
                            for (int n = 0; n < this.orientationCodeHeuristic.length; ++n) {
                                for (Channel hChan : hList) {
                                    if (!ChannelIdUtil.getOrientationCode(hChan.getCode()).equals(this.orientationCodeHeuristic[n])) continue;
                                    if (found == 2) {
                                        if (!this.arePerpendicular(out[1], hChan)) continue;
                                        out[found] = hChan;
                                        return out;
                                    }
                                    out[found] = hChan;
                                    ++found;
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private boolean arePerpendicular(Channel channel, Channel hChan) {
        return Math.abs(SphericalCoords.distance((double)channel.getDip().getValue(), (double)channel.getAzimuth().getValue(), (double)hChan.getDip().getValue(), (double)hChan.getAzimuth().getValue()) - 90.0) < (double)this.maxDipOffset;
    }

    public static List<Channel> pruneChannels(List<Channel> inChan, Instant when) {
        ArrayList<Channel> out = new ArrayList<Channel>();
        for (Channel c : inChan) {
            if (!when.isBefore(c.getEndDateTime()) || !when.isAfter(c.getStartDateTime())) continue;
            out.add(c);
        }
        return out;
    }

    public List<Channel> getAllHorizontal(List<Channel> inChan) {
        ArrayList<Channel> onlyHorizontal = new ArrayList<Channel>();
        for (Channel channel : inChan) {
            if (!(Math.abs(channel.getDip().getValue()) < this.maxDipOffset)) continue;
            onlyHorizontal.add(channel);
        }
        return onlyHorizontal;
    }

    public List<Channel> getAllVertical(List<Channel> inChan) {
        ArrayList<Channel> onlyVertical = new ArrayList<Channel>();
        for (Channel c : inChan) {
            if (!(Math.abs(c.getDip().getValue()) > 90.0f - this.maxDipOffset)) continue;
            onlyVertical.add(c);
        }
        return onlyVertical;
    }

    public static List<Channel> getAllBand(List<Channel> inChan, String bandCode) {
        ArrayList<Channel> out = new ArrayList<Channel>();
        for (Channel channel : inChan) {
            if (!ChannelIdUtil.getBandCode(channel.getCode()).equals(bandCode)) continue;
            out.add(channel);
        }
        return out;
    }

    private static Channel getChannelForOrientation(Channel[] group, String orientation, Channel matchThis) {
        return BestChannelUtil.getChannel(group, ChannelIdUtil.getBandCode(matchThis.getCode()), orientation, matchThis.getLocCode(), ChannelIdUtil.getGainCode(matchThis.getCode()));
    }

    public Channel[] getChannels(Channel[] staChans, String bc) {
        ArrayList<Channel> results = new ArrayList<Channel>();
        for (int i = 0; i < this.orientationCodeHeuristic.length; ++i) {
            String orientation = this.orientationCodeHeuristic[i];
            Channel chan = this.getChannel(staChans, bc, orientation);
            if (chan == null) continue;
            results.add(chan);
            for (int j = 0; j < this.orientationCodeHeuristic.length; ++j) {
                Channel additional;
                String subOrient = this.orientationCodeHeuristic[j];
                if (subOrient.equals(orientation) || (additional = BestChannelUtil.getChannelForOrientation(staChans, subOrient, chan)) == null) continue;
                results.add(additional);
            }
            break;
        }
        return results.toArray(new Channel[0]);
    }

    public Channel getChannel(Channel[] inChan, String bandCode, String orientationCode) {
        for (int h = 0; h < this.siteCodeHeuristic.length; ++h) {
            Channel tmpChannel = this.getChannel(inChan, bandCode, orientationCode, this.siteCodeHeuristic[h]);
            if (tmpChannel == null) continue;
            return tmpChannel;
        }
        return null;
    }

    public Channel getChannel(Channel[] inChan, String bandCode, String orientationCode, String siteCode) {
        for (int i = 0; i < this.gainCodeHeuristic.length; ++i) {
            Channel tmp = BestChannelUtil.getChannel(inChan, bandCode, orientationCode, siteCode, this.gainCodeHeuristic[i]);
            if (tmp == null) continue;
            return tmp;
        }
        for (int chanNum = 0; chanNum < inChan.length; ++chanNum) {
            if (!inChan[chanNum].getLocCode().equals(siteCode) || !inChan[chanNum].getCode().endsWith(orientationCode) || !inChan[chanNum].getCode().startsWith(bandCode)) continue;
            return inChan[chanNum];
        }
        return null;
    }

    public static Channel getChannel(Channel[] inChan, String bandCode, String orientationCode, String siteCode, String gainCode) {
        String desiredChannelCode = bandCode + gainCode + orientationCode;
        for (int chanNum = 0; chanNum < inChan.length; ++chanNum) {
            if (!inChan[chanNum].getLocCode().equals(siteCode) || !inChan[chanNum].getCode().equals(desiredChannelCode)) continue;
            return inChan[chanNum];
        }
        return null;
    }

    public static <T> List<T> asList(T ... elems) {
        return Arrays.asList(elems);
    }
}

