/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.sod.AbstractWaveformRecipe;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventPair;
import edu.sc.seis.sod.hibernate.eventpair.EventNetworkPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.subsetter.EventEffectiveTimeOverlap;
import edu.sc.seis.sod.util.display.EventUtil;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformArm
extends Thread
implements Arm {
    boolean active = true;
    protected static Instant lastECP = ClockUtil.now();
    AbstractWaveformRecipe recipe;
    private int processorNum;
    boolean lastWorkWasEvent = false;
    static int processorsWorking = 0;
    static int usedProcessorNum = 0;
    private static double retryPercentage = 0.01;
    private static double ecpPercentage = 0.001;
    private static Duration ECP_WINDOW = Duration.ofMinutes(5L);
    private static final Logger logger = LoggerFactory.getLogger(WaveformArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.WaveformArm");

    public WaveformArm(int nextProcessorNum, AbstractWaveformRecipe waveformRecipe) {
        super("WaveformArm " + nextProcessorNum);
        this.recipe = waveformRecipe;
        this.processorNum = nextProcessorNum;
    }

    boolean possibleToContinue() {
        return Start.getEventArm().isActive() && !Start.isArmFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        int noWorkLoopCounter = 0;
        logger.info("Starting WaveformArm");
        while (!Start.getNetworkArm().isInitialStartupFinished()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            SodDB.getSingleton().populateECPToDo();
            SodDB.getSingleton().populateESPToDo();
            SodDB.getSingleton().populateENPToDo();
            while (true) {
                block44: {
                    AbstractEventPair next = WaveformArm.getNext();
                    while (next == null && (this.possibleToContinue() || SodDB.getSingleton().isENPTodo() || SodDB.getSingleton().isESPTodo() || SodDB.getSingleton().getNumWorkUnits(Standing.RETRY) != 0 || SodDB.getSingleton().getNumWorkUnits(Standing.IN_PROG) != 0 || SodDB.getSingleton().getNumWorkUnits(Standing.INIT) != 0)) {
                        Object object;
                        block43: {
                            if (noWorkLoopCounter > 10) {
                                noWorkLoopCounter = 0;
                                logger.info("Processor waiting for work unit to show up: ptc= " + this.possibleToContinue() + " enp=" + SodDB.getSingleton().isENPTodo() + " esp=" + SodDB.getSingleton().isESPTodo() + " retry=" + (SodDB.getSingleton().getNumWorkUnits(Standing.RETRY) != 0) + " prog=" + (SodDB.getSingleton().getNumWorkUnits(Standing.IN_PROG) != 0) + " init=" + (SodDB.getSingleton().getNumWorkUnits(Standing.INIT) != 0));
                            } else {
                                logger.debug("Processor waiting for work unit to show up ");
                            }
                            try {
                                logger.debug("waiting on event arm");
                                object = Start.getEventArm();
                                synchronized (object) {
                                    Start.getEventArm().notifyAll();
                                }
                                if (!this.possibleToContinue()) break block43;
                                object = Start.getEventArm().getWaveformArmSync();
                                synchronized (object) {
                                    SodDB.rollback();
                                    Start.getEventArm().getWaveformArmSync().wait(120000L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        logger.debug("done waiting on event arm");
                        object = Start.getEventArm();
                        synchronized (object) {
                            Start.getEventArm().notifyAll();
                        }
                        next = WaveformArm.getNext();
                        if (next == null && SodDB.getSingleton().getNumWorkUnits(Standing.INIT) > 0) {
                            logger.debug("next null, so try get from DB, work=" + SodDB.getSingleton().getNumWorkUnits(Standing.INIT));
                            logger.debug(" work in prog " + SodDB.getSingleton().getNumWorkUnits(Standing.IN_PROG));
                            logger.debug(" work reject " + SodDB.getSingleton().getNumWorkUnits(Standing.REJECT));
                            logger.debug(" work success " + SodDB.getSingleton().getNumWorkUnits(Standing.SUCCESS));
                            next = SodDB.getSingleton().getNextECP();
                            continue;
                        }
                        logger.debug("next null, not try get from DB " + (next == null) + " && " + SodDB.getSingleton().getNumWorkUnits(Standing.INIT) + " > 0");
                        object = Start.getEventArm().getWaveformArmSync();
                        synchronized (object) {
                            Start.getEventArm().getWaveformArmSync().wait(2000L);
                        }
                    }
                    if (next == null) {
                        for (int i = 0; i < 5 && (next = WaveformArm.getNext()) == null; ++i) {
                            logger.debug("next is null, slwwp for a sec and try again...");
                            Thread.sleep(1000L);
                        }
                    }
                    if (next != null) {
                        noWorkLoopCounter = 0;
                        WaveformArm.processorStartWork();
                        try {
                            next.run();
                            break block44;
                        }
                        catch (Throwable t) {
                            SodDB.rollback();
                            next.update(t, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SYSTEM_FAILURE));
                            if (Start.getArgs().isQuitOnError()) {
                                Start.armFailure(this, t);
                            }
                            break block44;
                        }
                    }
                    logger.info("No work to do, quiting processing: " + this.possibleToContinue() + " " + (SodDB.getSingleton().getNumWorkUnits(Standing.RETRY) != 0) + " " + (SodDB.getSingleton().getNumWorkUnits(Standing.IN_PROG) != 0));
                    return;
                }
                SodDB.commit();
                WaveformArm.processorFinishWork();
                continue;
                break;
            }
            catch (Throwable t) {
                GlobalExceptionHandler.handle(t);
                Start.armFailure(this, t);
                this.active = false;
                OutputScheduler outputScheduler = OutputScheduler.getDefault();
                synchronized (outputScheduler) {
                    OutputScheduler.getDefault().notifyAll();
                }
            }
        }
        finally {
            this.active = false;
            OutputScheduler outputScheduler = OutputScheduler.getDefault();
            synchronized (outputScheduler) {
                OutputScheduler.getDefault().notifyAll();
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected static synchronized AbstractEventPair getNext() {
        EventStationPair esp;
        double retryRandom = Math.random();
        AbstractEventChannelPair ecp = null;
        if (retryRandom < WaveformArm.getRetryPercentage() && (ecp = SodDB.getSingleton().getNextRetryECPFromCache()) != null) {
            return ecp;
        }
        if (retryRandom > ecpPercentage) {
            EventNetworkPair enp;
            if (SodDB.getSingleton().isECPTodo() && (ecp = SodDB.getSingleton().getNextECPFromCache()) != null) {
                ecp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                ecp = (AbstractEventChannelPair)SodDB.getSession().merge((Object)ecp);
                return ecp;
            }
            if (SodDB.getSingleton().isESPTodo() && (esp = SodDB.getSingleton().getNextESPFromCache()) != null) {
                esp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                esp = (EventStationPair)SodDB.getSession().merge((Object)esp);
                return esp;
            }
            if (SodDB.getSingleton().isENPTodo() && (enp = SodDB.getSingleton().getNextENPFromCache()) != null) {
                enp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                enp = (EventNetworkPair)SodDB.getSession().merge((Object)enp);
                return enp;
            }
        }
        if (retryRandom < ecpPercentage) {
            if (!SodDB.getSingleton().isECPTodo()) {
                SodDB.getSingleton().populateECPToDo();
            }
            if (SodDB.getSingleton().isECPTodo() && (ecp = SodDB.getSingleton().getNextECPFromCache()) != null) {
                ecp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                ecp = (AbstractEventChannelPair)SodDB.getSession().merge((Object)ecp);
                return ecp;
            }
        }
        if ((esp = SodDB.getSingleton().getNextESP()) != null) {
            esp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
            SodDB.commit();
            SodDB.getSession().update((Object)esp);
            return esp;
        }
        EventNetworkPair enp = SodDB.getSingleton().getNextENP();
        if (enp != null) {
            enp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
            SodDB.commit();
            SodDB.getSession().update((Object)enp);
            return enp;
        }
        StatefulEvent ev = StatefulEventDB.getSingleton().getNext(Standing.INIT);
        if (ev != null) {
            WaveformArm.createEventNetworkPairs(ev);
            enp = SodDB.getSingleton().getNextENP();
            if (enp != null) {
                enp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                SodDB.getSession().update((Object)enp);
                return enp;
            }
        }
        return SodDB.getSingleton().getNextRetryECPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createEventNetworkPairs(StatefulEvent ev) {
        EventEffectiveTimeOverlap overlap;
        logger.debug("Work on event: " + ev.getDbid() + " " + EventUtil.getEventInfo(ev));
        StatefulEventDB eventDb = StatefulEventDB.getSingleton();
        SodDB sodDb = SodDB.getSingleton();
        ev.setStatus(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
        eventDb.getSession().saveOrUpdate((Object)ev);
        eventDb.commit();
        eventDb.getSession().load((Object)ev, (Serializable)Integer.valueOf(ev.getDbid()));
        try {
            if (ev.get_preferred_origin().getOriginTime() == null) {
                throw new RuntimeException("otime is null " + String.valueOf(ev.get_preferred_origin().getLocation()));
            }
            overlap = new EventEffectiveTimeOverlap(ev);
        }
        catch (NoPreferredOrigin e) {
            throw new RuntimeException("Should never happen...", e);
        }
        List<Network> networks = Start.getNetworkArm().getSuccessfulNetworks();
        if (networks.size() == 0 && !Start.isArmFailure()) {
            throw new RuntimeException("No successful networks!");
        }
        int numENP = 0;
        ArrayList<EventNetworkPair> enpList = new ArrayList<EventNetworkPair>();
        for (Network net : networks) {
            if (overlap.overlaps(net)) {
                EventNetworkPair p;
                try {
                    p = new EventNetworkPair(ev, NetworkDB.getSingleton().getNetwork(net.getDbid()));
                }
                catch (NotFound e) {
                    throw new RuntimeException("Should never happen, but I guess it just did!", e);
                }
                enpList.add(p);
                ++numENP;
                logger.debug("Put EventNetworkPair: " + String.valueOf(p));
                continue;
            }
            failLogger.info("Network " + net.toString() + " does not overlap event " + String.valueOf(ev));
        }
        logger.debug("Insert " + numENP + " EventNetworkPairs for " + String.valueOf(ev));
        Class<WaveformArm> clazz = WaveformArm.class;
        synchronized (WaveformArm.class) {
            ev.setStatus(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS));
            logger.debug("update event stations: " + String.valueOf(ev));
            for (EventNetworkPair pair : enpList) {
                SodDB.getSession().save((Object)pair);
            }
            eventDb.commit();
            sodDb.offerEventNetworkPairs(enpList);
            // ** MonitorExit[var7_8] (shouldn't be in output)
            Start.getEventArm().change(ev);
            int numWaiting = eventDb.getNumWaiting();
            if (numWaiting < EventArm.MIN_WAIT_EVENTS) {
                logger.debug("There are less than " + EventArm.MIN_WAIT_EVENTS + " waiting events.  Telling the eventArm to start up again");
                EventArm eventArm = Start.getEventArm();
                synchronized (eventArm) {
                    Start.getEventArm().notifyAll();
                }
            }
            return;
        }
    }

    public int getProcessorNum() {
        return this.processorNum;
    }

    public AbstractWaveformRecipe getRecipe() {
        return this.recipe;
    }

    public static int getProcessorsWorking() {
        return processorsWorking;
    }

    static void processorStartWork() {
        ++processorsWorking;
    }

    static void processorFinishWork() {
        --processorsWorking;
    }

    static int nextProcessorNum() {
        return usedProcessorNum++;
    }

    private static double getRetryPercentage() {
        return retryPercentage;
    }
}

