/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.retry.ClassicRetryStrategy;
import edu.sc.seis.sod.source.AbstractSource;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserReportRetryStrategy
extends ClassicRetryStrategy {
    private Object addlInfo;
    private Set<String> bustedServers = new HashSet<String>();
    private static final Logger logger = LoggerFactory.getLogger(UserReportRetryStrategy.class);

    public UserReportRetryStrategy(int numRetries, String additionalInfo) {
        super(numRetries);
        this.addlInfo = additionalInfo;
    }

    public UserReportRetryStrategy(int numRetries) {
        this(numRetries, "");
    }

    public UserReportRetryStrategy() {
        this(UserReportRetryStrategy.getDefaultNumRetry());
    }

    @Override
    public synchronized boolean shouldRetry(Throwable exc, Object server, int tryCount) {
        String serverId = this.makeServerId(server);
        if (!this.bustedServers.contains(serverId)) {
            if (Start.getArgs().isQuitOnError()) {
                this.print("The " + serverId + " server just produced an error (" + exc.getClass().getName() + ").  SOD will quit due to the --quitOnError switch.  " + String.valueOf(this.addlInfo));
                System.exit(1);
            } else {
                this.print("The " + serverId + " server just produced an error (" + exc.getClass().getName() + " " + exc.getMessage() + ").  SOD will continue trying it until it recovers at which point an all clear message will be issued.  If it never recovers, email sod@seis.sc.edu with this report and we can inform the server maintainer.  If you're tired of waiting, press Ctrl-C to quit.  " + String.valueOf(this.addlInfo));
            }
            logger.info(serverId + " error ", exc);
            this.bustedServers.add(serverId);
        }
        return super.shouldRetry(exc, server, tryCount);
    }

    @Override
    public synchronized void serverRecovered(Object server) {
        String serverId = this.makeServerId(server);
        if (this.bustedServers.contains(serverId)) {
            this.bustedServers.remove(serverId);
            this.print("All clear!  " + serverId + " just recovered.  Processing will continue normally.");
        }
    }

    private void print(String msg) {
        logger.warn(msg);
    }

    private String makeServerId(Object server) {
        if (server instanceof AbstractSource) {
            return ((AbstractSource)server).getName();
        }
        return server.toString();
    }
}

