/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventNetworkPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.TimerTask;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalLoserEventCleaner
extends TimerTask {
    Duration lagInterval;
    private static final Logger logger = LoggerFactory.getLogger(TotalLoserEventCleaner.class);
    private static final long ONE_WEEK = 604800000L;

    public TotalLoserEventCleaner(Duration duration) {
        this.lagInterval = duration;
    }

    @Override
    public void run() {
        try {
            logger.info("Working");
            Instant ageAgo = ClockUtil.now().minus(this.lagInterval);
            Duration littleSkip = Duration.ofMinutes(10L);
            TotalLoserEventCleaner.cleanEvents(ageAgo);
            StatefulEventDB.getSingleton().commit();
            logger.info("Cleaned events");
            ageAgo = ageAgo.plus(littleSkip);
            TotalLoserEventCleaner.cleanECP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-channel pairs");
            TotalLoserEventCleaner.cleanEVP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-vector pairs");
            ageAgo = ageAgo.plus(littleSkip);
            TotalLoserEventCleaner.cleanESP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-station pairs");
            ageAgo = ageAgo.plus(littleSkip);
            TotalLoserEventCleaner.cleanENP(ageAgo);
            SodDB.getSingleton();
            SodDB.commit();
            logger.info("Cleaned event-network pairs");
        }
        catch (Throwable e) {
            try {
                StatefulEventDB.getSingleton().rollback();
            }
            catch (Throwable e1) {
                GlobalExceptionHandler.handle(e1);
            }
            GlobalExceptionHandler.handle(e);
        }
    }

    public static void cleanEvents(Instant ageAgo) {
        Query q = StatefulEventDB.getSingleton().getSession().createQuery(" from " + StatefulEvent.class.getName() + " e  where e.status.standingInt = " + Standing.REJECT.getVal() + " and e.preferred.originTime.time < :ageAgo");
        q.setParameter("ageAgo", (Object)ageAgo);
        Iterator it = q.iterate();
        int counter = 0;
        while (it.hasNext()) {
            StatefulEvent se = (StatefulEvent)it.next();
            StatefulEventDB.getSingleton().getSession().delete((Object)se);
            ++counter;
        }
        StatefulEventDB.getSingleton().commit();
        logger.debug("Done, deleted " + counter + " events.");
    }

    public static void cleanESP(Instant ageAgo) {
        TotalLoserEventCleaner.clean(EventStationPair.class, ageAgo);
    }

    public static void cleanENP(Instant ageAgo) {
        TotalLoserEventCleaner.clean(EventNetworkPair.class, ageAgo);
    }

    public static void cleanECP(Instant ageAgo) {
        TotalLoserEventCleaner.clean(EventChannelPair.class, ageAgo);
    }

    public static void cleanEVP(Instant ageAgo) {
        TotalLoserEventCleaner.clean(EventVectorPair.class, ageAgo);
    }

    public static void clean(Class eventPairClass, Instant ageAgo) {
        SodDB.getSingleton();
        Query q = SodDB.getSession().createQuery("delete " + eventPairClass.getName() + " ep where ep.status.standingInt = " + Standing.REJECT.getVal() + " and ep.lastQuery < :ageAgo");
        q.setParameter("ageAgo", (Object)ageAgo);
        int deleted = q.executeUpdate();
        SodDB.getSingleton();
        SodDB.commit();
        logger.info("delete " + deleted + " old " + eventPairClass.getName());
    }
}

