/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.sod.AbstractWaveformRecipe;
import edu.sc.seis.sod.Args;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.LocalSeismogramArm;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.PeriodicCheckpointer;
import edu.sc.seis.sod.RunProperties;
import edu.sc.seis.sod.SimpleErrorHandler;
import edu.sc.seis.sod.SodConfig;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.TotalLoserEventCleaner;
import edu.sc.seis.sod.UpdateChecker;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.UserReportRetryStrategy;
import edu.sc.seis.sod.VersionHistory;
import edu.sc.seis.sod.WaveformArm;
import edu.sc.seis.sod.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.hibernate.ConnMgr;
import edu.sc.seis.sod.hibernate.HibernateUtil;
import edu.sc.seis.sod.hibernate.InstrumentationDB;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NetworkNotFound;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.model.common.ToDoException;
import edu.sc.seis.sod.model.common.Version;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.retry.RetryStrategy;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.util.exceptionHandler.Extractor;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.exceptionHandler.QuitOnExceptionPostProcess;
import edu.sc.seis.sod.util.exceptionHandler.SystemOutReporter;
import edu.sc.seis.sod.util.exceptionHandler.WindowConnectionInterceptor;
import edu.sc.seis.sod.util.time.ClockUtil;
import edu.sc.seis.sod.validator.Validator;
import edu.sc.seis.sod.web.WebAdmin;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.exception.MethodInvocationException;
import org.hibernate.JDBCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Start {
    protected String HSQL_FILE_URL = "jdbc:hsqldb:file:";
    private boolean commandLineToolRun;
    private InputSourceCreator creator;
    private static Args args;
    private static SystemOutReporter sysOutReporter;
    private static boolean armFailure;
    public static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static Element config;
    private static Logger logger;
    private static WaveformArm[] waveforms;
    private static AbstractWaveformRecipe waveformRecipe;
    private static Properties props;
    private static RunProperties runProps;
    private static EventArm event;
    protected static NetworkArm network;
    private static String configFileName;
    private static String commandName;
    private static Instant startTime;
    private static WebAdmin webAdmin;
    private static String DATABASE_DIR;
    public static final String DBURL_KEY = "hibernate.connection.url";
    public static boolean RUN_ARMS;
    private static List armListeners;
    public static final String TUTORIAL_LOC = "jar:edu/sc/seis/sod/data/configFiles/demo.xml";
    public static final String DEFAULT_PROPS = "edu/sc/seis/sod/data/sod.prop";

    public Start(Args args) throws Exception {
        this(args, new InputSourceCreator(), null, false);
    }

    public Start(Args args, InputSourceCreator sourceMaker, Properties props, boolean commandLineToolRun) throws Exception {
        Start.args = args;
        this.creator = sourceMaker;
        this.commandLineToolRun = commandLineToolRun;
        configFileName = args.getRecipe();
        if (props == null) {
            this.loadProps();
        } else {
            Start.props = props;
        }
        try {
            Start.setConfig(Start.createDoc(sourceMaker.create(), configFileName).getDocumentElement());
        }
        catch (IOException io) {
            Start.informUserOfBadFileAndExit(configFileName);
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle("Trouble creating xml document", e);
        }
        logger.info("logging configured");
        logger.info("SOD version " + VersionHistory.current().getVersion());
        logger.info("Args: " + args.toString());
        logger.info("Recipe: " + configFileName);
        if (args.isQuitOnError()) {
            GlobalExceptionHandler.add(new QuitOnExceptionPostProcess(Throwable.class));
        }
        if (!commandLineToolRun) {
            this.validate(sourceMaker);
        }
        if (args.isPrintRecipe()) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(Start.createInputStream(configFileName)));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
            System.out.flush();
            System.exit(0);
        }
        if (args.isQuickAndDirty()) {
            Start.props.put(DBURL_KEY, "jdbc:hsqldb:mem:SodDB");
            logger.info("Database: memory");
        } else {
            logger.info("Database: " + String.valueOf(Start.props.get(DBURL_KEY)));
        }
        ConnMgr.setURL(Start.props.getProperty(DBURL_KEY));
        if (ConnMgr.getURL().startsWith(this.HSQL_FILE_URL)) {
            File dbFile = new File(ConnMgr.getURL().substring(this.HSQL_FILE_URL.length()) + ".log");
            if (dbFile.exists()) {
                logger.info("Database file exists: " + dbFile.getPath());
            } else {
                logger.info("Database file does not exist, clean start.");
            }
            NetworkDB.instrumentationDB = new InstrumentationDB(new File(dbFile.getParentFile(), "Response"));
        }
        Start.parseArms(config.getChildNodes());
    }

    private void validate(InputSourceCreator sourceMaker) {
        try {
            logger.info("validating recipe...");
            Validator validator = new Validator("edu/sc/seis/sod/data/sod.rng");
            if (!validator.validate(sourceMaker.create())) {
                logger.info("Invalid recipe file!");
                this.allHopeAbandon(validator.getErrorMessage());
            } else {
                logger.info("Congratulations, valid recipe.");
                if (!args.isPrintRecipe()) {
                    System.out.println("Congratulations, valid recipe.");
                }
            }
            if (args.onlyValidate()) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle("Problem configuring schema validator", e);
            Start.exit("Problem configuring schema validator: " + e.getMessage());
        }
    }

    private static void informUserOfBadFileAndExit(String confFilename) {
        File configFile = new File(confFilename);
        System.err.println("You told SOD to use " + configFile.getAbsolutePath() + " as its recipe file");
        if (configFile.exists()) {
            System.err.println("SOD was unable to open it.  Make sure the file is readable.");
        } else {
            System.err.println("SOD could find no such file.  Make sure the file exists");
        }
        System.exit(0);
    }

    public static void informUserOfBadNetworkAndExit(String networkCode, NetworkNotFound nnf) {
        logger.error("Can't find " + networkCode + " network from server", (Throwable)nnf);
        String msg = "You told SOD to use the '" + networkCode + "' network, but the server does not think it exists.";
        Start.informUserOfBadQueryAndExit(msg, nnf);
    }

    public static void informUserOfBadQueryAndExit(String message, Exception e) {
        logger.error(message, (Throwable)e);
        System.err.println();
        System.err.println(message);
        System.err.println();
        System.err.println("    SOD is now cowardly quitting.");
        armFailure = true;
        Start.wakeUpAllArms();
    }

    public static Instant getStartTime() {
        return startTime;
    }

    public static Duration getElapsedTime() {
        return Duration.between(startTime, ClockUtil.now());
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public void setupDatabaseForUnitTests() throws ConfigurationException {
        this.initDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDatabase() throws ConfigurationException {
        this.warnIfDatabaseExists();
        Class<HibernateUtil> clazz = HibernateUtil.class;
        synchronized (HibernateUtil.class) {
            Iterator it = Start.getRunProps().getHibernateConfig().iterator();
            if (it.hasNext()) {
                String res = (String)it.next();
                logger.debug("Adding resource to HibernateUtil:  " + res);
                throw new ToDoException("Adding hibernate configs not supported yet");
            }
            HibernateUtil.setUp(props, this.getClass().getResource("/edu/sc/seis/sod/data/ehcache.xml"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                HibernateUtil.deploySchema(true);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to set up database", e);
            }
            SodDB sodDb = SodDB.getSingleton();
            sodDb.commit();
            return;
        }
    }

    protected void warnIfDatabaseExists() {
        File dbFile;
        if (!args.isContinue() && Start.getRunProps().warnIfDatabaseExists() && props.getProperty(DBURL_KEY).startsWith(this.HSQL_FILE_URL) && (dbFile = new File(ConnMgr.getURL().substring(this.HSQL_FILE_URL.length()) + ".log")).exists()) {
            this.allHopeAbandon("The database for this run, " + String.valueOf(dbFile) + " appears to already exist. This is fine if you want to restart a run that crashed, but if you are trying to start a fresh SOD run, you may wish to delete this database directory first. Otherwise, SOD will consider any work in this database as already completed and will not redo it.");
        }
    }

    public static void loadProps(InputStream propStream, Properties baseProps) throws IOException {
        baseProps.load(propStream);
        propStream.close();
    }

    private void loadProps() throws IOException {
        Start.loadProps(Start.class.getClassLoader().getResourceAsStream(DEFAULT_PROPS), props);
        if (args.hasProps()) {
            try {
                Start.loadProps(args.getProps(), props);
            }
            catch (IOException io) {
                System.err.println("Unable to load props file: " + io.getMessage());
                System.err.println("Quitting until the error is corrected");
                System.exit(1);
            }
        }
        if (args.isDebug()) {
            String rootCat = props.getProperty("log4j.rootCategory");
            if (rootCat != null && rootCat.length() > 0 && rootCat.contains(",")) {
                String head = rootCat.substring(0, rootCat.indexOf(44));
                String tail = rootCat.substring(rootCat.indexOf(44));
                props.setProperty("log4j.rootCategory", "debug" + tail);
                logger.info("--debug so resetting log4j.rootCategory from '" + rootCat + "' to '" + props.getProperty("log4j.rootCategory") + "'");
            } else {
                props.setProperty("log4j.rootCategory", "debug, R, C, E");
            }
        }
        PropertyConfigurator.configure((Properties)props);
        GlobalExceptionHandler.remove(sysOutReporter);
    }

    public static InputSource createInputSource(ClassLoader cl, String loc) throws IOException {
        return new InputSource(new InputStreamReader(Start.createInputStream(cl, loc)));
    }

    public static InputStream createInputStream(String loc) throws IOException, MalformedURLException, FileNotFoundException {
        return Start.createInputStream(Start.class.getClassLoader(), loc);
    }

    public static InputStream createInputStream(ClassLoader cl, String loc) throws IOException, MalformedURLException, FileNotFoundException {
        InputStream in = null;
        if (loc.startsWith("http:") || loc.startsWith("ftp:")) {
            in = new URL(loc).openConnection().getInputStream();
        } else if (loc.startsWith("jar:")) {
            URL url = SodUtil.getUrl(cl, loc);
            in = url.openConnection().getInputStream();
        } else {
            in = new FileInputStream(loc);
        }
        if (in == null) {
            throw new IOException("Unable to load configuration file " + loc);
        }
        return new BufferedInputStream(in);
    }

    public static RetryStrategy createRetryStrategy(int numRetries) {
        if (commandName.equals("sod")) {
            return new UserReportRetryStrategy(numRetries, "SOD will pick up where it left off when restarted.");
        }
        return new UserReportRetryStrategy(numRetries);
    }

    public static void setCommandName(String name) {
        commandName = name;
    }

    public static void setConfig(Element config) {
        Start.config = config;
    }

    public static AbstractWaveformRecipe getWaveformRecipe() {
        return waveformRecipe;
    }

    public static EventArm getEventArm() {
        return event;
    }

    public static NetworkArm getNetworkArm() {
        return network;
    }

    @Deprecated
    public static WaveformArm[] getWaveformArms() {
        return waveforms;
    }

    public static WaveformArm[] getWaveformArmArray() {
        return waveforms;
    }

    public static RunProperties getRunProps() {
        if (runProps == null) {
            try {
                runProps = new RunProperties();
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return runProps;
    }

    public static Document createDoc(InputSource source, String filename) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SimpleErrorHandler(filename));
        Document doc = builder.parse(source);
        return doc;
    }

    public void start() throws Exception {
        startTime = Instant.now();
        if (runProps.removeDatabase() || Start.getArgs().isClean()) {
            this.cleanHSQLDatabase();
        }
        this.initDatabase();
        if (!this.commandLineToolRun) {
            new UpdateChecker(false);
            this.handleStartupRunProperties();
            this.checkDBVersion();
            this.checkConfig(this.creator.create());
        }
        if (args.isStatusUnsecure()) {
            Start.getRunProps().setStatusUnsecure(true);
        }
        if (args.isStatus()) {
            Start.getRunProps().setStatusWebKeepAlive(true);
        }
        if (args.isStatus() || Start.getRunProps().isStatusWebKeepAlive()) {
            webAdmin = new WebAdmin();
            Start.add(webAdmin);
            webAdmin.start();
        }
        this.startArms();
        if (!this.commandLineToolRun) {
            if (runProps.checkpointPeriodically()) {
                new PeriodicCheckpointer();
            }
            if (runProps.loserEventCleaner()) {
                TotalLoserEventCleaner loserCleaner = new TotalLoserEventCleaner(Start.getRunProps().getEventLag());
                Timer t = new Timer("TotalLoserCleaner", true);
                t.schedule((TimerTask)loserCleaner, 0L, 604800000L);
            }
        }
    }

    public void allHopeAbandon(String message) {
        logger.info("All hope abandon: " + message);
        System.err.println();
        System.err.println("******************************************************************");
        System.err.println();
        System.err.println(message);
        System.err.println();
        System.err.println("     All hope abandon, ye who enter in!");
        System.err.println();
        System.err.println("******************************************************************");
        if (args.waitOnError()) {
            System.err.println();
            for (int i = 10; i >= 0; --i) {
                try {
                    Thread.sleep(1000L);
                    System.err.print(" " + i);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        System.err.println();
        System.err.println();
        System.err.println("And lo! towards us coming in a boat");
        System.err.println("  An old man, hoary with the hair of eld,");
        System.err.println("  Crying: \"Woe unto you, ye souls depraved!");
        System.err.println("");
        System.err.println("Hope nevermore to look upon the heavens;");
        System.err.println("  I come to lead you to the other shore,");
        System.err.println("  To the eternal shades in heat and frost.\"");
        System.err.println();
        System.err.println();
        System.err.println(" ...a brave soul trudges on.");
    }

    static void parseArms(NodeList armNodes) throws Exception {
        runProps = new RunProperties();
        waveforms = new WaveformArm[0];
        for (int i = 0; i < armNodes.getLength(); ++i) {
            if (!(armNodes.item(i) instanceof Element)) continue;
            Element el = (Element)armNodes.item(i);
            if (el.getTagName().equals("properties")) {
                runProps.addProperties(el);
                continue;
            }
            if (el.getTagName().equals("eventArm") && args.doEventArm()) {
                event = new EventArm(el);
                continue;
            }
            if (el.getTagName().equals("networkArm") && args.doNetArm()) {
                network = new NetworkArm(el);
                continue;
            }
            if (!el.getTagName().startsWith("waveform") || !args.doWaveformArm()) continue;
            if (el.getTagName().equals("waveformVectorArm")) {
                SodDB.setDefaultEcpClass(EventVectorPair.class);
                waveformRecipe = new MotionVectorArm(el);
                continue;
            }
            if (el.getTagName().equals("waveformArm")) {
                SodDB.setDefaultEcpClass(EventChannelPair.class);
                waveformRecipe = new LocalSeismogramArm(el);
                continue;
            }
            throw new ConfigurationException("unknown waveform arm type: " + el.getTagName());
        }
    }

    private void startArms() throws Exception {
        if (waveformRecipe != null) {
            if (runProps.reopenSuspended()) {
                Runnable reopenEvents = new Runnable(){

                    @Override
                    public void run() {
                        SodDB.getSingleton().reopenSuspendedEventChannelPairs(Start.getRunProps().getEventChannelPairProcessing(), waveformRecipe instanceof LocalSeismogramArm);
                        SodDB.commit();
                    }
                };
                Thread t = new Thread(reopenEvents, "Reopen Suspended ECPS");
                t.start();
            }
            StatefulEventDB eventDb = StatefulEventDB.getSingleton();
            StatefulEvent ev = eventDb.getNext(Standing.IN_PROG);
            while (ev != null) {
                WaveformArm.createEventNetworkPairs(ev);
                ev = eventDb.getNext(Standing.IN_PROG);
            }
            eventDb.commit();
            int poolSize = runProps.getNumWaveformWorkerThreads();
            poolSize = 1;
            waveforms = new WaveformArm[poolSize];
            for (int j = 0; j < waveforms.length; ++j) {
                Start.waveforms[j] = new WaveformArm(j, waveformRecipe);
            }
            Timer retryTimer = new Timer("retry loader", true);
            retryTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!SodDB.getSingleton().isESPTodo()) {
                        SodDB.getSingleton().populateRetryToDo();
                        SodDB.rollback();
                    }
                }
            }, 0L, 600000L);
        }
        if (waveformRecipe == null && event != null) {
            event.setWaitForWaveformProcessing(false);
        }
        if (RUN_ARMS) {
            OutputScheduler.getDefault();
            this.startArm(network, "NetworkArm");
            this.startArm(event, "EventArm");
            for (int i = 0; i < waveforms.length; ++i) {
                this.startArm(waveforms[i], waveforms[i].getName());
            }
        }
        Iterator iter = armListeners.iterator();
        while (iter.hasNext()) {
            ((ArmListener)iter.next()).started();
        }
    }

    public static void add(ArmListener listener) {
        armListeners.add(listener);
    }

    private void startArm(Arm arm, String name) throws ConfigurationException {
        if (arm != null) {
            for (ArmListener element : armListeners) {
                element.starting(arm);
            }
            new Thread((Runnable)arm, arm.getName()).start();
            logger.debug(name + " started");
        } else {
            logger.debug(name + " doesn't exist");
        }
    }

    void cleanHSQLDatabase() {
        String dbUrl = ConnMgr.getURL();
        if (!dbUrl.startsWith("jdbc:hsqldb") || dbUrl.indexOf("hsql://") != -1 || dbUrl.indexOf(DATABASE_DIR) == -1) {
            logger.warn("The database isn't the default local hsqldb, so it couldn't be deleted as specified by the properties");
            return;
        }
        File dbDir = new File(DATABASE_DIR);
        if (dbDir.exists()) {
            logger.info("Removing old database");
            File[] dbFiles = dbDir.listFiles();
            for (int i = 0; i < dbFiles.length; ++i) {
                if (dbFiles[i].delete()) continue;
                logger.warn("Unable to delete " + String.valueOf(dbFiles[i]) + " when removing the previous database.  The old database might still exist");
            }
            if (!dbDir.delete()) {
                logger.warn("Unable to delete the database directory.");
            }
        }
    }

    private void handleStartupRunProperties() {
        if (runProps.reopenEvents()) {
            StatefulEventDB eventDb = StatefulEventDB.getSingleton();
            eventDb.restartCompletedEvents();
        }
    }

    private void checkDBVersion() {
        SodDB sodDb = SodDB.getSingleton();
        try {
            logger.debug("SodDB in check DBVersion:" + String.valueOf(sodDb));
            Version dbVersion = sodDb.getDBVersion();
            SodDB.commit();
            if (dbVersion == null) {
                throw new RuntimeException("db version is null");
            }
            if (VersionHistory.hasSchemaChangedSince(dbVersion.getVersion())) {
                System.err.println("SOD version: " + VersionHistory.current().getVersion());
                System.err.println("Database version: " + dbVersion.getVersion());
                System.err.println("Your database was created with an older version of SOD.");
                this.allHopeAbandon("There has been a change in the database structure since the database was created!  Continuing this sod run is not advisable!");
            }
        }
        catch (Exception e) {
            logger.error("exception", (Throwable)e);
            SodDB.rollback();
            GlobalExceptionHandler.handle("Trouble checking database version", e);
        }
    }

    private void checkConfig(InputSource is) {
        SodDB sodDb = SodDB.getSingleton();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            SodConfig conf = new SodConfig(new BufferedReader(is.getCharacterStream()));
            SodConfig dbConfig = sodDb.getCurrentConfig();
            if (dbConfig == null) {
                sodDb.putConfig(conf);
            } else if (!dbConfig.getConfig().equals(conf.getConfig())) {
                if (args.replaceDBConfig()) {
                    sodDb.putConfig(conf);
                } else {
                    this.allHopeAbandon("Your config file has changed since your last run.  It may not be advisable to continue this SOD run.");
                }
            }
            SodDB.commit();
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle("Trouble checking stored config file", e);
            SodDB.rollback();
        }
    }

    public static Args getArgs() {
        return args;
    }

    public static Element getConfig() {
        return config;
    }

    public static void checkGCJ() {
        if (System.getProperty("java.vm.name").equals("GNU libgcj")) {
            System.err.println("You are running GNU's version of Java, gcj, which doesn't have all the features SOD requires.  Instead, use Sun's Java from http://java.sun.com.");
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        try {
            Start.checkGCJ();
            GlobalExceptionHandler.add(new WindowConnectionInterceptor());
            GlobalExceptionHandler.add(sysOutReporter);
            BasicConfigurator.configure();
            Start start = new Start(new Args(args));
            logger.info("Start start()");
            start.start();
        }
        catch (UserConfigurationException e) {
            logger.error("User configuration problem, quiting", (Throwable)e);
            Start.exit(e.getMessage() + "  SOD will quit now and continue to cowardly quit until this is corrected.");
        }
        catch (Throwable e) {
            GlobalExceptionHandler.handle("Problem in main, quiting", e);
            Start.exit("Quitting due to error: " + e.getMessage());
        }
        logger.info("Finished starting all threads.");
        if (webAdmin != null) {
            try {
                webAdmin.join();
            }
            catch (InterruptedException e) {
                logger.warn("WebAdmin interrupted.", (Throwable)e);
            }
        }
    }

    public static void exit(String reason) {
        System.err.println(reason);
        System.exit(1);
    }

    public static void add(Properties newProps) {
        props.putAll((Map<?, ?>)newProps);
    }

    public static void cataclysmicFailureOfUnbelievableProportions() {
        try {
            System.err.println("Oh boy, this is really bad. No, it is even worse then that.");
            logger.error("horror of horrors...");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(1);
    }

    public static void simpleArmFailure(Arm arm, String reason) {
        armFailure = true;
        logger.error("Arm " + arm.getName() + " failed: " + reason + " Sod is giving up and quiting.");
        logger.debug("Arm " + arm.getName() + " failure stack trace: " + reason, (Throwable)new Exception(reason));
        Start.wakeUpAllArms();
    }

    public static void armFailure(Arm arm, Throwable t) {
        armFailure = true;
        GlobalExceptionHandler.handle("Problem running " + arm.getName() + ", SOD is exiting abnormally. Please email this to the sod development team at sod@seis.sc.edu", t);
        logger.error("Arm " + arm.getName() + " failed. Sod is giving up and quiting", t);
        Start.wakeUpAllArms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wakeUpAllArms() {
        Arm arm;
        int i;
        Arm[] arms = new Arm[]{network, event};
        for (i = 0; i < arms.length; ++i) {
            if (arms[i] == null) continue;
            arm = arms[i];
            synchronized (arm) {
                arms[i].notifyAll();
                continue;
            }
        }
        for (i = 0; i < waveforms.length; ++i) {
            if (waveforms[i] == null) continue;
            arm = waveforms[i];
            synchronized (arm) {
                waveforms[i].notifyAll();
                continue;
            }
        }
        OutputScheduler outputScheduler = OutputScheduler.getDefault();
        synchronized (outputScheduler) {
            OutputScheduler.getDefault().notify();
        }
    }

    public static boolean isAnyWaveformArmActive() {
        for (int i = 0; i < waveforms.length; ++i) {
            if (!waveforms[i].isActive()) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmFailure() {
        return armFailure;
    }

    static {
        GlobalExceptionHandler.add(new Extractor(){

            @Override
            public boolean canExtract(Throwable throwable) {
                return throwable instanceof FDSNWSException;
            }

            @Override
            public String extract(Throwable throwable) {
                Object out = "";
                if (throwable instanceof FDSNWSException) {
                    FDSNWSException mie = (FDSNWSException)throwable;
                    out = (String)out + "URI: " + String.valueOf(mie.getTargetURI()) + "\n";
                }
                return out;
            }

            @Override
            public Throwable getSubThrowable(Throwable throwable) {
                return null;
            }
        });
        GlobalExceptionHandler.add(new Extractor(){

            @Override
            public boolean canExtract(Throwable throwable) {
                return throwable instanceof MethodInvocationException;
            }

            @Override
            public String extract(Throwable throwable) {
                Object out = "";
                if (throwable instanceof MethodInvocationException) {
                    MethodInvocationException mie = (MethodInvocationException)throwable;
                    out = (String)out + "Method Name: " + mie.getMethodName() + "\n";
                    out = (String)out + "reference Name: " + mie.getReferenceName() + "\n";
                }
                return out;
            }

            @Override
            public Throwable getSubThrowable(Throwable throwable) {
                if (throwable instanceof MethodInvocationException) {
                    return ((MethodInvocationException)throwable).getWrappedThrowable();
                }
                return null;
            }
        });
        GlobalExceptionHandler.add(new Extractor(){

            @Override
            public boolean canExtract(Throwable throwable) {
                return throwable instanceof JDBCException;
            }

            @Override
            public String extract(Throwable throwable) {
                Object out = "";
                if (throwable instanceof JDBCException) {
                    JDBCException mie = (JDBCException)throwable;
                    out = (String)out + mie.getMessage();
                    out = (String)out + "\nSQL: " + mie.getSQL();
                    out = (String)out + "\nSQLState: " + mie.getSQLState();
                    out = AbstractHibernateDB.isSessionOpen() ? (String)out + "\n\nSession:\n" + AbstractHibernateDB.getSession().toString() : (String)out + "\nSession: none\n";
                }
                return out;
            }

            @Override
            public Throwable getSubThrowable(Throwable throwable) {
                SQLException sub;
                if (throwable instanceof JDBCException && (sub = ((JDBCException)throwable).getSQLException()) != throwable) {
                    return sub;
                }
                return null;
            }
        });
        GlobalExceptionHandler.add(new Extractor(){

            @Override
            public boolean canExtract(Throwable throwable) {
                return throwable instanceof FDSNWSException;
            }

            @Override
            public String extract(Throwable throwable) {
                Object out = "";
                if (throwable instanceof FDSNWSException) {
                    FDSNWSException mie = (FDSNWSException)throwable;
                    out = (String)out + mie.getMessage();
                    out = (String)out + "\nURI: " + String.valueOf(mie.getTargetURI());
                }
                return out;
            }

            @Override
            public Throwable getSubThrowable(Throwable throwable) {
                return null;
            }
        });
        GlobalExceptionHandler.registerWithAWTThread();
        sysOutReporter = new SystemOutReporter();
        armFailure = false;
        logger = LoggerFactory.getLogger(Start.class);
        props = System.getProperties();
        commandName = "sod";
        DATABASE_DIR = "SodDb";
        RUN_ARMS = true;
        armListeners = new ArrayList();
    }

    public static class InputSourceCreator {
        public InputSource create() throws IOException {
            return Start.createInputSource(Start.class.getClassLoader(), configFileName);
        }
    }
}

