/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.BeginEndTimeRangeSupplier;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.MicroSecondDateSupplier;
import edu.sc.seis.sod.XMLUtil;
import edu.sc.seis.sod.model.common.BoxAreaImpl;
import edu.sc.seis.sod.model.common.GlobalAreaImpl;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnitRangeImpl;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.subsetter.LatitudeRange;
import edu.sc.seis.sod.subsetter.LongitudeRange;
import edu.sc.seis.sod.subsetter.origin.OriginPointDistance;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SodUtil {
    private static String baseName = "edu.sc.seis.sod";
    private static String[] basePackageNames = new String[]{"subsetter", "process", "status", "source"};
    public static final UnitImpl[] LENGTH_UNITS = new UnitImpl[]{UnitImpl.KILOMETER, UnitImpl.METER, UnitImpl.CENTIMETER, UnitImpl.NANOMETER, UnitImpl.MICROMETER, UnitImpl.MICRON, UnitImpl.MILLIMETER, UnitImpl.PICOMETER, UnitImpl.INCH, UnitImpl.FOOT, UnitImpl.MILE, UnitImpl.DEGREE, UnitImpl.RADIAN};
    public static final UnitImpl[] TIME_UNITS = new UnitImpl[]{UnitImpl.HOUR, UnitImpl.NANOSECOND, UnitImpl.MICROSECOND, UnitImpl.MILLISECOND, UnitImpl.SECOND, UnitImpl.MINUTE, UnitImpl.DAY, UnitImpl.WEEK, UnitImpl.FORTNIGHT};
    public static final UnitImpl[] FREQ_UNITS = new UnitImpl[]{UnitImpl.HERTZ};
    private static final Logger logger = LoggerFactory.getLogger(SodUtil.class);

    public static boolean isTrue(Element el, String tagName, boolean defaultResult) {
        Element booleanElement = SodUtil.getElement(el, tagName);
        if (booleanElement == null) {
            return defaultResult;
        }
        return SodUtil.isTrueText(SodUtil.getNestedText(booleanElement));
    }

    public static boolean isTrueText(String nestedText) {
        return nestedText.toUpperCase().equals("TRUE");
    }

    public static File makeOutputDirectory(Element config) throws ConfigurationException {
        Element outputElement;
        String outputDirName = "html";
        if (config != null && (outputElement = SodUtil.getElement(config, "outputDirectory")) != null && SodUtil.getText(outputElement) != null) {
            outputDirName = SodUtil.getText(outputElement);
        }
        File htmlDir = new File(outputDirName);
        if (outputDirName != null) {
            htmlDir = new File(outputDirName);
        }
        if (!htmlDir.exists()) {
            htmlDir.mkdirs();
        }
        if (!htmlDir.isDirectory()) {
            throw new ConfigurationException("The output directory specified in the config file already exists, and isn't a directory");
        }
        return htmlDir;
    }

    public static synchronized Object load(Element config, String armName) throws ConfigurationException {
        return SodUtil.load(config, new String[]{armName});
    }

    public static synchronized Object load(Element config, List<String> armNames) throws ConfigurationException {
        return SodUtil.load(config, armNames.toArray(new String[0]));
    }

    public static synchronized Object load(Element config, String[] armNames) throws ConfigurationException {
        try {
            Object tagName = config.getTagName();
            tagName = ((String)tagName).substring(0, 1).toUpperCase() + ((String)tagName).substring(1);
            if (((String)tagName).equals("SiteAND")) {
                tagName = "ChannelAND";
            } else if (((String)tagName).equals("SiteOR")) {
                tagName = "ChannelOR";
            } else if (((String)tagName).equals("SiteNOT")) {
                tagName = "ChannelNOT";
            }
            if (((String)tagName).equals("Unit")) {
                return SodUtil.loadUnit(config);
            }
            if (((String)tagName).equals("UnitRange")) {
                return SodUtil.loadUnitRange(config);
            }
            if (((String)tagName).equals("TimeRange")) {
                return SodUtil.loadTimeRange(config);
            }
            if (((String)tagName).equals("TimeInterval")) {
                return SodUtil.loadTimeInterval(config);
            }
            if (((String)tagName).equals("GlobalArea")) {
                return new GlobalAreaImpl();
            }
            if (((String)tagName).equals("BoxArea")) {
                return SodUtil.loadBoxArea(config);
            }
            if (((String)tagName).equals("PointDistance")) {
                return new OriginPointDistance(config).getArea();
            }
            if (((String)tagName).startsWith("External")) {
                return SodUtil.loadExternal((String)tagName, armNames, config);
            }
            return SodUtil.loadClass(SodUtil.load((String)tagName, armNames), config);
        }
        catch (InvocationTargetException e) {
            Throwable subException = e.getTargetException();
            if (subException instanceof ConfigurationException) {
                throw (ConfigurationException)subException;
            }
            if (subException instanceof Exception) {
                throw new ConfigurationException("Problem creating " + config.getTagName(), subException);
            }
            throw (Error)subException;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Problem understanding " + SodUtil.elementPath(config), e);
        }
    }

    public static String elementPath(Element e) {
        if (e.getParentNode() instanceof Document) {
            return "/";
        }
        return SodUtil.elementPath((Element)e.getParentNode()) + "/" + e.getTagName();
    }

    private static Class load(String tagName, String[] armNames) throws ClassNotFoundException {
        if (((String)tagName).equals("siteAND") || ((String)tagName).equals("siteOR") || ((String)tagName).equals("siteNOT") || ((String)tagName).equals("siteXOR")) {
            logger.warn((String)tagName + " has been removed and all site subsetters are now channel subsetters. Please up date your recipe to use channelAND, channelOR and channelNOT instead.");
            tagName = "channel" + ((String)tagName).substring("site".length());
        }
        if (((String)tagName).equals("beginOffset") || ((String)tagName).equals("endOffset")) {
            tagName = "interval";
        }
        for (int j = 0; j < armNames.length; ++j) {
            String armName = armNames[j];
            for (int i = 0; i < basePackageNames.length; ++i) {
                String packageName = baseName + "." + basePackageNames[i] + "." + armName;
                try {
                    return Class.forName(packageName + "." + (String)tagName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
        }
        for (int i = 0; i < basePackageNames.length; ++i) {
            String packageName = baseName + "." + basePackageNames[i];
            try {
                return Class.forName(packageName + "." + (String)tagName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return Class.forName(baseName + "." + (String)tagName);
    }

    public void listKnownScriptEngines() {
        ScriptEngineManager mgr = new ScriptEngineManager();
        List<ScriptEngineFactory> factories = mgr.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            System.out.println("ScriptEngineFactory Info");
            String engName = factory.getEngineName();
            String engVersion = factory.getEngineVersion();
            String langName = factory.getLanguageName();
            String langVersion = factory.getLanguageVersion();
            System.out.printf("\tScript Engine: %s (%s)\n", engName, engVersion);
            List<String> engNames = factory.getNames();
            for (String name : engNames) {
                System.out.printf("\tEngine Alias: %s\n", name);
            }
            System.out.printf("\tLanguage: %s (%s)\n", langName, langVersion);
        }
    }

    public static synchronized Object loadExternal(String tagName, String[] armNames, Element config) throws Exception {
        String classname = SodUtil.getNestedText(SodUtil.getElement(config, "classname"));
        try {
            Class<?> extClass = Class.forName(classname);
            Class mustImplement = SodUtil.load(tagName.substring("external".length()), armNames);
            if (mustImplement.isAssignableFrom(extClass)) {
                return SodUtil.loadClass(extClass, config);
            }
            throw new ConfigurationException("External class " + classname + " does not implement the class it's working with, " + String.valueOf(mustImplement) + ".  Make " + classname + " implement " + String.valueOf(mustImplement) + " to use it at this point in the strategy file.");
        }
        catch (ClassNotFoundException e1) {
            throw new ConfigurationException("Unable to find external class " + classname + ".  Make sure it's on the classpath", e1);
        }
    }

    private static Object loadClass(Class subsetter, Element config) throws Exception {
        Class[] argTypes = new Class[]{Element.class};
        Constructor constructor = null;
        try {
            constructor = subsetter.getConstructor(argTypes);
            Object[] args = new Object[]{config};
            return constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            argTypes = new Class[]{};
            constructor = subsetter.getConstructor(argTypes);
            return constructor.newInstance(new Object[0]);
        }
    }

    public static UnitImpl loadUnit(Element config) throws ConfigurationException {
        String unitName = null;
        NodeList children = config.getChildNodes();
        if (children.item(0) instanceof Text) {
            unitName = children.item(0).getNodeValue();
        }
        try {
            return UnitImpl.getUnitFromString(unitName);
        }
        catch (NoSuchFieldException e) {
            throw new ConfigurationException("Can't find unit " + unitName, e);
        }
    }

    public static MicroSecondDateSupplier loadTime(Element el) throws ConfigurationException {
        return SodUtil.loadTime(el, false);
    }

    public static MicroSecondDateSupplier loadTime(final Element el, boolean endOfDay) throws ConfigurationException {
        NodeList kids = el.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node node = kids.item(i);
            if (!(node instanceof Element)) continue;
            String tagName = ((Element)node).getTagName();
            Element element = (Element)node;
            if (tagName.equals("earlier") || tagName.equals("later")) {
                return SodUtil.loadRelativeTime(element);
            }
            if (tagName.equals("now")) {
                return SodUtil.nowSupplier();
            }
            if (tagName.equals("future")) {
                return new MicroSecondDateSupplier(){

                    @Override
                    public Instant load() {
                        return ClockUtil.wayFuture();
                    }
                };
            }
            return SodUtil.loadSplitupTime(el, endOfDay);
        }
        return new MicroSecondDateSupplier(){
            final Instant date;
            {
                this.date = TimeUtils.parseISOString((String)SodUtil.getNestedText(el).trim());
            }

            @Override
            public Instant load() {
                return this.date;
            }
        };
    }

    public static MicroSecondDateSupplier nowSupplier() {
        return new MicroSecondDateSupplier(){
            private Instant now = ClockUtil.now();

            @Override
            public Instant load() {
                return this.now;
            }
        };
    }

    private static MicroSecondDateSupplier loadSplitupTime(Element element, boolean ceiling) throws ConfigurationException {
        int year = DOMHelper.extractInt(element, "year", -1);
        if (year == -1) {
            throw new ConfigurationException("No year given");
        }
        int month = DOMHelper.extractInt(element, "month", ceiling ? 12 : 1);
        YearMonth ym = YearMonth.of(year, month);
        int dayOfMonth = DOMHelper.extractInt(element, "day", ceiling ? ym.lengthOfMonth() : 1);
        int hour = DOMHelper.extractInt(element, "hour", ceiling ? 23 : 0);
        int minute = DOMHelper.extractInt(element, "minute", ceiling ? 59 : 0);
        int second = DOMHelper.extractInt(element, "second", ceiling ? 59 : 0);
        int nanoOfSecond = ceiling ? 999000000 : 0;
        final ZonedDateTime zdt = ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, TimeUtils.TZ_UTC);
        return new MicroSecondDateSupplier(){
            final Instant date;
            {
                this.date = zdt.toInstant();
            }

            @Override
            public Instant load() {
                return this.date;
            }
        };
    }

    private static MicroSecondDateSupplier loadRelativeTime(Element el) throws ConfigurationException {
        if (DOMHelper.hasElement(el, "timeInterval")) {
            try {
                return SodUtil.loadRelativeTime(DOMHelper.getElement(el, "timeInterval"));
            }
            catch (XPathException e) {
                throw new ConfigurationException("problem with xpath 'timeInterval'", e);
            }
        }
        final Duration duration = SodUtil.loadTimeInterval(el);
        if (el.getTagName().equals("earlier")) {
            return SodUtil.getEarlierSupplier(duration);
        }
        return new MicroSecondDateSupplier(){

            @Override
            public Instant load() {
                return ClockUtil.now().plus(duration);
            }
        };
    }

    public static MicroSecondDateSupplier getEarlierSupplier(final Duration duration) {
        return new MicroSecondDateSupplier(){

            @Override
            public Instant load() {
                return ClockUtil.now().minus(duration);
            }
        };
    }

    public static MicroSecondDateSupplier getLaterSupplier(final Duration duration) {
        return new MicroSecondDateSupplier(){

            @Override
            public Instant load() {
                return ClockUtil.now().plus(duration);
            }
        };
    }

    public static Duration loadTimeInterval(Element config) throws ConfigurationException {
        try {
            UnitImpl unit = SodUtil.loadUnit(XMLUtil.getElement(config, "unit"));
            if (DOMHelper.hasElement(config, "randomValue")) {
                Element rvConf = DOMHelper.getElement(config, "randomValue");
                double min = Double.parseDouble(DOMHelper.extractText(rvConf, "min"));
                double max = Double.parseDouble(DOMHelper.extractText(rvConf, "max"));
                return ClockUtil.durationFrom(Math.random() * (max - min) + min, unit);
            }
            double value = Double.parseDouble(DOMHelper.extractText(config, "value"));
            return new QuantityImpl(value, unit).toDuration();
        }
        catch (Exception e) {
            throw new ConfigurationException("Can't load TimeInterval from " + config.getTagName(), e);
        }
    }

    public static QuantityImpl loadQuantity(Element config) throws ConfigurationException {
        try {
            double value = Double.parseDouble(XMLUtil.getText(XMLUtil.getElement(config, "value")));
            UnitImpl unit = SodUtil.loadUnit(XMLUtil.getElement(config, "unit"));
            return new QuantityImpl(value, unit);
        }
        catch (Exception e) {
            throw new ConfigurationException("Can't load quantity from " + config.getTagName(), e);
        }
    }

    public static int loadInt(Element config, String elementName, int defaultValue) {
        Element child = XMLUtil.getElement(config, elementName);
        if (child != null) {
            return Integer.parseInt(XMLUtil.getText(child));
        }
        return defaultValue;
    }

    public static float loadFloat(Element config, String elementName, float defaultValue) {
        Element child = XMLUtil.getElement(config, elementName);
        if (child != null) {
            return Float.parseFloat(XMLUtil.getText(child));
        }
        return defaultValue;
    }

    public static String loadText(Element config, String elementName, String defaultValue) {
        Element child = SodUtil.getElement(config, elementName);
        String out = null;
        if (child != null) {
            out = SodUtil.getText(child);
        }
        if (out == null) {
            out = defaultValue;
        }
        return out;
    }

    public static void copyFile(String src, String dest) throws FileNotFoundException {
        if (src.startsWith("jar")) {
            try {
                URL url = SodUtil.getUrl(SodUtil.class.getClassLoader(), src);
                SodUtil.copyStream(url.openStream(), dest);
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle("trouble creating url for copying", e);
            }
        } else {
            File f = new File(src);
            SodUtil.copyStream(new FileInputStream(f), dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream src, String dest) {
        File f = new File(dest);
        f.getParentFile().mkdirs();
        OutputStream os = null;
        try {
            int curChar;
            os = new BufferedOutputStream(new FileOutputStream(f));
            while ((curChar = src.read()) != -1) {
                os.write(curChar);
            }
        }
        catch (IOException e) {
            GlobalExceptionHandler.handle("Troble copying a file", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {
                    GlobalExceptionHandler.handle("Unable to close output stream for file " + String.valueOf(f), e1);
                }
            }
        }
    }

    public static UnitRangeImpl loadUnitRange(Element config) throws ConfigurationException {
        UnitImpl unit = null;
        double min = -1.7976931348623157E308;
        double max = Double.MAX_VALUE;
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element subElement = (Element)children.item(i);
            String tagName = subElement.getTagName();
            if (tagName.equals("unit")) {
                unit = SodUtil.loadUnit(subElement);
                continue;
            }
            if (tagName.equals("min")) {
                min = Double.parseDouble(SodUtil.getText(subElement));
                continue;
            }
            if (!tagName.equals("max")) continue;
            max = Double.parseDouble(SodUtil.getText(subElement));
        }
        UnitRangeImpl unitRange = new UnitRangeImpl(min, max, unit);
        return unitRange;
    }

    public static MicroSecondTimeRangeSupplier loadTimeRange(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        MicroSecondDateSupplier begin = null;
        MicroSecondDateSupplier end = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element subElement = (Element)children.item(i);
            String tagName = subElement.getTagName();
            if (tagName.equals("startTime")) {
                begin = SodUtil.loadTime(subElement);
                continue;
            }
            if (!tagName.equals("endTime")) continue;
            end = SodUtil.loadTime(subElement, true);
        }
        return new BeginEndTimeRangeSupplier(begin, end);
    }

    public static Dimension loadDimensions(Element element) throws Exception {
        String width = SodUtil.nodeValueOfXPath(element, "width/text()");
        String height = SodUtil.nodeValueOfXPath(element, "height/text()");
        return new Dimension(Integer.parseInt(width), Integer.parseInt(height));
    }

    public static String nodeValueOfXPath(Element el, String xpath) throws DOMException, TransformerException, XPathException {
        return DOMHelper.extractNodes(el, xpath).item(0).getNodeValue();
    }

    public static BoxAreaImpl loadBoxArea(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        float minLatitude = 0.0f;
        float maxLatitude = 0.0f;
        float minLongitude = 0.0f;
        float maxLongitude = 0.0f;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Object obj = SodUtil.load((Element)children.item(i), "");
            if (obj instanceof LatitudeRange) {
                minLatitude = (float)((LatitudeRange)obj).getMinValue();
                maxLatitude = (float)((LatitudeRange)obj).getMaxValue();
                continue;
            }
            if (!(obj instanceof LongitudeRange)) continue;
            minLongitude = (float)((LongitudeRange)obj).getMinValue();
            maxLongitude = (float)((LongitudeRange)obj).getMaxValue();
        }
        return new BoxAreaImpl(minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static Element getElement(Element config, String elementName) {
        NodeList children = config.getChildNodes();
        for (int counter = 0; counter < children.getLength(); ++counter) {
            Element el;
            if (!(children.item(counter) instanceof Element) || !(el = (Element)children.item(counter)).getTagName().equals(elementName)) continue;
            return el;
        }
        return null;
    }

    public static List<Element> getAllElements(Element config, String elementName) {
        ArrayList<Element> out = new ArrayList<Element>();
        NodeList children = config.getChildNodes();
        for (int counter = 0; counter < children.getLength(); ++counter) {
            Element el;
            if (!(children.item(counter) instanceof Element) || !(el = (Element)children.item(counter)).getTagName().equals(elementName)) continue;
            out.add(el);
        }
        return out;
    }

    public static Element getFirstEmbeddedElement(Element config) {
        NodeList nl = config.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static String getText(Element config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Text)) continue;
            return children.item(i).getNodeValue();
        }
        return null;
    }

    public static String getNestedText(Element config) {
        String rtnValue = null;
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node instanceof Text) {
                rtnValue = node.getNodeValue();
                continue;
            }
            if (!(node instanceof Element)) continue;
            rtnValue = SodUtil.getNestedText((Element)node);
            break;
        }
        return rtnValue;
    }

    public static String getRelativePath(String fromPath, String toPath, String separator) {
        StringTokenizer fromTok = new StringTokenizer(fromPath, separator);
        StringTokenizer toTok = new StringTokenizer(toPath, separator);
        StringBuffer dotBuf = new StringBuffer();
        StringBuffer pathBuf = new StringBuffer();
        while (fromTok.countTokens() > 1 || toTok.countTokens() > 1) {
            if (fromTok.countTokens() > 1 && toTok.countTokens() > 1) {
                String toTmp;
                String fromTmp = fromTok.nextToken();
                if (fromTmp.equals(toTmp = toTok.nextToken())) continue;
                dotBuf.append(".." + separator);
                pathBuf.append(toTmp + separator);
                continue;
            }
            if (fromTok.countTokens() > 1) {
                fromTok.nextToken();
                dotBuf.append(".." + separator);
                continue;
            }
            if (toTok.countTokens() <= 1) continue;
            pathBuf.append(toTok.nextToken() + separator);
        }
        if (toTok.countTokens() > 0) {
            pathBuf.append(toTok.nextToken());
        }
        return dotBuf.toString() + pathBuf.toString();
    }

    public static String getAbsolutePath(String baseLoc, String relativeLoc) throws IOException {
        if (baseLoc.startsWith("jar:")) {
            String noFileBase = SodUtil.removeFileName(baseLoc);
            int numDirUp = SodUtil.countDots(relativeLoc);
            String relBase = SodUtil.stripDirs(noFileBase, numDirUp);
            return relBase + SodUtil.stripRelativeBits(relativeLoc);
        }
        String base = new File(baseLoc).getCanonicalFile().getParent();
        int numDirUp = SodUtil.countDots(relativeLoc);
        for (int i = 0; i < numDirUp; ++i) {
            base = new File(base).getParent();
        }
        return base + "/" + SodUtil.stripRelativeBits(relativeLoc);
    }

    public static URL getUrl(ClassLoader cl, String loc) throws MalformedURLException {
        if (loc.startsWith("jar:")) {
            return cl.getResource(loc.substring(4));
        }
        try {
            return new URL(loc);
        }
        catch (MalformedURLException e) {
            return new File(loc).toURL();
        }
    }

    private static String stripDirs(String base, int numDirUp) {
        for (int i = 0; i < numDirUp; ++i) {
            base = base.substring(0, base.lastIndexOf("/"));
        }
        return base + "/";
    }

    private static String removeFileName(String base) {
        return base.substring(0, base.lastIndexOf("/"));
    }

    private static String stripRelativeBits(String relativeLoc) {
        while (relativeLoc.indexOf("../") == 0) {
            relativeLoc = relativeLoc.substring(3);
        }
        if (relativeLoc.indexOf("./") == 0) {
            relativeLoc = relativeLoc.substring(2);
        }
        if (relativeLoc.indexOf("/") == 0) {
            relativeLoc = relativeLoc.substring(1);
        }
        return relativeLoc;
    }

    private static int countDots(String relativeLocation) {
        int lastDots = relativeLocation.lastIndexOf("..");
        if (lastDots == -1) {
            return 0;
        }
        return 1 + lastDots / 3;
    }

    public static void loadProperties(Element config, Properties props) {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals("property")) continue;
            Element elem = (Element)node;
            String propName = SodUtil.getNestedText(SodUtil.getElement(elem, "name"));
            String propValue = SodUtil.getNestedText(SodUtil.getElement(elem, "value"));
            props.setProperty(propName, propValue);
        }
    }

    public static int[] intArrayFromList(List list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    public static String getSimpleName(Class c) {
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }
}

