/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class RunProperties {
    public static final Duration NO_TIME = Duration.ofNanos(0L);
    public static final Duration ONE_WEEK = Duration.ofDays(7L);
    public static final Duration TEN_MIN = Duration.ofMinutes(10L);
    public static final Duration DAYS_180 = Duration.ofDays(180L);
    private Duration eventQueryIncrement = ONE_WEEK;
    private Duration eventLag = ONE_WEEK;
    private Duration eventRefresh = TEN_MIN;
    private Duration maxRetry = DAYS_180;
    private Duration serverRetryDelay = NO_TIME;
    private Duration seismogramLatency = ONE_WEEK.multipliedBy(4L);
    private String runName = "Your Sod";
    private String statusDir = "status";
    public static final int DEFAULT_NUM_WORKER_THREADS = 1;
    private int numWorkers = 1;
    private boolean reopenEvents = false;
    private boolean removeDatabase = false;
    private boolean warnIfDatabaseExists = true;
    private boolean statusPages = false;
    public static final String DONT_RESTART = "noCheck";
    public static final String AT_LEAST_ONCE = "atLeastOnce";
    public static final String AT_MOST_ONCE = "atMostOnce";
    private String evChanPairProc = "atLeastOnce";
    private boolean checkpointPeriodically = false;
    private boolean loserEventCleaner = false;
    private boolean allowDeadNets;
    private String channelGroupingRules = null;
    private boolean skipAvailableData = true;
    private boolean statusWebKeepAlive = false;
    private boolean statusUnsecure = false;
    private List hibernateConfig = new ArrayList();
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyScheme = null;

    public void addProperties(Element el) throws ConfigurationException {
        if (el != null) {
            Element proxySchemeEl;
            Element proxyPortEl;
            Element proxyHostEl;
            Element hibernateExtraConfig;
            Element chanGroupRuleChild;
            Element evChanPairProcChild;
            Element numWorkersChild;
            Element serverRetryChild;
            Element seismogramLatencyEl;
            Element maxRetryChild;
            Element eventRefreshChild;
            Element eventLagChild;
            Element eventQueryChild;
            Element statusBaseChild;
            Element runNameChild = SodUtil.getElement(el, "runName");
            if (runNameChild != null) {
                this.runName = SodUtil.getText(runNameChild);
            }
            if ((statusBaseChild = SodUtil.getElement(el, "statusBase")) != null) {
                this.statusDir = SodUtil.getText(statusBaseChild);
            }
            if ((eventQueryChild = SodUtil.getElement(el, "eventQueryIncrement")) != null) {
                this.eventQueryIncrement = SodUtil.loadTimeInterval(eventQueryChild);
            }
            if ((eventLagChild = SodUtil.getElement(el, "eventLag")) != null) {
                this.eventLag = SodUtil.loadTimeInterval(eventLagChild);
            }
            if ((eventRefreshChild = SodUtil.getElement(el, "eventRefreshInterval")) != null) {
                this.eventRefresh = SodUtil.loadTimeInterval(eventRefreshChild);
            }
            if ((maxRetryChild = SodUtil.getElement(el, "maxRetryDelay")) != null) {
                this.maxRetry = SodUtil.loadTimeInterval(maxRetryChild);
            }
            if ((seismogramLatencyEl = SodUtil.getElement(el, "seismogramLatency")) != null) {
                this.seismogramLatency = SodUtil.loadTimeInterval(seismogramLatencyEl);
            }
            if ((serverRetryChild = SodUtil.getElement(el, "serverRetryDelay")) != null) {
                this.serverRetryDelay = SodUtil.loadTimeInterval(serverRetryChild);
            }
            if ((numWorkersChild = SodUtil.getElement(el, "waveformWorkerThreads")) != null) {
                this.numWorkers = Integer.parseInt(SodUtil.getText(numWorkersChild));
            }
            if ((evChanPairProcChild = SodUtil.getElement(el, "eventChannelPairProcessing")) != null) {
                this.evChanPairProc = SodUtil.getText(evChanPairProcChild);
            }
            if ((chanGroupRuleChild = SodUtil.getElement(el, "channelGroupingRules")) != null) {
                this.channelGroupingRules = SodUtil.getText(chanGroupRuleChild);
            }
            if (SodUtil.isTrue(el, "reopenEvents", false)) {
                this.reopenEvents = true;
            }
            if (SodUtil.isTrue(el, "removeDatabase", false)) {
                this.removeDatabase = true;
            }
            if (!SodUtil.isTrue(el, "warnIfDatabaseExists", true)) {
                this.warnIfDatabaseExists = false;
            }
            if (SodUtil.isTrue(el, "statusPages", false)) {
                this.statusPages = true;
            }
            if (DOMHelper.hasElement(el, "checkpointPeriodically")) {
                this.checkpointPeriodically = true;
            }
            if (DOMHelper.hasElement(el, "loserEventCleaner")) {
                this.loserEventCleaner = true;
            }
            if (DOMHelper.hasElement(el, "allowNetworksOutsideEventRequestTime")) {
                this.allowDeadNets = true;
            }
            if (DOMHelper.hasElement(el, "skipAvailableData")) {
                this.skipAvailableData = DOMHelper.extractBoolean(el, "skipAvailableData");
            }
            if ((hibernateExtraConfig = SodUtil.getElement(el, "hibernateConfig")) != null) {
                this.hibernateConfig.add(SodUtil.getText(hibernateExtraConfig));
            }
            if ((proxyHostEl = SodUtil.getElement(el, "proxyHost")) != null) {
                this.proxyHost = SodUtil.getText(proxyHostEl);
            }
            if ((proxyPortEl = SodUtil.getElement(el, "proxyPort")) != null) {
                this.proxyPort = SodUtil.loadInt(el, "proxyPort", -1);
            }
            if ((proxySchemeEl = SodUtil.getElement(el, "proxyScheme")) != null) {
                this.proxyScheme = SodUtil.getText(proxySchemeEl);
            }
        }
    }

    public Duration getMaxRetryDelay() {
        return this.maxRetry;
    }

    public Duration getServerRetryDelay() {
        return this.serverRetryDelay;
    }

    public Duration getEventQueryIncrement() {
        return this.eventQueryIncrement;
    }

    public Duration getEventLag() {
        return this.eventLag;
    }

    public Duration getEventRefreshInterval() {
        return this.eventRefresh;
    }

    public Duration getSeismogramLatency() {
        return this.seismogramLatency;
    }

    public String getRunName() {
        return this.runName;
    }

    public String getStatusBaseDir() {
        return this.statusDir;
    }

    public int getNumWaveformWorkerThreads() {
        return this.numWorkers;
    }

    public void setNumWaveformWorkerThreads(int numWorkers) {
        this.numWorkers = numWorkers;
    }

    public boolean reopenEvents() {
        return this.reopenEvents;
    }

    public boolean removeDatabase() {
        return this.removeDatabase;
    }

    public boolean warnIfDatabaseExists() {
        return this.warnIfDatabaseExists;
    }

    public String getEventChannelPairProcessing() {
        return this.evChanPairProc;
    }

    public boolean reopenSuspended() {
        return !this.evChanPairProc.equals(DONT_RESTART);
    }

    public boolean doStatusPages() {
        return this.statusPages;
    }

    public boolean checkpointPeriodically() {
        return this.checkpointPeriodically;
    }

    public boolean loserEventCleaner() {
        return this.loserEventCleaner;
    }

    public void setAllowDeadNets(boolean b) {
        this.allowDeadNets = b;
    }

    public boolean allowDeadNets() {
        return this.allowDeadNets;
    }

    public boolean isSkipAvailableData() {
        return this.skipAvailableData;
    }

    public void setSkipAvailableData(boolean skipAvailableData) {
        this.skipAvailableData = skipAvailableData;
    }

    public List getHibernateConfig() {
        return this.hibernateConfig;
    }

    public String getChannelGroupingRules() {
        return this.channelGroupingRules;
    }

    public boolean isStatusWebKeepAlive() {
        return this.statusWebKeepAlive;
    }

    public void setStatusWebKeepAlive(boolean b) {
        this.statusWebKeepAlive = b;
    }

    public boolean isStatusUnsecure() {
        return this.statusUnsecure;
    }

    public void setStatusUnsecure(boolean b) {
        this.statusUnsecure = b;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getProxyPort() {
        if (this.proxyPort <= 0) {
            return 80;
        }
        return this.proxyPort;
    }

    public void setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
    }

    public String getProxyScheme() {
        if (this.proxyScheme == null) {
            return "http";
        }
        return this.proxyScheme;
    }
}

