/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.source.network.LoadedNetworkSource;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshNetworkArm
extends TimerTask {
    private List<Integer> networksBeingReloaded = new ArrayList<Integer>();
    private List<Integer> stationsBeingReloaded = new ArrayList<Integer>();
    NetworkArm netArm;
    private static final Logger logger = LoggerFactory.getLogger(RefreshNetworkArm.class);

    public RefreshNetworkArm(NetworkArm netArm) {
        this.netArm = netArm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Refreshing Network Arm");
        try {
            LinkedList<Network> needReload = new LinkedList<Network>();
            RefreshNetworkArm refreshNetworkArm = this;
            synchronized (refreshNetworkArm) {
                List<Network> nets = this.netArm.getSuccessfulNetworksFromServer();
                if (nets.size() == 0) {
                    return;
                }
                for (Network net : nets) {
                    if (!this.isNetworkBeingReloaded(net.getDbid())) {
                        this.networksBeingReloaded.add(new Integer(net.getDbid()));
                        needReload.add(net);
                        logger.debug("Will Reload " + net.toString());
                        continue;
                    }
                    logger.info("net already in processing list, skipping..." + net.toString());
                }
            }
            for (Network cacheNetwork : needReload) {
                NetworkDB.getSingleton().put(cacheNetwork);
            }
            NetworkDB.commit();
            while (needReload.size() != 0) {
                Iterator it = needReload.iterator();
                while (it.hasNext()) {
                    Network net = (Network)it.next();
                    if (this.processNetwork(net)) {
                        RefreshNetworkArm refreshNetworkArm2 = this;
                        synchronized (refreshNetworkArm2) {
                            this.networksBeingReloaded.remove(new Integer(net.getDbid()));
                            it.remove();
                            logger.debug("Successful reload of " + net.toString());
                            this.notifyAll();
                            if (Start.getWaveformRecipe() != null) {
                                this.wait(10L);
                            }
                            continue;
                        }
                    }
                    logger.debug("reload not successful, will do again " + net.toString());
                }
                Thread.sleep(1000L);
            }
            this.netArm.finish();
        }
        catch (Throwable t) {
            Start.armFailure(this.netArm, t);
            GlobalExceptionHandler.handle(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNetwork(Network net) {
        logger.debug("refresh " + net.toString());
        try {
            Station[] stas = this.netArm.getSuccessfulStationsFromServer(net);
            ArrayList<Station> allStations = new ArrayList<Station>();
            for (int s = 0; s < stas.length; ++s) {
                allStations.add(stas[s]);
            }
            RefreshNetworkArm s = this;
            synchronized (s) {
                for (int s2 = 0; s2 < stas.length; ++s2) {
                    this.stationsBeingReloaded.add(stas[s2].getDbid());
                }
            }
            logger.info("found " + stas.length + " stations in " + net.toString());
            if (Start.getWaveformRecipe() != null || this.netArm.getChannelSubsetters().size() != 0) {
                for (int s3 = 0; s3 < stas.length; ++s3) {
                    LoadedNetworkSource loadSource = new LoadedNetworkSource(this.netArm.getInternalNetworkSource(), allStations, stas[s3]);
                    this.processStation(loadSource, stas[s3]);
                    RefreshNetworkArm refreshNetworkArm = this;
                    synchronized (refreshNetworkArm) {
                        this.stationsBeingReloaded.remove(new Integer(stas[s3].getDbid()));
                        continue;
                    }
                }
            } else {
                logger.info("Not loading channels as no waveformArm or channel subsetters");
            }
            NetworkDB.commit();
            return true;
        }
        catch (Throwable t) {
            NetworkDB.rollback();
            String netstr = "unknown";
            try {
                netstr = net.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GlobalExceptionHandler.handle("Problem with network: " + netstr, t);
            return false;
        }
    }

    void processStation(LoadedNetworkSource loadSource, Station sta) {
        if (Start.getWaveformRecipe() instanceof MotionVectorArm) {
            List<ChannelGroup> list = this.netArm.getSuccessfulChannelGroupsFromServer(sta, loadSource);
        } else {
            List<Channel> list = this.netArm.getSuccessfulChannelsFromServer(sta, loadSource);
        }
    }

    public synchronized boolean isNetworkBeingReloaded(int dbid) {
        if (dbid == 0) {
            throw new IllegalArgumentException("dbid = 0 is not legal, Network must not be in db yet");
        }
        return this.networksBeingReloaded.contains(new Integer(dbid));
    }

    public synchronized boolean isStationBeingReloaded(int dbid) {
        if (dbid == 0) {
            throw new IllegalArgumentException("dbid = 0 is not legal, Station must not be in db yet");
        }
        return this.stationsBeingReloaded.contains(new Integer(dbid));
    }
}

