/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.time.Instant;

public class QueryTime {
    protected int dbid;
    protected String serverName;
    protected Instant time;

    public QueryTime() {
    }

    public QueryTime(String serverName, Instant time) {
        this.serverName = serverName;
        this.time = time;
    }

    public boolean needsRefresh(Duration refreshInterval) {
        Instant currentTime;
        Instant lastTime = this.getTime();
        Duration timeInterval = Duration.between(lastTime, currentTime = ClockUtil.now()).abs();
        return timeInterval.compareTo(refreshInterval) > 0;
    }

    public int getDbid() {
        return this.dbid;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Instant getTime() {
        return this.time;
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o instanceof QueryTime) {
            QueryTime q = (QueryTime)o;
            return this.getDbid() == q.getDbid() && this.getServerName().equals(q.getServerName()) && this.getTime().equals(q.getTime());
        }
        return false;
    }

    public int hashCode() {
        return 89 + 17 * this.getDbid() + this.getServerName().hashCode() + 19 * this.getTime().hashCode();
    }

    public long delayMillisUntilNextRefresh(Duration refreshInterval) {
        Instant now = ClockUtil.now();
        Instant nextRefresh = this.getTime().plus(refreshInterval);
        if (nextRefresh.isBefore(now)) {
            return 0L;
        }
        return Duration.between(now, nextRefresh).toMillis();
    }
}

