/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ChannelGrouper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.QueryTime;
import edu.sc.seis.sod.RefreshNetworkArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.source.network.FdsnStation;
import edu.sc.seis.sod.source.network.InstrumentationFromDB;
import edu.sc.seis.sod.source.network.LoadedNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.RetryNetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.networkArm.NetworkMonitor;
import edu.sc.seis.sod.subsetter.channel.ChannelEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.PassChannel;
import edu.sc.seis.sod.subsetter.network.NetworkEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.network.NetworkSubsetter;
import edu.sc.seis.sod.subsetter.network.PassNetwork;
import edu.sc.seis.sod.subsetter.station.PassStation;
import edu.sc.seis.sod.subsetter.station.StationEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetworkArm
implements Arm {
    public static final String[] PACKAGES = new String[]{"networkArm", "channel", "site", "station", "network"};
    private NetworkSource internalFinder;
    private NetworkSource finder;
    private NetworkSubsetter attrSubsetter = new PassNetwork();
    private NetworkSubsetter netEffectiveSubsetter = new PassNetwork();
    private StationSubsetter stationSubsetter = new PassStation();
    private StationSubsetter staEffectiveSubsetter = new PassStation();
    private List<ChannelSubsetter> chanSubsetters = new ArrayList<ChannelSubsetter>();
    private ChannelSubsetter chanEffectiveSubsetter = new PassChannel();
    private ChannelGrouper channelGrouper;
    private HashSet<String> allStationFailureNets = new HashSet();
    private HashSet<String> allChannelFailureStations = new HashSet();
    private HashSet<String> allChannelGroupFailureStations = new HashSet();
    private List<NetworkMonitor> statusMonitors = new ArrayList<NetworkMonitor>();
    private List<ArmListener> armListeners = new ArrayList<ArmListener>();
    private static Logger logger = LoggerFactory.getLogger(NetworkArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.NetworkArm");
    private boolean armFinished = false;
    private boolean initialStartupFinished = false;
    RefreshNetworkArm refresh;
    private QueryTime lastQueryTime = null;
    final Object netGetSync = new Object();
    final Object staGetSync = new Object();
    final Object chanGetSync = new Object();
    public static final String NO_NETWORKS_MSG = "Found no networks.  Make sure the network codes you entered are valid. This can also be caused by asking for a restricted networks without <includeRestricted>true</includeRestricted> in a <fdsnStation> network source.";

    public NetworkArm(Element config) throws ConfigurationException {
        this.channelGrouper = new ChannelGrouper(Start.getRunProps().getChannelGroupingRules());
        this.processConfig(config);
        this.refresh = new RefreshNetworkArm(this);
    }

    @Override
    public void run() {
        try {
            SodDB sodDb = SodDB.getSingleton();
            this.lastQueryTime = sodDb.getQueryTime(this.getInternalNetworkSource().getName());
            if (this.getRefreshInterval().toNanos() > 0L && Start.getWaveformRecipe() != null) {
                Timer timer = new Timer("Refresh NetworkArm", true);
                long period = this.getInternalNetworkSource().getRefreshInterval().toMillis();
                long firstDelay = this.lastQueryTime == null ? 0L : this.lastQueryTime.delayMillisUntilNextRefresh(this.getRefreshInterval());
                logger.debug("Refresh timer startup: period: " + period + "  firstDelay: " + firstDelay + "  last query: " + String.valueOf(this.lastQueryTime == null ? "null" : this.lastQueryTime.getTime()));
                timer.schedule((TimerTask)this.refresh, firstDelay, period);
                if (period == 0L) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.initialStartupFinished = true;
            } else {
                this.initialStartupFinished = true;
                this.refresh.run();
            }
            SodDB.rollback();
        }
        catch (Throwable e) {
            this.armFinished = true;
            Start.armFailure(this, e);
        }
    }

    @Override
    public boolean isActive() {
        return !this.armFinished;
    }

    @Override
    public String getName() {
        return "NetworkArm";
    }

    private void processConfig(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            this.loadConfigElement(SodUtil.load((Element)node, PACKAGES));
        }
        TimeRange timeRange = this.configureEffectiveTimeCheckers();
        NetworkQueryConstraints constraints = new NetworkQueryConstraints(this.attrSubsetter, this.stationSubsetter, this.chanSubsetters, timeRange);
        this.getNetworkSource().setConstraints(constraints);
    }

    private TimeRange configureEffectiveTimeCheckers() {
        EventArm arm = Start.getEventArm();
        if (arm != null && !Start.getRunProps().allowDeadNets()) {
            EventSource[] sources = arm.getSources();
            TimeRange fullTime = sources[0].getEventTimeRange();
            for (int i = 1; i < sources.length; ++i) {
                fullTime = new TimeRange(fullTime, sources[i].getEventTimeRange());
            }
            TimeRange eventQueryTimes = fullTime;
            this.netEffectiveSubsetter = new NetworkEffectiveTimeOverlap(eventQueryTimes);
            this.staEffectiveSubsetter = new StationEffectiveTimeOverlap(eventQueryTimes);
            this.chanEffectiveSubsetter = new ChannelEffectiveTimeOverlap(eventQueryTimes);
            return eventQueryTimes;
        }
        logger.debug("No implicit effective time constraint");
        return null;
    }

    private void loadConfigElement(Object sodElement) throws ConfigurationException {
        if (sodElement instanceof NetworkSource) {
            this.internalFinder = new RetryNetworkSource((NetworkSource)sodElement);
            this.finder = new InstrumentationFromDB(this.internalFinder);
        } else if (sodElement instanceof NetworkSubsetter) {
            this.attrSubsetter = (NetworkSubsetter)sodElement;
        } else if (sodElement instanceof StationSubsetter) {
            this.stationSubsetter = (StationSubsetter)sodElement;
        } else if (sodElement instanceof ChannelSubsetter) {
            this.chanSubsetters.add((ChannelSubsetter)sodElement);
        } else {
            throw new ConfigurationException("Unknown configuration object: " + String.valueOf(sodElement.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NetworkMonitor monitor) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            this.statusMonitors.add(monitor);
        }
    }

    public Duration getRefreshInterval() {
        return this.getInternalNetworkSource().getRefreshInterval();
    }

    public List<ChannelSubsetter> getChannelSubsetters() {
        return this.chanSubsetters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Network> getSuccessfulNetworks() {
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            List<Network> cacheNets = this.loadNetworksFromDB();
            while (cacheNets == null && this.lastQueryTime == null && !Start.isArmFailure()) {
                logger.info("Waiting on initial network load");
                this.refresh.notifyAll();
                try {
                    this.refresh.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cacheNets = this.loadNetworksFromDB();
            }
            return cacheNets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Network> loadNetworksFromDB() {
        Object object = this.netGetSync;
        synchronized (object) {
            List<Network> fromDB = this.getNetworkDB().getAllNetworks();
            for (Network net : fromDB) {
                this.change(net, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
            }
            return fromDB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Network> getSuccessfulNetworksFromServer() throws SodSourceException {
        Object object = this.netGetSync;
        synchronized (object) {
            this.statusChanged("Getting networks");
            logger.info("Getting networks from server");
            ArrayList<Network> successes = new ArrayList<Network>();
            List<? extends Network> allNets = this.getInternalNetworkSource().getNetworks();
            logger.info("Found " + allNets.size() + " networks");
            int i = 0;
            for (Network network : allNets) {
                block15: {
                    try {
                        if (this.netEffectiveSubsetter.accept(network).isSuccess()) {
                            StringTree result;
                            try {
                                result = this.attrSubsetter.accept(network);
                            }
                            catch (Throwable t) {
                                logger.debug("Network subsetter exception: ", t);
                                result = new Fail((Object)this.attrSubsetter, "Exception", t);
                            }
                            if (result.isSuccess()) {
                                NetworkDB ndb = this.getNetworkDB();
                                int dbid = ndb.put(network);
                                NetworkDB.commit();
                                logger.info("store network: " + network.toString() + " " + network.getDbid() + " " + dbid);
                                successes.add(network);
                                this.change(network, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
                            } else {
                                this.change(network, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                                failLogger.info(network.toString() + " was rejected. " + String.valueOf(result));
                            }
                            break block15;
                        }
                        this.change(network, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                        failLogger.info(network.toString() + " was rejected because it wasn't active during the time range of requested events");
                    }
                    catch (Throwable th) {
                        GlobalExceptionHandler.handle("Got an exception while trying getSuccessfulNetworks for the " + i + "th networkAccess (" + (network == null ? "null" : network.toString()), th);
                    }
                }
                ++i;
            }
            if (this.lastQueryTime == null && allNets.size() == 0) {
                logger.warn(NO_NETWORKS_MSG);
                Start.simpleArmFailure(this, NO_NETWORKS_MSG);
            }
            logger.info(successes.size() + " networks passed");
            this.statusChanged("Waiting for a request");
            RefreshNetworkArm refreshNetworkArm = this.refresh;
            synchronized (refreshNetworkArm) {
                this.refresh.notifyAll();
            }
            return successes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        this.armFinished = true;
        this.lastQueryTime = new QueryTime(this.getInternalNetworkSource().getName(), ClockUtil.now());
        SodDB.getSingleton().putQueryTime(this.lastQueryTime);
        SodDB.commit();
        logger.info("Network arm finished.");
        for (ArmListener listener : this.armListeners) {
            listener.finished(this);
        }
        if (Start.getEventArm() != null && Start.getEventArm().getWaveformArmSync() != null) {
            Object object = Start.getEventArm().getWaveformArmSync();
            synchronized (object) {
                Start.getEventArm().getWaveformArmSync().notifyAll();
            }
        }
    }

    public void add(ArmListener listener) {
        this.armListeners.add(listener);
        if (this.armFinished) {
            listener.finished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Station[] getSuccessfulStations(Network net) {
        String netCode = net.getCode();
        logger.debug("getSuccessfulStations: " + net.getCode());
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            while (this.refresh.isNetworkBeingReloaded(net.getDbid())) {
                try {
                    this.refresh.notifyAll();
                    this.refresh.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.allStationFailureNets.contains(net.toString())) {
                return new Station[0];
            }
            List<Station> sta = this.getNetworkDB().getStationForNet(net);
            if (sta.size() != 0) {
                logger.debug("getSuccessfulStations " + netCode + " - from db " + sta.size());
                return sta.toArray(new Station[0]);
            }
            this.allStationFailureNets.add(net.toString());
            return new Station[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Station[] getSuccessfulStationsFromServer(Network net) {
        NetworkArm networkArm = this;
        synchronized (networkArm) {
            Network netAttr;
            try {
                netAttr = NetworkDB.getSingleton().getNetwork(net.getDbid());
            }
            catch (NotFound e1) {
                throw new RuntimeException("Network not in db yet: " + net.toString());
            }
            this.statusChanged("Getting stations for " + net.getNetworkId());
            ArrayList<Station> arrayList = new ArrayList<Station>();
            try {
                List<? extends Station> stations = this.getInternalNetworkSource().getStations(netAttr);
                for (Station station : stations) {
                    logger.debug("Station in NetworkArm: " + StationIdUtil.toString(station));
                }
                for (Station station : stations) {
                    station.setNetwork(netAttr);
                    StringTree effResult = this.staEffectiveSubsetter.accept(station, this.getNetworkSource());
                    if (effResult.isSuccess()) {
                        StringTree staResult;
                        try {
                            staResult = this.stationSubsetter.accept(station, this.getNetworkSource());
                        }
                        catch (Throwable t) {
                            logger.debug("Station subsetter exception: ", t);
                            staResult = new Fail((Object)this.stationSubsetter, "Exception", t);
                        }
                        if (staResult.isSuccess()) {
                            int dbid = this.getNetworkDB().put(station);
                            logger.info("Store " + station.getCode() + " as " + dbid + " in " + String.valueOf(this.getNetworkDB()));
                            arrayList.add(station);
                            this.change(station, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
                            continue;
                        }
                        this.change(station, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                        failLogger.info(StationIdUtil.toString(station) + " was rejected: " + String.valueOf(staResult));
                        continue;
                    }
                    this.change(station, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                    failLogger.info(StationIdUtil.toString(station) + " was rejected because the station was not active during the time range of requested events: " + String.valueOf(effResult));
                }
                NetworkDB.commit();
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle("Problem in method getSuccessfulStations for net " + net.toString(), e);
                NetworkDB.rollback();
            }
            Station[] rtnValues = new Station[arrayList.size()];
            rtnValues = arrayList.toArray(rtnValues);
            this.statusChanged("Waiting for a request");
            logger.debug("getSuccessfulStations " + net.toString() + " - from server " + rtnValues.length);
            if (rtnValues.length == 0) {
                this.allStationFailureNets.add(net.toString());
            } else {
                this.allStationFailureNets.remove(net.toString());
            }
            return rtnValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Channel> getSuccessfulChannels(Station station) {
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            while (this.refresh.isNetworkBeingReloaded(station.getNetwork().getDbid()) || this.refresh.isStationBeingReloaded(station.getDbid())) {
                try {
                    this.refresh.notifyAll();
                    this.refresh.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.allChannelFailureStations.contains(StationIdUtil.toStringNoDates(station))) {
                return new ArrayList<Channel>(0);
            }
            List<Channel> sta = this.getNetworkDB().getChannelsForStation(station);
            if (sta.size() != 0) {
                logger.debug("successfulChannels " + station.getCode() + " - from db " + sta.size());
                return sta;
            }
            this.allChannelFailureStations.add(StationIdUtil.toStringNoDates(station));
            return new ArrayList<Channel>(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Channel> getSuccessfulChannelsFromServer(Station station, LoadedNetworkSource loadedNetworkSource) {
        NetworkArm networkArm = this;
        synchronized (networkArm) {
            this.statusChanged("Getting channels for " + String.valueOf(station));
            ArrayList<Channel> successes = new ArrayList<Channel>();
            try {
                List<? extends Channel> chansAtStation = loadedNetworkSource.getChannels(station);
                Status inProg = Status.get(Stage.NETWORK_SUBSETTER, Standing.IN_PROG);
                boolean needCommit = false;
                Station dbSta = NetworkDB.getSingleton().getStation(station.getDbid());
                for (Channel channel : chansAtStation) {
                    channel.setStation(dbSta);
                    this.change(channel, inProg);
                    StringTree effectiveTimeResult = this.chanEffectiveSubsetter.accept(channel, loadedNetworkSource);
                    NetworkDB.flush();
                    if (effectiveTimeResult.isSuccess()) {
                        NetworkDB.flush();
                        boolean accepted = true;
                        List<ChannelSubsetter> list = this.chanSubsetters;
                        synchronized (list) {
                            for (ChannelSubsetter cur : this.chanSubsetters) {
                                StringTree result;
                                try {
                                    result = cur.accept(channel, loadedNetworkSource);
                                }
                                catch (Throwable t) {
                                    logger.debug("Channel subsetter exception: ", t);
                                    result = new Fail((Object)cur, "Exception", t);
                                }
                                if (result.isSuccess()) continue;
                                this.change(channel, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                                String resultToString = result.toString();
                                if (result.toString().trim().length() == 0) {
                                    resultToString = cur.getClass().getName();
                                }
                                failLogger.info("Rejected " + ChannelIdUtil.toString(channel) + ": " + resultToString);
                                accepted = false;
                                break;
                            }
                        }
                        if (!accepted) continue;
                        this.getNetworkDB().put(channel);
                        logger.debug("Accept " + ChannelIdUtil.toString(channel));
                        needCommit = true;
                        successes.add(channel);
                        this.change(channel, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
                        continue;
                    }
                    this.change(channel, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                    failLogger.info(ChannelIdUtil.toString(channel) + " was rejected because the channel was not active during the time range of requested events: " + String.valueOf(effectiveTimeResult));
                }
                if (needCommit) {
                    NetworkDB.commit();
                }
            }
            catch (Throwable e) {
                GlobalExceptionHandler.handle("Problem in method getSuccessfulChannels for " + StationIdUtil.toString(station), e);
                NetworkDB.rollback();
            }
            this.statusChanged("Waiting for a request");
            if (successes.size() == 0) {
                this.allChannelFailureStations.add(StationIdUtil.toStringNoDates(station));
            } else {
                this.allChannelFailureStations.remove(StationIdUtil.toStringNoDates(station));
            }
            return successes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelGroup> getSuccessfulChannelGroups(Station station) {
        if (!this.refresh.isNetworkBeingReloaded(station.getNetwork().getDbid()) && this.allChannelGroupFailureStations.contains(StationIdUtil.toStringNoDates(station))) {
            return new ArrayList<ChannelGroup>(0);
        }
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            while (this.refresh.isNetworkBeingReloaded(station.getNetwork().getDbid()) && this.refresh.isStationBeingReloaded(station.getDbid())) {
                try {
                    this.refresh.notifyAll();
                    this.refresh.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.allChannelGroupFailureStations.contains(StationIdUtil.toStringNoDates(station))) {
                return new ArrayList<ChannelGroup>(0);
            }
            List<ChannelGroup> sta = this.getNetworkDB().getChannelGroupsForStation(station);
            if (sta.size() != 0) {
                logger.debug("successfulChannelGroups " + station.getCode() + " - from db " + sta.size());
                return sta;
            }
            this.allChannelGroupFailureStations.add(StationIdUtil.toStringNoDates(station));
            return new ArrayList<ChannelGroup>(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ChannelGroup> getSuccessfulChannelGroupsFromServer(Station station, LoadedNetworkSource net) {
        NetworkArm networkArm = this;
        synchronized (networkArm) {
            ArrayList<Channel> failures = new ArrayList<Channel>();
            List<ChannelGroup> chanGroups = this.channelGrouper.group(this.getSuccessfulChannelsFromServer(station, net), failures);
            for (ChannelGroup cg : chanGroups) {
                this.getNetworkDB().put(cg);
            }
            if (chanGroups.size() != 0) {
                NetworkDB.commit();
                this.allChannelGroupFailureStations.remove(StationIdUtil.toStringNoDates(station));
            } else {
                this.allChannelGroupFailureStations.add(StationIdUtil.toStringNoDates(station));
            }
            for (Channel failchan : failures) {
                failLogger.info(ChannelIdUtil.toString(failchan) + "  Channel not grouped into 3 components.");
            }
            return chanGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statusChanged(String newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.setArmStatus(newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle("Problem changing status in NetworkArm", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(Channel chan, Status newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.change(chan, newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle("Problem changing channel status in NetworkArm", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(Station sta, Status newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.change(sta, newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle("Problem changing station status in NetworkArm", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(Network na, Status newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.change(na, newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle("Problem changing network status in NetworkArm", e);
                }
            }
        }
    }

    public NetworkSource getNetworkSource() {
        if (this.finder == null) {
            this.finder = new InstrumentationFromDB(this.getInternalNetworkSource());
        }
        return this.finder;
    }

    protected NetworkSource getInternalNetworkSource() {
        if (this.internalFinder == null) {
            this.internalFinder = new RetryNetworkSource(new FdsnStation());
        }
        return this.internalFinder;
    }

    protected NetworkDB getNetworkDB() {
        return NetworkDB.getSingleton();
    }

    public boolean isBeingRefreshed(Network net) {
        return this.refresh.isNetworkBeingReloaded(net.getDbid());
    }

    public boolean isBeingRefreshed(Station sta) {
        return this.refresh.isStationBeingReloaded(sta.getDbid());
    }

    public RefreshNetworkArm getRefresher() {
        return this.refresh;
    }

    public boolean isInitialStartupFinished() {
        return this.initialStartupFinished;
    }

    public ChannelGrouper getChannelGrouper() {
        return this.channelGrouper;
    }
}

