/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.mseed.MissingBlockette1000;
import edu.sc.seis.sod.AbstractWaveformRecipe;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.RequestFilterUtil;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.vector.ANDWaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorAsAvailableData;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.source.seismogram.BatchDataRequest;
import edu.sc.seis.sod.source.seismogram.ConstantSeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.PromiseSeismogramList;
import edu.sc.seis.sod.source.seismogram.PromiseSeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramAuthorizationException;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.availableData.vector.ANDAvailableDataWrapper;
import edu.sc.seis.sod.subsetter.availableData.vector.ORAvailableDataWrapper;
import edu.sc.seis.sod.subsetter.availableData.vector.VectorAvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.eventChannel.PassEventChannel;
import edu.sc.seis.sod.subsetter.eventChannel.vector.EventVectorSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.request.AtLeastOneRequest;
import edu.sc.seis.sod.subsetter.request.RequestSubsetter;
import edu.sc.seis.sod.subsetter.request.vector.ANDRequestWrapper;
import edu.sc.seis.sod.subsetter.request.vector.VectorRequestSubsetter;
import edu.sc.seis.sod.subsetter.requestGenerator.RequestGenerator;
import edu.sc.seis.sod.subsetter.requestGenerator.vector.RequestGeneratorWrapper;
import edu.sc.seis.sod.subsetter.requestGenerator.vector.VectorRequestGenerator;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import edu.sc.seis.sod.util.time.ReduceTool;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MotionVectorArm
extends AbstractWaveformRecipe
implements Subsetter {
    private boolean firstRequest = true;
    private EventVectorSubsetter eventChannelGroup = new PassEventChannel();
    private VectorRequestGenerator requestGenerator;
    private VectorRequestSubsetter request = new AtLeastOneRequest();
    private static final VectorAvailableDataSubsetter defaultVectorAvailableData = new ORAvailableDataWrapper(defaultAvailableDataSubsetter);
    private VectorAvailableDataSubsetter availData = defaultVectorAvailableData;
    private LinkedList<WaveformVectorProcess> processes = new LinkedList();
    private static final Logger logger = LoggerFactory.getLogger(MotionVectorArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.WaveformVector");

    public MotionVectorArm(Element config) throws ConfigurationException {
        this.processConfig(config);
    }

    public void add(WaveformVectorProcess process) {
        this.processes.add(process);
    }

    @Override
    public void add(WaveformProcess proc) {
        this.add(new ANDWaveformProcessWrapper(proc));
    }

    public VectorRequestGenerator getRequestGenerator() {
        return this.requestGenerator;
    }

    public WaveformVectorProcess[] getProcesses() {
        WaveformVectorProcess[] result = new WaveformVectorProcess[this.processes.size()];
        return this.processes.toArray(result);
    }

    public WaveformProcess[] getWaveformProcesses() {
        List waveformProcesses = this.getWaveformProcesses(this.getProcesses());
        return waveformProcesses.toArray(new WaveformProcess[0]);
    }

    public List getWaveformProcesses(WaveformVectorProcess[] procs) {
        ArrayList<WaveformProcess> waveformProcesses = new ArrayList<WaveformProcess>();
        for (int i = 0; i < procs.length; ++i) {
            if (procs[i] instanceof WaveformVectorProcessWrapper) {
                WaveformVectorProcess[] subProcesses = ((WaveformVectorProcessWrapper)procs[i]).getWrappedProcessors();
                waveformProcesses.addAll(this.getWaveformProcesses(subProcesses));
                continue;
            }
            if (!(procs[i] instanceof WaveformProcessWrapper)) continue;
            WaveformProcessWrapper wrapper = (WaveformProcessWrapper)procs[i];
            waveformProcesses.add(wrapper.getWrappedProcess());
        }
        return waveformProcesses;
    }

    @Override
    public void handle(Element el) throws ConfigurationException {
        Object sodObject = SodUtil.load(el, PACKAGES);
        if (sodObject instanceof EventStationSubsetter) {
            this.eventStation = (EventStationSubsetter)sodObject;
        } else if (sodObject instanceof WaveformMonitor) {
            this.addStatusMonitor((WaveformMonitor)sodObject);
        } else if (sodObject instanceof EventVectorSubsetter) {
            this.eventChannelGroup = (EventVectorSubsetter)sodObject;
        } else if (sodObject instanceof VectorRequestGenerator) {
            this.requestGenerator = (VectorRequestGenerator)sodObject;
        } else if (sodObject instanceof RequestGenerator) {
            this.requestGenerator = new RequestGeneratorWrapper((RequestGenerator)sodObject);
        } else if (sodObject instanceof VectorRequestSubsetter) {
            this.request = (VectorRequestSubsetter)sodObject;
        } else if (sodObject instanceof RequestSubsetter) {
            this.request = new ANDRequestWrapper((RequestSubsetter)sodObject);
        } else if (sodObject instanceof SeismogramSourceLocator) {
            this.dcLocator = (SeismogramSourceLocator)sodObject;
            if (this.dcLocator instanceof ConstantSeismogramSourceLocator) {
                if (Start.getRunProps().getNumWaveformWorkerThreads() == 0) {
                    logger.info("Wrapping " + String.valueOf(this.dcLocator) + " to batch requests for speed. Using 3 threads.");
                    Start.getRunProps().setNumWaveformWorkerThreads(3);
                }
                this.dcLocator = new BatchDataRequest(this.dcLocator);
            }
        } else if (sodObject instanceof VectorAvailableDataSubsetter) {
            this.availData = (VectorAvailableDataSubsetter)sodObject;
        } else if (sodObject instanceof AvailableDataSubsetter) {
            this.availData = new ANDAvailableDataWrapper((AvailableDataSubsetter)sodObject);
        } else if (sodObject instanceof WaveformVectorProcess) {
            this.add((WaveformVectorProcess)sodObject);
        } else if (sodObject instanceof WaveformProcess) {
            this.add((WaveformProcess)sodObject);
        } else {
            throw new ConfigurationException("Unknown tag in MotionVectorArm config. " + el.getLocalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMotionVectorArm(EventVectorPair ecp) {
        StringTree passed;
        StatefulEvent eventAccess = ecp.getEvent();
        ChannelGroup channel = ecp.getChannelGroup();
        EventVectorSubsetter eventVectorSubsetter = this.eventChannelGroup;
        synchronized (eventVectorSubsetter) {
            try {
                passed = this.eventChannelGroup.accept(eventAccess, channel, ecp.getCookieJar());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.EVENT_CHANNEL_SUBSETTER, e);
                return;
            }
        }
        if (passed.isSuccess()) {
            this.processRequestGeneratorSubsetter(ecp);
        } else {
            ecp.update(Status.get(Stage.EVENT_CHANNEL_SUBSETTER, Standing.REJECT));
            failLogger.info(String.valueOf(ecp) + ": " + passed.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestGeneratorSubsetter(EventVectorPair ecp) {
        RequestFilter[][] infilters;
        VectorRequestGenerator vectorRequestGenerator = this.requestGenerator;
        synchronized (vectorRequestGenerator) {
            try {
                infilters = this.requestGenerator.generateRequest(ecp.getEvent(), ecp.getChannelGroup(), ecp.getCookieJar());
                boolean found = false;
                for (int i = 0; i < infilters.length; ++i) {
                    if (infilters[i].length == 0) continue;
                    found = true;
                }
                if (!found) {
                    ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
                    failLogger.info("No request generated: " + ecp.toString());
                    return;
                }
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.REQUEST_SUBSETTER, e);
                return;
            }
        }
        this.processRequestSubsetter(ecp, infilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestSubsetter(EventVectorPair ecp, RequestFilter[][] infilters) {
        StringTree passed;
        for (int i = 0; i < infilters.length; ++i) {
            if (infilters[i].length > 0) {
                RequestFilter coveringRequest = ReduceTool.cover(infilters[i]);
                ChannelEffectiveTimeOverlap chanOverlap = new ChannelEffectiveTimeOverlap(coveringRequest.startTime, coveringRequest.endTime);
                passed = chanOverlap.accept(ecp.getChannelGroup().getChannels()[i], null);
            } else {
                passed = new Fail((Object)this.request, "RequestFilter[" + i + "] is empty");
            }
            if (passed.isSuccess()) continue;
            ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
            failLogger.info(ecp.toString() + " channel doesn't overlap request.");
            return;
        }
        VectorRequestSubsetter i = this.request;
        synchronized (i) {
            try {
                passed = this.request.accept(ecp.getEvent(), ecp.getChannelGroup(), infilters, ecp.getCookieJar());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.REQUEST_SUBSETTER, e);
                return;
            }
        }
        if (this.getProcesses().length == 0 && this.availData.equals(defaultVectorAvailableData)) {
            if (this.firstRequest) {
                this.firstRequest = false;
                logger.info("No seismogram data center has been set, so no data is being requested.  If you're only generating BreqFast requests, this is fine.  Otherwise, it's probably an error.");
            }
            return;
        }
        if (passed.isSuccess()) {
            SeismogramSource dataCenter;
            SeismogramSourceLocator seismogramSourceLocator = this.dcLocator;
            synchronized (seismogramSourceLocator) {
                try {
                    dataCenter = this.dcLocator.getSeismogramSource(ecp.getEvent(), ecp.getChannelGroup().getChannels()[0], infilters[0], ecp.getCookieJar());
                }
                catch (Throwable e) {
                    MotionVectorArm.handle(ecp, Stage.AVAILABLE_DATA_SUBSETTER, e);
                    return;
                }
            }
            this.processAvailableDataSubsetter(ecp, dataCenter, infilters);
        } else {
            ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
            failLogger.info(ecp.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAvailableDataSubsetter(EventVectorPair ecp, SeismogramSource seismogramSource, RequestFilter[][] infilters) {
        LinkedList<WaveformVectorProcess> processList = new LinkedList<WaveformVectorProcess>();
        processList.addAll(this.processes);
        RequestFilter[][] outfilters = null;
        boolean noImplAvailableData = true;
        outfilters = infilters;
        processList.addFirst(new WaveformVectorAsAvailableData(this.availData));
        StringTree result = new Pass(this.availData);
        if (!noImplAvailableData) {
            VectorAvailableDataSubsetter vectorAvailableDataSubsetter = this.availData;
            synchronized (vectorAvailableDataSubsetter) {
                try {
                    result = this.availData.accept(ecp.getEvent(), ecp.getChannelGroup(), infilters, outfilters, ecp.getCookieJar());
                }
                catch (Throwable e) {
                    MotionVectorArm.handle(ecp, Stage.AVAILABLE_DATA_SUBSETTER, e);
                    return;
                }
            }
        }
        if (result.isSuccess()) {
            for (int i = 0; i < infilters.length; ++i) {
                for (int j = 0; j < infilters[i].length; ++j) {
                    logger.debug("Getting seismograms " + ChannelIdUtil.toString(infilters[i][j].channelId) + " from " + infilters[i][j].startTime.toString() + " to " + infilters[i][j].endTime.toString());
                }
            }
            Instant before = ClockUtil.now();
            LocalSeismogramImpl[][] localSeismograms = new LocalSeismogramImpl[ecp.getChannelGroup().getChannels().length][0];
            LocalSeismogramImpl[][] tempLocalSeismograms = new LocalSeismogramImpl[ecp.getChannelGroup().getChannels().length][0];
            try {
                localSeismograms = this.getData(ecp, infilters, seismogramSource);
                Instant after = ClockUtil.now();
                logger.info("After getting seismograms, time taken=" + TimeUtils.durationToDoubleSeconds((Duration)Duration.between(before, after)) + " sec  " + localSeismograms[0].length + ", " + localSeismograms[1].length + ", " + localSeismograms[2].length);
                if (localSeismograms == null) {
                    return;
                }
            }
            catch (SeismogramSourceException e) {
                MotionVectorArm.handle(ecp, Stage.DATA_RETRIEVAL, e, seismogramSource, MotionVectorArm.requestToString(infilters, outfilters));
                return;
            }
            for (int i = 0; i < localSeismograms.length; ++i) {
                ArrayList<LocalSeismogramImpl> tempForCast = new ArrayList<LocalSeismogramImpl>();
                for (int j = 0; j < localSeismograms[i].length; ++j) {
                    if (localSeismograms[i][j] == null) {
                        ecp.update(Status.get(Stage.DATA_RETRIEVAL, Standing.REJECT));
                        logger.error("Got null in seismogram array for channel " + i + " for " + String.valueOf(ecp));
                        return;
                    }
                    Channel ecpChan = ecp.getChannelGroup().getChannels()[i];
                    if (!ChannelIdUtil.areEqual(localSeismograms[i][j].channel_id, ChannelId.of(ecpChan))) {
                        logger.warn("MV Channel id in returned seismogram doesn not match channelid in request. req=" + ChannelIdUtil.toString(ecpChan) + " seis=" + ChannelIdUtil.toString(localSeismograms[i][j].channel_id));
                        localSeismograms[i][j].channel_id = ChannelId.of(ecpChan);
                    }
                    tempForCast.add(localSeismograms[i][j]);
                }
                tempLocalSeismograms[i] = tempForCast.toArray(new LocalSeismogramImpl[0]);
            }
            this.processSeismograms(ecp, seismogramSource, infilters, outfilters, tempLocalSeismograms, processList);
        } else {
            if (ClockUtil.now().minus(Start.getRunProps().getSeismogramLatency()).isAfter(ecp.getEvent().getOrigin().getOriginTime())) {
                logger.info("Retry Reject, older than acceptible latency: " + String.valueOf(Start.getRunProps().getSeismogramLatency()) + " " + String.valueOf(ecp));
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.REJECT));
            } else if (ecp.getNumRetries() >= SodDB.getSingleton().getMaxRetries()) {
                logger.info("Retry Reject, at max retries: " + SodDB.getSingleton().getMaxRetries() + " " + String.valueOf(ecp));
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.REJECT));
            } else {
                logger.info("Retry Retry, within acceptible latency: " + String.valueOf(Start.getRunProps().getSeismogramLatency()) + " " + String.valueOf(ecp));
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.RETRY));
            }
            failLogger.info(String.valueOf(ecp) + " " + String.valueOf(result) + " on server " + String.valueOf(seismogramSource));
        }
    }

    public void processSeismograms(EventVectorPair ecp, SeismogramSource seismogramSource, RequestFilter[][] infilters, RequestFilter[][] outfilters, LocalSeismogramImpl[][] localSeismograms, LinkedList<WaveformVectorProcess> processList) {
        WaveformVectorProcess processor = null;
        WaveformVectorResult result = new WaveformVectorResult(localSeismograms, new StringTreeLeaf(this, true));
        Iterator it = processList.iterator();
        try {
            while (it.hasNext() && result.isSuccess()) {
                processor = (WaveformVectorProcess)it.next();
                result = MotionVectorArm.runProcessorThreadCheck(processor, ecp.getEvent(), ecp.getChannelGroup(), infilters, outfilters, result.getSeismograms(), ecp.getCookieJar());
            }
            logger.debug("finished with " + ChannelIdUtil.toStringNoDates(ecp.getChannelGroup().getChannels()[0]) + " success=" + result.isSuccess());
            if (result.isSuccess()) {
                ecp.update(Status.get(Stage.PROCESSOR, Standing.SUCCESS));
            } else {
                ecp.update(Status.get(Stage.PROCESSOR, Standing.REJECT));
                failLogger.info(String.valueOf(ecp) + " " + String.valueOf(result.getReason()));
            }
        }
        catch (Throwable e) {
            MotionVectorArm.handle(ecp, Stage.PROCESSOR, e, seismogramSource, MotionVectorArm.requestToString(infilters, outfilters));
            ecp.update(Status.get(Stage.PROCESSOR, Standing.SYSTEM_FAILURE));
            failLogger.info(String.valueOf(ecp) + " " + String.valueOf(e));
        }
        logger.debug("finished with " + ChannelIdUtil.toStringNoDates(ecp.getChannelGroup().getChannels()[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaveformVectorResult runProcessorThreadCheck(WaveformVectorProcess processor, CacheEvent event, ChannelGroup channel, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        if (processor instanceof Threadable && ((Threadable)((Object)processor)).isThreadSafe()) {
            return MotionVectorArm.internalRunProcessor(processor, event, channel, original, available, seismograms, cookieJar);
        }
        WaveformVectorProcess waveformVectorProcess = processor;
        synchronized (waveformVectorProcess) {
            return MotionVectorArm.internalRunProcessor(processor, event, channel, original, available, seismograms, cookieJar);
        }
    }

    private static WaveformVectorResult internalRunProcessor(WaveformVectorProcess processor, CacheEvent event, ChannelGroup channel, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, MeasurementStorage cookieJar) throws Exception {
        WaveformVectorResult result;
        try {
            result = processor.accept(event, channel, original, available, seismograms, cookieJar);
        }
        catch (FissuresException e) {
            if (e.getCause() instanceof CodecException) {
                result = new WaveformVectorResult(seismograms, new Fail((Object)processor, "Unable to decompress data", e));
            }
            throw e;
        }
        catch (CodecException e) {
            result = new WaveformVectorResult(seismograms, new Fail((Object)processor, "Unable to decompress data", e));
        }
        return result;
    }

    private LocalSeismogramImpl[][] getData(EventVectorPair ecp, RequestFilter[][] rf, SeismogramSource seismogramSource) throws SeismogramSourceException {
        LocalSeismogramImpl[][] localSeismograms = new LocalSeismogramImpl[rf.length][];
        if (seismogramSource instanceof PromiseSeismogramSource) {
            PromiseSeismogramSource promiseSource = (PromiseSeismogramSource)seismogramSource;
            ArrayList<List<RequestFilter>> in = new ArrayList<List<RequestFilter>>();
            for (int i = 0; i < rf.length; ++i) {
                in.add(Arrays.asList(rf[i]));
            }
            List<PromiseSeismogramList> promiseList = promiseSource.promiseRetrieveDataList(in);
            for (int i = 0; i < localSeismograms.length; ++i) {
                PromiseSeismogramList pseisList = promiseList.get(i);
                List<LocalSeismogramImpl> s = pseisList.getResult();
                localSeismograms[i] = s.toArray(new LocalSeismogramImpl[0]);
            }
        } else {
            for (int i = 0; i < rf.length; ++i) {
                if (rf[i].length != 0) {
                    logger.debug("before retrieve_seismograms");
                    localSeismograms[i] = seismogramSource.retrieveData(Arrays.asList(rf[i])).toArray(new LocalSeismogramImpl[0]);
                    logger.debug("after successful retrieve_seismograms " + localSeismograms[i].length);
                    if (localSeismograms[i].length <= 0 || ChannelIdUtil.areEqual(localSeismograms[i][0].channel_id, rf[i][0].channelId)) continue;
                    logger.warn("MV X Channel id in returned seismogram doesn not match channelid in request. req=" + ChannelIdUtil.toString(rf[i][0].channelId) + " seis=" + ChannelIdUtil.toString(localSeismograms[i][0].channel_id));
                    continue;
                }
                logger.debug("Failed, retrieve data, no requestFilters for component " + i + " continuing with remaining components.");
                localSeismograms[i] = new LocalSeismogramImpl[0];
            }
        }
        return localSeismograms;
    }

    private static void handle(EventVectorPair ecp, Stage stage, Throwable t) {
        MotionVectorArm.handle(ecp, stage, t, null, "");
    }

    protected static String requestToString(RequestFilter[][] in, RequestFilter[][] avail) {
        Object message = "";
        message = (String)message + "\n in=" + RequestFilterUtil.toString(in);
        message = (String)message + "\n avail=" + RequestFilterUtil.toString(avail);
        return message;
    }

    protected static void handle(AbstractEventChannelPair ecp, Stage stage, Throwable t, SeismogramSource seismogramSource, String requestString) {
        block10: {
            try {
                if (t instanceof OutOfMemoryError) {
                    t.printStackTrace(System.err);
                    logger.error("", t);
                    break block10;
                }
                if (t instanceof SeismogramAuthorizationException) {
                    Start.armFailure(Start.getWaveformArmArray()[0], t);
                    break block10;
                }
                if (t instanceof SeismogramSourceException) {
                    if (t.getCause() != null && t.getCause() instanceof MissingBlockette1000) {
                        ecp.update(Status.get(stage, Standing.REJECT));
                        failLogger.info("Data decompression failure, miniseed without B1000 is not miniseed. " + String.valueOf(ecp) + " " + t.getMessage());
                    } else if (t.getCause() != null && t.getCause() instanceof SocketTimeoutException) {
                        ecp.update(Status.get(stage, Standing.CORBA_FAILURE));
                    }
                    break block10;
                }
                ecp.update(t, Status.get(stage, Standing.SYSTEM_FAILURE));
                Object message = "";
                try {
                    message = (String)message + " " + String.valueOf(ecp) + "\n";
                }
                catch (Throwable lazy) {
                    message = (String)message + "LazyInitializationException after exception, so I can't print the evp\n";
                }
                message = (String)message + "Source=" + String.valueOf(seismogramSource) + "\n";
                message = (String)message + "Request=" + requestString + "\n";
                failLogger.warn((String)message, t);
            }
            catch (Throwable tt) {
                GlobalExceptionHandler.handle("Caught " + String.valueOf(tt) + " while handling " + String.valueOf(t), t);
            }
        }
    }
}

