/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.AbstractWaveformRecipe;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.RequestFilterUtil;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.process.waveform.WaveformAsAvailableData;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.source.seismogram.BatchDataRequest;
import edu.sc.seis.sod.source.seismogram.ConstantSeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.PassEventChannel;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.request.AtLeastOneRequest;
import edu.sc.seis.sod.subsetter.request.RequestSubsetter;
import edu.sc.seis.sod.subsetter.requestGenerator.RequestGenerator;
import edu.sc.seis.sod.util.time.ClockUtil;
import edu.sc.seis.sod.util.time.ReduceTool;
import edu.sc.seis.sod.util.time.SortTool;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class LocalSeismogramArm
extends AbstractWaveformRecipe
implements Subsetter {
    private boolean firstRequest;
    private EventChannelSubsetter eventChannel = new PassEventChannel();
    private RequestGenerator requestGenerator;
    private RequestSubsetter request = new AtLeastOneRequest();
    private AvailableDataSubsetter availData = defaultAvailableDataSubsetter;
    private LinkedList<WaveformProcess> processes = new LinkedList();
    private static final Logger logger = LoggerFactory.getLogger(LocalSeismogramArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.Waveform");

    public LocalSeismogramArm(Element config) throws ConfigurationException {
        WaveformProcess[] p;
        this.processConfig(config);
        logger.info("EventStation: " + this.getEventStationSubsetter().getClass().getName());
        logger.info("EventChannel: " + this.getEventChannelSubsetter().getClass().getName());
        logger.info("RequestGenerator: " + this.getRequestGenerator().getClass().getName());
        logger.info("RequestSubsetter: " + this.getRequestSubsetter().getClass().getName());
        logger.info("SeismogramSourceLocator: " + this.getSeismogramDCLocator().getClass().getName());
        logger.info("AvailableDataSubsetter: " + this.getAvailableDataSubsetter().getClass().getName());
        for (WaveformProcess process : p = this.getProcesses()) {
            logger.info("WaveformProcess: " + process.getClass().getName());
        }
    }

    @Override
    public void handle(Element el) throws ConfigurationException {
        Object sodObject = SodUtil.load(el, PACKAGES);
        if (sodObject instanceof EventStationSubsetter) {
            this.eventStation = (EventStationSubsetter)sodObject;
        } else if (sodObject instanceof WaveformMonitor) {
            this.addStatusMonitor((WaveformMonitor)sodObject);
        } else if (sodObject instanceof EventChannelSubsetter) {
            this.eventChannel = (EventChannelSubsetter)sodObject;
        } else if (sodObject instanceof RequestGenerator) {
            this.requestGenerator = (RequestGenerator)sodObject;
        } else if (sodObject instanceof RequestSubsetter) {
            this.request = (RequestSubsetter)sodObject;
        } else if (sodObject instanceof SeismogramSourceLocator) {
            this.dcLocator = (SeismogramSourceLocator)sodObject;
            if (this.dcLocator instanceof ConstantSeismogramSourceLocator) {
                if (Start.getRunProps().getNumWaveformWorkerThreads() == 0) {
                    logger.info("Wrapping " + String.valueOf(this.dcLocator) + " to batch requests for speed. Using 6 threads.");
                    Start.getRunProps().setNumWaveformWorkerThreads(6);
                }
                this.dcLocator = new BatchDataRequest(this.dcLocator);
            }
        } else if (sodObject instanceof AvailableDataSubsetter) {
            this.availData = (AvailableDataSubsetter)sodObject;
        } else if (sodObject instanceof WaveformProcess) {
            this.add((WaveformProcess)sodObject);
        } else {
            throw new ConfigurationException("Unknown tag in LocalSeismogramArm config. " + el.getLocalName());
        }
    }

    public EventChannelSubsetter getEventChannelSubsetter() {
        return this.eventChannel;
    }

    public RequestGenerator getRequestGenerator() {
        return this.requestGenerator;
    }

    public RequestSubsetter getRequestSubsetter() {
        return this.request;
    }

    public AvailableDataSubsetter getAvailableDataSubsetter() {
        return this.availData;
    }

    public SeismogramSourceLocator getSeismogramDCLocator() {
        return this.dcLocator;
    }

    public WaveformProcess[] getProcesses() {
        return this.processes.toArray(new WaveformProcess[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(WaveformProcess proc) {
        if (proc == null) {
            throw new IllegalArgumentException("WaveformProcess cannot be null");
        }
        LocalSeismogramArm localSeismogramArm = this;
        synchronized (localSeismogramArm) {
            if (this.processes == null) {
                this.processes = new LinkedList();
            }
        }
        this.processes.add(proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalSeismogramArm(EventChannelPair ecp) {
        StringTree passed;
        logger.debug("Begin ECP: " + ecp.toString());
        logger.debug("      ESP: " + ecp.getEsp().toString());
        ecp.update(Status.get(Stage.EVENT_CHANNEL_SUBSETTER, Standing.IN_PROG));
        StatefulEvent eventAccess = ecp.getEvent();
        Channel channel = ecp.getChannel();
        EventChannelSubsetter eventChannelSubsetter = this.eventChannel;
        synchronized (eventChannelSubsetter) {
            try {
                passed = this.eventChannel.accept(eventAccess, channel, ecp.getMeasurements());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.EVENT_CHANNEL_SUBSETTER, e, null, "");
                return;
            }
        }
        if (passed.isSuccess()) {
            this.processRequestGeneratorSubsetter(ecp);
        } else {
            ecp.update(Status.get(Stage.EVENT_CHANNEL_SUBSETTER, Standing.REJECT));
            failLogger.info(String.valueOf(ecp) + ": " + passed.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestGeneratorSubsetter(EventChannelPair ecp) {
        RequestFilter[] infilters;
        RequestGenerator requestGenerator = this.requestGenerator;
        synchronized (requestGenerator) {
            try {
                infilters = this.requestGenerator.generateRequest(ecp.getEvent(), ecp.getChannel(), ecp.getCookieJar());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.REQUEST_SUBSETTER, e, null, "");
                return;
            }
        }
        if (infilters.length == 0) {
            ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
            failLogger.info("No request generated: " + ecp.toString());
        } else {
            this.processRequestSubsetter(ecp, SortTool.byBeginTimeAscending(infilters));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestSubsetter(EventChannelPair ecp, RequestFilter[] infilters) {
        RequestFilter coveringRequest = ReduceTool.cover(infilters);
        ChannelEffectiveTimeOverlap chanOverlap = new ChannelEffectiveTimeOverlap(coveringRequest.startTime, coveringRequest.endTime);
        StringTree passed = chanOverlap.accept(ecp.getChannel(), null);
        if (!passed.isSuccess()) {
            ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
            failLogger.info(ecp.toString() + " channel doesn't overlap request.");
            return;
        }
        RequestSubsetter requestSubsetter = this.request;
        synchronized (requestSubsetter) {
            try {
                passed = this.request.accept(ecp.getEvent(), ecp.getChannel(), infilters, ecp.getCookieJar());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.REQUEST_SUBSETTER, e, null, LocalSeismogramArm.requestToString(infilters, null));
                return;
            }
        }
        if (this.getProcesses().length == 0 && this.getAvailableDataSubsetter().equals(defaultAvailableDataSubsetter)) {
            if (this.firstRequest) {
                this.firstRequest = false;
                logger.info("No seismogram processors have been set, so no data is being requested.  If you're only generating BreqFast requests, this is fine.  Otherwise, it's probably an error.");
            }
            ecp.update(Status.get(Stage.PROCESSOR, Standing.SUCCESS));
            return;
        }
        if (passed.isSuccess()) {
            SeismogramSource dataCenter = null;
            SeismogramSourceLocator seismogramSourceLocator = this.dcLocator;
            synchronized (seismogramSourceLocator) {
                try {
                    dataCenter = this.dcLocator.getSeismogramSource(ecp.getEvent(), ecp.getChannel(), infilters, ecp.getCookieJar());
                }
                catch (Throwable e) {
                    MotionVectorArm.handle(ecp, Stage.AVAILABLE_DATA_SUBSETTER, e, dataCenter, LocalSeismogramArm.requestToString(infilters, null));
                    return;
                }
            }
            this.processAvailableDataSubsetter(ecp, dataCenter, infilters);
        } else {
            ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
            failLogger.info(ecp.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAvailableDataSubsetter(EventChannelPair ecp, SeismogramSource seismogramSource, RequestFilter[] infilters) {
        LinkedList<WaveformProcess> processList = new LinkedList<WaveformProcess>();
        processList.addAll(this.processes);
        RequestFilter[] outfilters = null;
        if (infilters.length > 0) {
            logger.debug("Trying available_data for " + ChannelIdUtil.toString(infilters[0].channelId) + " from " + infilters[0].startTime.toString() + " to " + infilters[0].endTime.toString());
        } else {
            logger.debug("Empty request generated for " + ChannelIdUtil.toString(ecp.getChannel()));
        }
        boolean noImplAvailableData = true;
        outfilters = infilters;
        processList.addFirst(new WaveformAsAvailableData(this.availData));
        outfilters = SortTool.byBeginTimeAscending(outfilters);
        StringTree passed = new Pass(this.availData);
        if (!noImplAvailableData) {
            AvailableDataSubsetter availableDataSubsetter = this.availData;
            synchronized (availableDataSubsetter) {
                try {
                    passed = this.availData.accept(ecp.getEvent(), ecp.getChannel(), infilters, outfilters, ecp.getCookieJar());
                }
                catch (Throwable e) {
                    MotionVectorArm.handle(ecp, Stage.AVAILABLE_DATA_SUBSETTER, e, seismogramSource, LocalSeismogramArm.requestToString(infilters, outfilters));
                    return;
                }
            }
        }
        if (noImplAvailableData || passed.isSuccess()) {
            for (int i = 0; i < infilters.length; ++i) {
                logger.debug("Getting seismograms " + ChannelIdUtil.toString(infilters[i].channelId) + " from " + infilters[i].startTime.toString() + " to " + infilters[i].endTime.toString());
            }
            Instant before = ClockUtil.now();
            LocalSeismogramImpl[] localSeismograms = new LocalSeismogramImpl[]{};
            if (outfilters.length != 0) {
                try {
                    localSeismograms = seismogramSource.retrieveData(Arrays.asList(infilters)).toArray(new LocalSeismogramImpl[0]);
                }
                catch (SeismogramSourceException e) {
                    MotionVectorArm.handle(ecp, Stage.DATA_RETRIEVAL, e, seismogramSource, LocalSeismogramArm.requestToString(infilters, outfilters));
                    return;
                }
                logger.debug("after successful retrieve_seismograms");
                if (localSeismograms.length > 0 && !ChannelIdUtil.areEqual(localSeismograms[0].channel_id, infilters[0].channelId)) {
                    logger.warn("X Channel id in returned seismogram doesn not match channelid in request. req=" + ChannelIdUtil.toString(infilters[0].channelId) + " seis=" + ChannelIdUtil.toString(localSeismograms[0].channel_id));
                }
            } else {
                failLogger.info(String.valueOf(ecp) + " retrieve data returned no seismograms: ");
                localSeismograms = new LocalSeismogramImpl[]{};
            }
            Instant after = ClockUtil.now();
            logger.info("After getting " + localSeismograms.length + " seismograms, time taken=" + ClockUtil.formatDuration(before, after));
            LinkedList<LocalSeismogramImpl> tempForCast = new LinkedList<LocalSeismogramImpl>();
            for (int i = 0; i < localSeismograms.length; ++i) {
                if (localSeismograms[i] == null) {
                    ecp.update(Status.get(Stage.DATA_RETRIEVAL, Standing.REJECT));
                    logger.error("Got null in seismogram array " + ChannelIdUtil.toString(ecp.getChannel()));
                    return;
                }
                Channel ecpChan = ecp.getChannel();
                if (!ChannelIdUtil.areEqual(localSeismograms[i].channel_id, infilters[0].channelId)) {
                    logger.warn("Channel id in returned seismogram doesn not match channelid in request. req=" + ChannelIdUtil.toStringFormatDates(infilters[0].channelId) + " seis=" + ChannelIdUtil.toStringFormatDates(localSeismograms[i].channel_id));
                    localSeismograms[i].channel_id = ChannelId.of(ecpChan);
                }
                tempForCast.add(localSeismograms[i]);
            }
            LocalSeismogramImpl[] tempLocalSeismograms = tempForCast.toArray(new LocalSeismogramImpl[0]);
            this.processSeismograms(ecp, seismogramSource, infilters, outfilters, SortTool.byBeginTimeAscending(tempLocalSeismograms), processList);
        } else {
            if (ClockUtil.now().minus(Start.getRunProps().getSeismogramLatency()).isAfter(ecp.getEvent().getOrigin().getOriginTime())) {
                logger.info("Retry Reject, older than acceptible latency: " + String.valueOf(Start.getRunProps().getSeismogramLatency()) + " " + String.valueOf(ecp));
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.REJECT));
            } else if (ecp.getNumRetries() >= SodDB.getSingleton().getMaxRetries()) {
                logger.info("Retry Reject, at max retries: " + SodDB.getSingleton().getMaxRetries() + " " + String.valueOf(ecp));
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.REJECT));
            } else {
                logger.info("Retry Retry, within acceptible latency: " + String.valueOf(Start.getRunProps().getSeismogramLatency()) + " " + String.valueOf(ecp));
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.RETRY));
            }
            failLogger.info(String.valueOf(ecp) + ": " + passed.toString());
        }
    }

    public void processSeismograms(EventChannelPair ecp, SeismogramSource dataCenter, RequestFilter[] infilters, RequestFilter[] outfilters, LocalSeismogramImpl[] localSeismograms, List<WaveformProcess> processList) {
        WaveformProcess processor = null;
        Iterator<WaveformProcess> it = processList.iterator();
        WaveformResult result = new WaveformResult(true, localSeismograms, this);
        try {
            while (it.hasNext() && result.isSuccess()) {
                processor = it.next();
                result = LocalSeismogramArm.runProcessorThreadCheck(processor, ecp.getEvent(), ecp.getChannel(), infilters, outfilters, result.getSeismograms(), ecp.getCookieJar());
            }
            logger.debug("finished with " + ChannelIdUtil.toStringNoDates(ecp.getChannel()) + " success=" + result.isSuccess());
            if (result.isSuccess()) {
                ecp.update(Status.get(Stage.PROCESSOR, Standing.SUCCESS));
            } else {
                ecp.update(Status.get(Stage.PROCESSOR, Standing.REJECT));
                failLogger.info(String.valueOf(ecp) + " " + String.valueOf(result.getReason()));
            }
        }
        catch (Throwable e) {
            MotionVectorArm.handle(ecp, Stage.PROCESSOR, e, dataCenter, LocalSeismogramArm.requestToString(infilters, outfilters));
            ecp.update(Status.get(Stage.PROCESSOR, Standing.SYSTEM_FAILURE));
            failLogger.info(String.valueOf(ecp) + " " + String.valueOf(e));
        }
        logger.debug("finished with " + ChannelIdUtil.toStringNoDates(ecp.getChannel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaveformResult runProcessorThreadCheck(WaveformProcess processor, CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        WaveformResult out;
        if (processor instanceof Threadable && ((Threadable)((Object)processor)).isThreadSafe()) {
            out = LocalSeismogramArm.internalRunProcessor(processor, event, channel, original, available, seismograms, cookieJar);
        } else {
            WaveformProcess waveformProcess = processor;
            synchronized (waveformProcess) {
                out = LocalSeismogramArm.internalRunProcessor(processor, event, channel, original, available, seismograms, cookieJar);
            }
        }
        if (out == null) {
            logger.warn("Processor " + processor.getClass().getName() + " returned null for WaveformResult: " + String.valueOf(processor.getClass()));
            return new WaveformResult(seismograms, new Pass(processor));
        }
        return out;
    }

    private static WaveformResult internalRunProcessor(WaveformProcess processor, CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        WaveformResult result;
        try {
            result = processor.accept(event, channel, original, available, seismograms, cookieJar);
        }
        catch (FissuresException e) {
            if (e.getCause() instanceof CodecException) {
                result = new WaveformResult(seismograms, new Fail((Object)processor, "Unable to decompress data", e));
            }
            throw e;
        }
        catch (CodecException e) {
            result = new WaveformResult(seismograms, new Fail((Object)processor, "Unable to decompress data", e));
        }
        return result;
    }

    protected static String requestToString(RequestFilter[] in, RequestFilter[] avail) {
        Object message = "";
        message = (String)message + "\n in=" + RequestFilterUtil.toString(in);
        message = (String)message + "\n avail=" + RequestFilterUtil.toString(avail);
        return message;
    }
}

