/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.bag.OrientationUtil;
import edu.sc.seis.sod.channelGroup.Rule;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.validator.Validator;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ChannelGrouper {
    private static Logger logger = LoggerFactory.getLogger(ChannelGrouper.class);
    private List<Rule> defaultRules;
    private List<Rule> additionalRules;
    List<Rule> ruleList = new ArrayList<Rule>();
    private static String defaultConfigFileLoc = "jar:edu/sc/seis/sod/data/grouper.xml";
    private static final String grouperSchemaLoc = "edu/sc/seis/sod/data/grouper.rng";

    public ChannelGrouper() throws ConfigurationException {
        this(null);
    }

    public ChannelGrouper(String configFileLoc) throws ConfigurationException {
        try {
            this.defaultRules = this.loadRules(defaultConfigFileLoc);
            this.additionalRules = this.loadRules(configFileLoc);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to configure three component rules", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Unable to configure three component rules", e);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to configure three component rules", e);
        }
    }

    public List<ChannelGroup> group(List<Channel> channels, List<Channel> failures) {
        return this.applyRules(channels, this.defaultRules, this.additionalRules, failures);
    }

    private List<ChannelGroup> applyRules(List<Channel> channels, List<Rule> defaultRules, List<Rule> additionalRules, List<Channel> failures) {
        LinkedList<ChannelGroup> groupableChannels = new LinkedList<ChannelGroup>();
        HashMap<String, List<Channel>> bandGain = this.groupByNetStaBandGain(channels);
        for (String key : bandGain.keySet()) {
            List<ChannelGroup> groups;
            ArrayList<Object> stillToTest;
            ArrayList<Channel> toTest = new ArrayList<Channel>();
            toTest.addAll((Collection)bandGain.get(key));
            for (Rule rule : additionalRules) {
                stillToTest = new ArrayList<Channel>();
                groups = rule.acceptable(toTest, stillToTest);
                groupableChannels.addAll(groups);
                toTest = stillToTest;
            }
            for (Rule rule : defaultRules) {
                stillToTest = new ArrayList();
                groups = rule.acceptable(toTest, stillToTest);
                groupableChannels.addAll(groups);
                toTest = stillToTest;
            }
            failures.addAll(toTest);
        }
        return groupableChannels;
    }

    public static boolean sanityCheck(ChannelGroup channelGroup) {
        return ChannelGrouper.haveSameSamplingRate(channelGroup) && ChannelGrouper.areOrthogonal(channelGroup);
    }

    private static boolean areOrthogonal(ChannelGroup channelGroup) {
        Channel[] chans = channelGroup.getChannels();
        for (int i = 0; i < chans.length; ++i) {
            for (int j = i + 1; j < chans.length; ++j) {
                if (OrientationUtil.areOrthogonal(chans[i], chans[j])) continue;
                logger.info("Fail areOrthogonal (" + i + "," + j + "): " + ChannelIdUtil.toString(chans[i]) + " " + OrientationUtil.toString(Orientation.of(chans[i])) + " " + ChannelIdUtil.toString(chans[j]) + " " + OrientationUtil.toString(Orientation.of(chans[j])));
                return false;
            }
        }
        return true;
    }

    private static boolean haveSameSamplingRate(ChannelGroup cg) {
        Channel[] chans = cg.getChannels();
        SamplingImpl sampl = SamplingImpl.of(chans[0]);
        QuantityImpl freq = sampl.getFrequency();
        UnitImpl baseUnit = freq.getUnit();
        double samplingRate0 = freq.getValue() * (double)sampl.getNumPoints();
        for (int i = 1; i < chans.length; ++i) {
            SamplingImpl sample = SamplingImpl.of(chans[i]);
            double sampleRate = sample.getFrequency().convertTo(baseUnit).getValue() * (double)sample.getNumPoints();
            if (sampleRate == samplingRate0) continue;
            logger.info("Fail haveSameSamplingRate (" + i + "): " + ChannelIdUtil.toString(chans[i]) + " " + String.valueOf(SamplingImpl.of(chans[i])) + " " + ChannelIdUtil.toString(chans[0]) + " " + String.valueOf(SamplingImpl.of(chans[0])));
            return false;
        }
        return true;
    }

    HashMap<String, List<Channel>> groupByNetStaBandGain(List<Channel> channels) {
        HashMap<String, List<Channel>> bandGain = new HashMap<String, List<Channel>>();
        for (Channel c : channels) {
            Instant msd = c.getStartDateTime();
            Object key = c.getNetworkId() + "." + c.getStationCode() + "." + c.getCode();
            key = ((String)key).substring(0, ((String)key).length() - 1);
            key = String.valueOf(msd) + (String)key;
            List<Channel> chans = bandGain.get(key);
            if (chans == null) {
                chans = new LinkedList<Channel>();
                bandGain.put((String)key, chans);
            }
            chans.add(c);
        }
        return bandGain;
    }

    private List<Rule> loadRules(String configFileLoc) throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        ArrayList<Rule> out = new ArrayList<Rule>();
        if (configFileLoc != null && configFileLoc.length() != 0) {
            Validator validator = new Validator(grouperSchemaLoc);
            if (!validator.validate(this.getRules(configFileLoc))) {
                throw new ConfigurationException("Invalid config file! " + configFileLoc + " " + validator.getErrorMessage());
            }
            Document doc = Start.createDoc(this.getRules(configFileLoc), configFileLoc);
            NodeList ruleList = doc.getElementsByTagName("rule");
            for (int i = 0; i < ruleList.getLength(); ++i) {
                out.add(new Rule((Element)ruleList.item(i), configFileLoc + " " + i));
            }
        }
        return out;
    }

    private InputSource getRules(String configFileLoc) throws IOException {
        ClassLoader loader = ChannelGrouper.class.getClassLoader();
        return Start.createInputSource(loader, configFileLoc);
    }
}

