/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.eventpair.CookieEventPair;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventNetworkPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.hibernate.eventpair.StatusNotify;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.source.seismogram.BatchDataRequest;
import edu.sc.seis.sod.source.seismogram.FdsnDataSelect;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.availableData.SomeCoverage;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.PassEventStation;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractWaveformRecipe
implements StatusNotify {
    private Set<WaveformMonitor> statusMonitors = Collections.synchronizedSet(new HashSet());
    public static final String[] PACKAGES = new String[]{"waveformArm", "availableData", "availableData.vector", "eventChannel", "eventChannel.vector", "eventStation", "request", "request.vector", "requestGenerator", "requestGenerator.vector", "waveform", "waveform.vector", "seismogram"};
    protected EventStationSubsetter eventStation = new PassEventStation();
    protected SeismogramSourceLocator dcLocator = new FdsnDataSelect();
    protected static final AvailableDataSubsetter defaultAvailableDataSubsetter = new SomeCoverage();
    private static final Logger logger = LoggerFactory.getLogger(AbstractWaveformRecipe.class);

    public AbstractWaveformRecipe() {
        try {
            this.dcLocator = new BatchDataRequest(new FdsnDataSelect());
        }
        catch (ConfigurationException e) {
            logger.warn("Unable to instatiate BatchDataRequest, using thread per request", (Throwable)e);
            this.dcLocator = new FdsnDataSelect();
        }
    }

    public void addStatusMonitor(WaveformMonitor monitor) {
        this.statusMonitors.add(monitor);
    }

    protected abstract void handle(Element var1) throws ConfigurationException;

    protected void processConfig(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element el = (Element)children.item(i);
            this.handle(el);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStatus(CookieEventPair ecp) {
        Set<WaveformMonitor> set = this.statusMonitors;
        synchronized (set) {
            Iterator<WaveformMonitor> it = this.statusMonitors.iterator();
            while (it.hasNext()) {
                try {
                    WaveformMonitor monitor = it.next();
                    if (ecp instanceof EventChannelPair) {
                        monitor.update((EventChannelPair)ecp);
                        continue;
                    }
                    if (ecp instanceof EventVectorPair) {
                        monitor.update((EventVectorPair)ecp);
                        continue;
                    }
                    if (ecp instanceof EventStationPair) {
                        monitor.update((EventStationPair)ecp);
                        continue;
                    }
                    throw new RuntimeException("shouldn't happen: " + String.valueOf(ecp.getClass()));
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Problem in setStatus", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStatus(EventNetworkPair ecp) {
        Set<WaveformMonitor> set = this.statusMonitors;
        synchronized (set) {
            Iterator<WaveformMonitor> it = this.statusMonitors.iterator();
            while (it.hasNext()) {
                try {
                    it.next().update(ecp);
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Problem in setStatus", e);
                }
            }
        }
    }

    public EventStationSubsetter getEventStationSubsetter() {
        return this.eventStation;
    }

    public abstract void add(WaveformProcess var1);
}

