/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.XYPlot;
import java.awt.Container;
import java.util.Vector;

public class VelocityPlot
extends XYPlot {
    public VelocityPlot(Container parent) {
        super(parent);
        this.title = "Velocity";
        this.xLabel = "velocity (km/sec)";
        this.yLabel = "depth (km)";
        this.xTickWidth = 1;
        this.yTickWidth = 500;
    }

    public VelocityPlot(Container parent, int width, int height) {
        super(parent, width, height);
        this.title = "Velocity";
        this.xLabel = "velocity (km/sec)";
        this.yLabel = "depth (km)";
        this.xTickWidth = 1;
        this.yTickWidth = 500;
    }

    public void plot(VelocityModel velModel, char waveTypeA, char waveTypeB) throws NoSuchMatPropException {
        this.plot(velModel, waveTypeA);
        this.xData = new double[2 * velModel.getNumLayers()];
        this.yData = new double[2 * velModel.getNumLayers()];
        int j = 0;
        for (int i = 0; i < velModel.getNumLayers(); ++i) {
            this.yData[j] = velModel.radiusOfEarth - velModel.depthAtTop(i);
            this.xData[j] = velModel.evaluateAtTop(i, waveTypeB);
            if (this.DEBUG) {
                System.out.println("x " + this.xData[j] + " y " + this.yData[j]);
            }
            this.yData[++j] = velModel.radiusOfEarth - velModel.depthAtBottom(i) - this.minY;
            this.xData[j] = velModel.evaluateAtBottom(i, waveTypeB);
            if (this.DEBUG) {
                System.out.println("x " + this.xData[j] + " y " + this.yData[j]);
            }
            ++j;
        }
        this.xSegments.addElement(this.xData);
        this.ySegments.addElement(this.yData);
        this.xData = null;
        this.yData = null;
    }

    public void plot(VelocityModel velModel, char waveType) throws NoSuchMatPropException {
        this.zoomMinX = this.minX = 0.0;
        this.zoomMaxX = this.maxX = 15.0;
        this.zoomMinY = this.minY = 0.0;
        this.zoomMaxY = this.maxY = velModel.radiusOfEarth;
        this.xSegments = new Vector();
        this.ySegments = new Vector();
        this.xData = new double[2 * velModel.getNumLayers()];
        this.yData = new double[2 * velModel.getNumLayers()];
        int j = 0;
        for (int i = 0; i < velModel.getNumLayers(); ++i) {
            this.yData[j] = velModel.radiusOfEarth - velModel.depthAtTop(i);
            this.xData[j] = velModel.evaluateAtTop(i, waveType);
            if (this.DEBUG) {
                System.out.println(this.xData[j] + " " + this.yData[j]);
            }
            this.yData[++j] = velModel.radiusOfEarth - velModel.depthAtBottom(i) - this.minY;
            this.xData[j] = velModel.evaluateAtBottom(i, waveType);
            if (this.DEBUG) {
                System.out.println(this.xData[j] + " " + this.yData[j]);
            }
            ++j;
        }
        if (this.DEBUG) {
            System.out.println("> ");
        }
        this.xSegments.addElement(this.xData);
        this.ySegments.addElement(this.yData);
        this.xData = null;
        this.yData = null;
        this.repaint();
    }
}

