/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

public class TimeDist
implements Cloneable {
    private double p;
    private double depth;
    private double time;
    private double distRadian;

    public TimeDist() {
        this.p = 0.0;
        this.depth = 0.0;
        this.time = 0.0;
        this.distRadian = 0.0;
    }

    public TimeDist(double p) {
        this.p = p;
        this.depth = 0.0;
        this.time = 0.0;
        this.distRadian = 0.0;
    }

    public TimeDist(double p, double time, double dist) {
        this.p = p;
        this.depth = 0.0;
        this.time = time;
        this.distRadian = dist;
    }

    public TimeDist(double p, double time, double dist, double depth) {
        this.p = p;
        this.depth = depth;
        this.time = time;
        this.distRadian = dist;
    }

    public TimeDist add(TimeDist td) {
        return new TimeDist(this.getP(), this.getTime() + td.getTime(), this.getDistRadian() + td.getDistRadian(), td.getDepth());
    }

    public TimeDist negateDistance() {
        return new TimeDist(this.getP(), this.getTime(), -1.0 * this.getDistRadian(), this.getDepth());
    }

    public String toString() {
        String desc = "p= " + this.p + " time=" + this.time + " dist=" + this.getDistDeg() + "(" + this.distRadian + " rad) depth=" + this.depth;
        return desc;
    }

    public double getP() {
        return this.p;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getTime() {
        return this.time;
    }

    public double getDistRadian() {
        return this.distRadian;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDistRadian();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }
}

