/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.IOException;
import java.io.PrintWriter;

public class TauP_VelocityPlot
extends TauP_Tool {
    public static final String DEFAULT_OUTFILE = "taup_velocitymodel";
    float mapWidth = 6.0f;
    int plotOffset = 80;
    String modelName;
    String modelType;
    String overlayModelName = null;
    String overlayModelType = null;

    public TauP_VelocityPlot() {
        this.setOutFileBase(DEFAULT_OUTFILE);
    }

    @Override
    public void start() throws SlownessModelException, TauModelException, VelocityModelException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        if (this.getOutFileBase() == DEFAULT_OUTFILE) {
            this.setOutFileBase(vMod.modelName + "_vel");
        }
        if (this.getOutputFormat() == "svg") {
            this.printSVG(this.getWriter(), vMod);
        } else if (this.getOutputFormat() == "csv") {
            this.printCSV(this.getWriter(), vMod);
        } else {
            vMod.printGMT(this.getOutFile());
        }
    }

    public void printSVG(PrintWriter out, VelocityModel vMod) {
        double maxVel = 0.0;
        for (VelocityLayer vLayer : vMod.layer) {
            if (vLayer.getTopPVelocity() > maxVel) {
                maxVel = vLayer.getTopPVelocity();
            }
            if (vLayer.getBotPVelocity() > maxVel) {
                maxVel = vLayer.getBotPVelocity();
            }
            if (vLayer.getTopSVelocity() > maxVel) {
                maxVel = vLayer.getTopSVelocity();
            }
            if (!(vLayer.getBotSVelocity() > maxVel)) continue;
            maxVel = vLayer.getBotSVelocity();
        }
        double minVel = 0.0;
        maxVel *= 1.05;
        int numXTicks = 5;
        double maxY = vMod.maxRadius;
        double minY = 0.0;
        int numYTicks = 10;
        float pixelWidth = 72.0f * this.mapWidth - (float)this.plotOffset;
        float margin = 40.0f;
        float plotWidth = pixelWidth - margin;
        String title = vMod.modelName;
        this.printSVGBeginning(out);
        SvgUtil.createXYAxes(out, minVel, maxVel, numXTicks, maxY, minY, numYTicks, pixelWidth, margin, title);
        out.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
        out.println("<g transform=\"scale(" + (double)plotWidth / maxVel + "," + (double)plotWidth / maxY + ")\" >");
        out.println("<!-- P velocity");
        out.println(" -->");
        out.print("<polyline class=\"pwave\" points=\"");
        VelocityLayer prev = null;
        for (VelocityLayer vlay : vMod.layer) {
            if (prev == null || prev.getBotPVelocity() != vlay.getTopPVelocity()) {
                out.print((float)vlay.getTopPVelocity() + " " + (maxY - (double)((float)vlay.getTopDepth())) + " ");
            }
            out.print((float)vlay.getBotPVelocity() + " " + (maxY - (double)((float)vlay.getBotDepth())) + " ");
            prev = vlay;
        }
        out.println("\" />");
        out.println("<!-- S velocity");
        out.println(" -->");
        out.print("<polyline class=\"swave\" points=\"");
        prev = null;
        for (VelocityLayer vlay : vMod.layer) {
            if (prev == null || prev.getBotSVelocity() != vlay.getTopSVelocity()) {
                out.print((float)vlay.getTopSVelocity() + " " + (maxY - (double)((float)vlay.getTopDepth())) + " ");
            }
            out.print((float)vlay.getBotSVelocity() + " " + (maxY - (double)((float)vlay.getBotDepth())) + " ");
            prev = vlay;
        }
        out.println("\" />");
        out.println("</g>");
        out.println("</g>");
        out.println("</g>");
        out.println("</svg>");
        out.flush();
        this.closeWriter();
    }

    public void printSVGBeginning(PrintWriter out) {
        float pixelWidth = 72.0f * this.mapWidth;
        out.println("<svg version=\"1.1\" baseProfile=\"full\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 " + (pixelWidth + (float)this.plotOffset) + " " + (pixelWidth + (float)this.plotOffset) + "\">");
        SvgUtil.cmdLineArgAsComment(out, TauP_VelocityPlot.toolNameFromClass(this.getClass()), this.cmdLineArgs);
        out.println("<defs>");
        out.println("    <style type=\"text/css\"><![CDATA[");
        out.println("        polyline {");
        out.println("            vector-effect: non-scaling-stroke;");
        out.println("            stroke: black;");
        out.println("            fill: transparent;");
        out.println("        }");
        out.println("        polyline.swave {");
        out.println("            stroke: red;");
        out.println("        }");
        out.println("        polyline.pwave {");
        out.println("            stroke: blue;");
        out.println("        }");
        out.println("        line {");
        out.println("            vector-effect: non-scaling-stroke;");
        out.println("            stroke: black;");
        out.println("            fill: transparent;");
        out.println("        }");
        out.println("        .xtick {");
        out.println("            text-anchor: middle;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        .ytick {");
        out.println("            text-anchor: end;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        .phaselabel {");
        out.println("            text-anchor: end;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("    ]]></style>");
        out.println("</defs>");
        out.println("<g transform=\"translate(" + this.plotOffset + "," + this.plotOffset + ")\" >");
        out.println("<!-- draw axis and label distances.-->");
        out.println();
    }

    public void printCSV(PrintWriter out, VelocityModel vMod) {
        double maxY = vMod.maxRadius;
        VelocityLayer prev = null;
        out.println("Depth,P Velocity,S Velocity");
        for (VelocityLayer vLayer : vMod.getLayers()) {
            if (prev == null || prev.getBotPVelocity() != vLayer.getTopPVelocity() || prev.getBotSVelocity() != vLayer.getTopSVelocity()) {
                out.println((float)vLayer.getTopDepth() + "," + (float)vLayer.getTopPVelocity() + "," + (float)vLayer.getTopSVelocity());
            }
            out.println((float)vLayer.getBotDepth() + "," + (float)vLayer.getBotPVelocity() + "," + (float)vLayer.getBotSVelocity());
            prev = vLayer;
        }
        out.flush();
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = super.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_VelocityPlot.dashEquals("svg", args[i])) {
                this.setOutputFormat("svg");
                this.setOutFileExtension("svg");
                continue;
            }
            if (TauP_VelocityPlot.dashEquals("csv", args[i])) {
                this.setOutputFormat("csv");
                this.setOutFileExtension("csv");
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("nd", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "nd";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("tvel", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "tvel";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("mod", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = null;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("overlay", args[i])) {
                this.overlayModelName = args[i + 1];
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    @Override
    public void printUsage() {
        TauP_Tool.printStdUsageHead(this.getClass());
        System.out.println("-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n");
        System.out.println("-nd modelfile       -- \"named discontinuities\" velocity file");
        System.out.println("-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n");
        System.out.println("--svg               -- output as SVG");
        System.out.println("--csv               -- outputs a CSV ascii table");
        System.out.println("\n");
        TauP_Tool.printStdUsageTail();
    }
}

