/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Create;
import edu.sc.seis.TauP.TauP_VelocityPlot;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.IOException;
import java.io.PrintWriter;

public class TauP_SlownessPlot
extends TauP_VelocityPlot {
    public static final String DEFAULT_OUTFILE = "taup_slownessmodel";

    public TauP_SlownessPlot() {
        this.setOutFileBase(DEFAULT_OUTFILE);
    }

    @Override
    public void start() throws SlownessModelException, TauModelException, VelocityModelException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        if (this.getOutFileBase() == DEFAULT_OUTFILE) {
            this.setOutFileBase(vMod.modelName + "_slow");
        }
        TauP_Create taup_create = new TauP_Create();
        TauModel tMod = taup_create.createTauModel(vMod);
        if (this.getOutputFormat() == "svg") {
            this.printSVG(this.getWriter(), tMod.getSlownessModel());
        } else if (this.getOutputFormat() == "csv") {
            this.printCSV(this.getWriter(), tMod.getSlownessModel());
        } else {
            tMod.getSlownessModel().printGMT(this.getOutFile());
        }
    }

    public double calcMaxRP(SlownessModel sMod) {
        double maxRP = 0.0;
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(true)) {
            if (sLayer.getTopP() > maxRP) {
                maxRP = sLayer.getTopP();
            }
            if (!(sLayer.getBotP() > maxRP)) continue;
            maxRP = sLayer.getBotP();
        }
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(false)) {
            if (sLayer.getTopP() > maxRP) {
                maxRP = sLayer.getTopP();
            }
            if (!(sLayer.getBotP() > maxRP)) continue;
            maxRP = sLayer.getBotP();
        }
        return maxRP;
    }

    public void printSVG(PrintWriter out, SlownessModel sMod) {
        double maxRP = this.calcMaxRP(sMod);
        double minRP = 0.0;
        maxRP *= 1.05;
        int numXTicks = 5;
        double maxY = sMod.vMod.maxRadius;
        double minY = 0.0;
        int numYTicks = 10;
        float pixelWidth = 72.0f * this.mapWidth - (float)this.plotOffset;
        float margin = 40.0f;
        float plotWidth = pixelWidth - margin;
        String title = sMod.vMod.modelName;
        this.printSVGBeginning(out);
        SvgUtil.createXYAxes(out, minRP, maxRP, numXTicks, maxY, minY, numYTicks, pixelWidth, margin, title);
        out.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
        out.println("<g transform=\"scale(" + (double)plotWidth / maxRP + "," + (double)plotWidth / maxY + ")\" >");
        out.println("<!-- P velocity");
        out.println(" -->");
        out.print("<polyline class=\"pwave\" points=\"");
        SlownessLayer prev = null;
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(true)) {
            if (prev == null || prev.getBotP() != sLayer.getTopP()) {
                out.print((float)sLayer.getTopP() + " " + (maxY - (double)((float)sLayer.getTopDepth())) + " ");
            }
            out.print((float)sLayer.getBotP() + " " + (maxY - (double)((float)sLayer.getBotDepth())) + " ");
            prev = sLayer;
        }
        out.println("\" />");
        out.println("<!-- S velocity");
        out.println(" -->");
        out.print("<polyline class=\"swave\" points=\"");
        prev = null;
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(false)) {
            if (prev == null || prev.getBotP() != sLayer.getTopP()) {
                out.print((float)sLayer.getTopP() + " " + (maxY - (double)((float)sLayer.getTopDepth())) + " ");
            }
            out.print((float)sLayer.getBotP() + " " + (maxY - (double)((float)sLayer.getBotDepth())) + " ");
            prev = sLayer;
        }
        out.println("\" />");
        out.println("</g>");
        out.println("</g>");
        out.println("</g>");
        out.println("</svg>");
        out.flush();
        this.closeWriter();
    }

    public void printCSV(PrintWriter out, SlownessModel sMod) {
        double maxY = sMod.vMod.maxRadius;
        double maxRP = this.calcMaxRP(sMod);
        out.println("Slowness,Depth,Wavetype");
        for (boolean wavetype : new boolean[]{false, true}) {
            String wavename = wavetype ? "P" : "S";
            SlownessLayer prev = null;
            for (SlownessLayer sLayer : sMod.getAllSlownessLayers(wavetype)) {
                if (prev == null || prev.getBotP() != sLayer.getTopP()) {
                    out.println((float)sLayer.getTopP() + "," + (float)sLayer.getTopDepth() + "," + wavename);
                }
                out.println((float)sLayer.getBotP() + "," + (float)sLayer.getBotDepth() + "," + wavename);
                prev = sLayer;
            }
        }
        out.flush();
    }
}

