/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TauP_Tool;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class TauP_PhaseDescribe
extends TauP_Time {
    public boolean dump = false;

    @Override
    public void printStdUsage() {
        TauP_Tool.printStdUsageHead(this.getClass());
        Alert.info("-ph phase list        -- comma separated phase list\n-pf phasefile         -- file containing phases\n\n-mod[el] modelname    -- use velocity model \"modelname\" for calculations\n                         Default is iasp91.\n\n-h depth              -- source depth in km\n\n--stadepth depth      -- receiver depth in km\n\n--scat[ter] depth deg -- scattering depth and distance\n--dump                -- dump raw sample points\n\n");
    }

    @Override
    public void printUsage() {
        this.printStdUsage();
        TauP_PhaseDescribe.printStdUsageTail();
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = super.parseSourceModelCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        boolean cmdLineArgPhase = false;
        boolean cmdLineArgPhaseFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_PhaseDescribe.dashEquals("dump", args[i])) {
                this.dump = true;
                continue;
            }
            if (i < args.length - 1) {
                if (args[i].equalsIgnoreCase("-o")) {
                    this.outFileBase = args[i + 1];
                    ++i;
                    continue;
                }
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void start() throws IOException, TauModelException, TauPException {
        if (this.getSeismicPhases().size() > 0) {
            this.depthCorrect();
            this.printResult(this.getWriter());
        } else {
            this.getWriter().println("No phases to describe.");
        }
    }

    @Override
    public void printResult(PrintWriter writer) {
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (SeismicPhase phase : phaseList) {
            writer.println(phase.describe());
            if (this.dump) {
                double[] dist = phase.getDist();
                double[] time = phase.getTime();
                double[] rayParam = phase.getRayParams();
                writer.println("Dist (deg)  Time (s)  RayParam(rad/sec)");
                writer.println("----------------------------------------");
                for (int i = 0; i < dist.length; ++i) {
                    writer.println(dist[i] * 57.29577951308232 + "  " + time[i] + "  " + rayParam[i]);
                }
                writer.println("----------------------------------------");
            }
            writer.println("--------");
        }
    }
}

