/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.ToolRun;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class TauP_Create
extends TauP_Tool {
    String modelFilename = "iasp91.tvel";
    String overlayModelFilename = null;
    protected String velFileType = "tvel";
    String overlayVelFileType;
    String directory = ".";
    SlownessModel sMod;
    VelocityModel vMod;
    VelocityModel overlayVMod;
    TauModel tMod;
    protected boolean GUI = false;
    protected Properties toolProps;

    public TauP_Create() {
        Alert.setGUI(this.GUI);
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            this.toolProps = new Properties();
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setModelFilename(String modelFilename) {
        this.modelFilename = modelFilename;
    }

    public String getModelFilename() {
        return this.modelFilename;
    }

    public String getVelFileType() {
        return this.velFileType;
    }

    public void setVelFileType(String type) {
        this.velFileType = type;
    }

    public void setDEBUG(boolean DEBUG) {
        TauP_Create.DEBUG = DEBUG;
    }

    public boolean getDEBUG() {
        return DEBUG;
    }

    public void setVelocityModel(VelocityModel vMod) {
        this.vMod = vMod;
    }

    public void setMinDeltaP(float minDeltaP) {
        this.toolProps.setProperty("taup.create.minDeltaP", "" + minDeltaP);
    }

    public void setMaxDeltaP(float maxDeltaP) {
        this.toolProps.setProperty("taup.create.maxDeltaP", "" + maxDeltaP);
    }

    public void setMaxDepthInterval(float maxDepthInterval) {
        this.toolProps.setProperty("taup.create.maxDepthInterval", "" + maxDepthInterval);
    }

    public void setMaxRangeInterval(float maxRangeInterval) {
        this.toolProps.setProperty("taup.create.maxRangeInterval", "" + maxRangeInterval);
    }

    public void setMaxInterpError(float maxInterpError) {
        this.toolProps.setProperty("taup.create.maxInterpError", "" + maxInterpError);
    }

    public void setAllowInnerCoreS(boolean allowInnerCoreS) {
        this.toolProps.setProperty("taup.create.allowInnerCoreS", "" + allowInnerCoreS);
    }

    @Override
    public void printUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        System.out.println("Usage: " + className.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("\n   To specify the velocity model:");
        System.out.println("-nd modelfile       -- \"named discontinuities\" velocity file");
        System.out.println("-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n");
        System.out.println("--debug              -- enable debugging output\n--prop [propfile]    -- set configuration properties\n--verbose            -- enable verbose output\n--version            -- print the version\n--help               -- print this out, but you already know that!\n\n");
    }

    public static boolean dashEquals(String argName, String arg) {
        return TauP_Time.dashEquals(argName, arg);
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) {
        String[] args = ToolRun.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_Create.dashEquals("help", args[i])) {
                this.printUsage();
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                return noComprendoArgs;
            }
            if (TauP_Create.dashEquals("gui", args[i])) {
                this.GUI = true;
                continue;
            }
            if (i < args.length - 1 && (TauP_Create.dashEquals("prop", args[i]) || TauP_Create.dashEquals("p", args[i]))) {
                try {
                    this.toolProps.load(new BufferedInputStream(new FileInputStream(args[i + 1])));
                    ++i;
                }
                catch (IOException e) {
                    noComprendoArgs[numNoComprendoArgs++] = args[i + 1];
                }
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("nd", args[i])) {
                this.velFileType = "nd";
                this.parseFileName(args[i + 1]);
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("tvel", args[i])) {
                this.velFileType = "tvel";
                this.parseFileName(args[i + 1]);
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("overlayND", args[i])) {
                this.overlayVelFileType = "nd";
                this.overlayModelFilename = args[i + 1];
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("vplot", args[i])) {
                System.err.println("vplot is deprecated, please use: taup " + ToolRun.VPLOT);
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_Create.dashEquals("splot", args[i])) {
                System.err.println("splot is deprecated, please use: taup " + ToolRun.SPLOT);
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                ++i;
                continue;
            }
            if (args[i].startsWith("GB.")) {
                this.velFileType = "nd";
                this.parseFileName(args[i]);
                continue;
            }
            if (args[i].endsWith(".nd")) {
                this.velFileType = "nd";
                this.parseFileName(args[i]);
                continue;
            }
            if (args[i].endsWith(".tvel")) {
                this.velFileType = "tvel";
                this.parseFileName(args[i]);
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (this.modelFilename == null) {
            System.out.println("Velocity model not specified, use one of -nd or -tvel");
            this.printUsage();
            System.exit(1);
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.CREATE, args);
    }

    public void parseFileName(String modelFilename) {
        int j = modelFilename.lastIndexOf(System.getProperty("file.separator"));
        this.modelFilename = modelFilename.substring(j + 1);
        this.directory = j == -1 ? "." : modelFilename.substring(0, j);
    }

    public VelocityModel loadVMod() throws IOException, VelocityModelException {
        File f;
        String file_sep;
        block9: {
            file_sep = System.getProperty("file.separator");
            String filename = this.directory + file_sep + this.modelFilename;
            f = new File(filename);
            if (this.verbose) {
                System.out.println("filename =" + this.directory + file_sep + this.modelFilename);
            }
            try {
                this.vMod = VelocityModel.readVelocityFile(filename, this.velFileType);
            }
            catch (FileNotFoundException e) {
                if (!DEBUG) break block9;
                System.out.println("Unable to load from directory " + filename);
            }
        }
        if (this.vMod == null) {
            this.vMod = TauModelLoader.loadVelocityModel(this.modelFilename);
        }
        if (this.vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelFilename + ", tried internally and from file: " + f);
        }
        if (this.verbose) {
            System.out.println("Done reading velocity model.");
            System.out.println("Radius of model " + this.vMod.getModelName() + " is " + this.vMod.getRadiusOfEarth());
        }
        if (this.overlayModelFilename != null) {
            if (DEBUG) {
                System.out.println("orig model: " + this.vMod);
            }
            this.overlayVMod = VelocityModel.readVelocityFile(this.directory + file_sep + this.overlayModelFilename, this.overlayVelFileType);
            this.vMod = this.vMod.replaceLayers(this.overlayVMod.getLayers(), this.overlayVMod.getModelName(), true, true);
        }
        if (DEBUG) {
            System.out.println("velocity mode: " + this.vMod);
        }
        return this.vMod;
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    public TauModel createTauModel(VelocityModel vMod) throws VelocityModelException, SlownessModelException, TauModelException {
        if (vMod == null) {
            throw new IllegalArgumentException("vMod cannot be null");
        }
        if (!vMod.getSpherical()) {
            throw new SlownessModelException("Flat slowness model not yet implemented.");
        }
        SlownessModel.DEBUG = DEBUG;
        this.sMod = new SphericalSModel(vMod, Double.valueOf(this.toolProps.getProperty("taup.create.minDeltaP", "0.1")), Double.valueOf(this.toolProps.getProperty("taup.create.maxDeltaP", "11.0")), Double.valueOf(this.toolProps.getProperty("taup.create.maxDepthInterval", "115.0")), Double.valueOf(this.toolProps.getProperty("taup.create.maxRangeInterval", "2.5")) * Math.PI / 180.0, Double.valueOf(this.toolProps.getProperty("taup.create.maxInterpError", "0.05")), Boolean.valueOf(this.toolProps.getProperty("taup.create.allowInnerCoreS", "true")), 1.0E-16);
        if (this.verbose) {
            System.out.println("Parameters are:");
            System.out.println("taup.create.minDeltaP = " + this.sMod.getMinDeltaP() + " sec / radian");
            System.out.println("taup.create.maxDeltaP = " + this.sMod.getMaxDeltaP() + " sec / radian");
            System.out.println("taup.create.maxDepthInterval = " + this.sMod.getMaxDepthInterval() + " kilometers");
            System.out.println("taup.create.maxRangeInterval = " + this.sMod.getMaxRangeInterval() + " degrees");
            System.out.println("taup.create.maxInterpError = " + this.sMod.getMaxInterpError() + " seconds");
            System.out.println("taup.create.allowInnerCoreS = " + this.sMod.isAllowInnerCoreS());
            System.out.println("Slow model  " + this.sMod.getNumLayers(true) + " P layers," + this.sMod.getNumLayers(false) + " S layers");
        }
        if (DEBUG) {
            System.out.println(this.sMod);
        }
        TauModel.DEBUG = DEBUG;
        SlownessModel.DEBUG = DEBUG;
        return new TauModel(this.sMod);
    }

    @Override
    public void start() throws SlownessModelException, TauModelException, VelocityModelException, IOException {
        try {
            if (this.verbose) {
                System.out.println("TauP_Create starting...");
            }
            String file_sep = System.getProperty("file.separator");
            TauModel tMod = this.createTauModel(this.vMod);
            if (DEBUG) {
                System.out.println("Done calculating Tau branches.");
            }
            if (DEBUG) {
                tMod.print();
            }
            String outFile = this.directory.equals(".") ? this.directory + file_sep + this.vMod.getModelName() + ".taup" : this.vMod.getModelName() + ".taup";
            tMod.writeModel(outFile);
            if (this.verbose) {
                System.out.println("Done Saving " + outFile);
            }
        }
        catch (IOException e) {
            System.out.println("Tried to write!\n Caught IOException " + e.getMessage() + "\nDo you have write permission in this directory?");
            throw e;
        }
        finally {
            if (this.verbose) {
                System.out.println("Done!");
            }
        }
    }

    @Override
    public void init() throws TauPException {
        try {
            this.loadVMod();
        }
        catch (VelocityModelException e) {
            throw new TauPException("Problem with velocity model", e);
        }
        catch (IOException e) {
            throw new TauPException("Problem loading velocity model", e);
        }
    }

    @Override
    public void destroy() throws TauPException {
    }
}

