/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Assert;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.ToolRun;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class TauBranch
implements Serializable,
Cloneable {
    public transient boolean DEBUG = ToolRun.DEBUG;
    protected boolean isPWave;
    private double topDepth;
    private double botDepth;
    private double maxRayParam;
    private double minTurnRayParam;
    private double minRayParam;
    protected double[] dist;
    protected double[] time;
    protected double[] tau;

    public TauBranch(boolean isPWave, double topDepth, double botDepth, double maxRayParam, double minTurnRayParam, double minRayParam, double[] dist, double[] time, double[] tau) {
        this.isPWave = isPWave;
        this.topDepth = topDepth;
        this.botDepth = botDepth;
        this.maxRayParam = maxRayParam;
        this.minTurnRayParam = minTurnRayParam;
        this.minRayParam = minRayParam;
        this.dist = dist;
        this.time = time;
        this.tau = tau;
    }

    public TauBranch(double topDepth, double botDepth, boolean isPWave) {
        this.topDepth = topDepth;
        this.botDepth = botDepth;
        this.isPWave = isPWave;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBotDepth() {
        return this.botDepth;
    }

    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    public double getMinTurnRayParam() {
        return this.minTurnRayParam;
    }

    public double getMinRayParam() {
        return this.minRayParam;
    }

    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    public double getDist(int i) {
        return this.dist[i];
    }

    public double[] getTime() {
        return (double[])this.time.clone();
    }

    public double getTime(int i) {
        return this.time[i];
    }

    public double[] getTau() {
        return (double[])this.tau.clone();
    }

    public double getTau(int i) {
        return this.tau[i];
    }

    public void createBranch(SlownessModel sMod, double[] rayParams) throws NoSuchLayerException, SlownessModelException, TauModelException {
        int topLayerNum = sMod.layerNumberBelow(this.getTopDepth(), this.isPWave);
        int botLayerNum = sMod.layerNumberAbove(this.getBotDepth(), this.isPWave);
        SlownessLayer topSLayer = sMod.getSlownessLayer(topLayerNum, this.isPWave);
        SlownessLayer botSLayer = sMod.getSlownessLayer(botLayerNum, this.isPWave);
        if (topSLayer.getTopDepth() != this.getTopDepth() || botSLayer.getBotDepth() != this.getBotDepth()) {
            if (topSLayer.getTopDepth() != this.getTopDepth() && Math.abs(topSLayer.getTopDepth() - this.getTopDepth()) < 1.0E-6) {
                System.err.println("Changing topDepth: \ntopDepth: " + this.getTopDepth() + " " + topSLayer.getTopDepth() + "\nbotDepth: " + this.getBotDepth() + " " + botSLayer.getBotDepth());
                this.topDepth = topSLayer.getTopDepth();
            } else if (botSLayer.getBotDepth() != this.getBotDepth() && Math.abs(botSLayer.getBotDepth() - this.getBotDepth()) < 1.0E-6) {
                System.err.println("Changing botDepth: \ntopDepth: " + this.getTopDepth() + " " + topSLayer.getTopDepth() + "\nbotDepth: " + this.getBotDepth() + " " + botSLayer.getBotDepth());
                this.botDepth = botSLayer.getBotDepth();
            } else {
                throw new TauModelException("createBranch: TauBranch not compatible with slowness sampling for " + "SP".charAt(this.isPWave ? 1 : 0) + ":\ntopDepth: " + this.getTopDepth() + " " + topSLayer.getTopDepth() + "\nbotDepth: " + this.getBotDepth() + " " + botSLayer.getBotDepth());
            }
        }
        this.maxRayParam = sMod.getSlownessLayer(topLayerNum, this.isPWave).getTopP();
        for (int i = topLayerNum; i < botLayerNum; ++i) {
            SlownessLayer sl = sMod.getSlownessLayer(i, this.isPWave);
            this.maxRayParam = Math.max(this.maxRayParam, sl.getTopP());
            this.maxRayParam = Math.max(this.maxRayParam, sl.getBotP());
        }
        this.minTurnRayParam = sMod.getMinTurnRayParam(this.getBotDepth(), this.isPWave);
        this.minRayParam = sMod.getMinRayParam(this.getBotDepth(), this.isPWave);
        this.tau = new double[rayParams.length];
        this.dist = new double[rayParams.length];
        this.time = new double[rayParams.length];
        for (int rayNum = 0; rayNum < rayParams.length; ++rayNum) {
            double p = rayParams[rayNum];
            TimeDist timeDist = this.calcTimeDist(sMod, topLayerNum, botLayerNum, p);
            this.dist[rayNum] = timeDist.getDistRadian();
            this.time[rayNum] = timeDist.getTime();
            this.tau[rayNum] = this.time[rayNum] - p * this.dist[rayNum];
        }
    }

    public TimeDist calcTimeDist(SlownessModel sMod, int topLayerNum, int botLayerNum, double p) throws NoSuchLayerException, SlownessModelException {
        return this.calcTimeDist(sMod, topLayerNum, botLayerNum, p, false);
    }

    public TimeDist calcTimeDist(SlownessModel sMod, int topLayerNum, int botLayerNum, double p, boolean allowTurnInLayer) throws NoSuchLayerException, SlownessModelException {
        TimeDist timeDist = new TimeDist(p);
        if (p <= this.getMaxRayParam()) {
            int layerNum = topLayerNum;
            SlownessLayer layer = sMod.getSlownessLayer(layerNum, this.isPWave);
            while (layerNum <= botLayerNum && p <= layer.getTopP() && p <= layer.getBotP()) {
                timeDist = timeDist.add(sMod.layerTimeDist(p, layerNum, this.isPWave));
                if (++layerNum > botLayerNum) continue;
                layer = sMod.getSlownessLayer(layerNum, this.isPWave);
            }
            if ((layer.getTopP() - p) * (p - layer.getBotP()) > 0.0) {
                if (allowTurnInLayer) {
                    timeDist = timeDist.add(sMod.layerTimeDistAllowTurn(p, layerNum, this.isPWave, true));
                } else {
                    throw new SlownessModelException("Ray turns in the middle of this layer. layerNum = " + layerNum + " sphericalRayParam " + p + " layer =" + layer);
                }
            }
        }
        return timeDist;
    }

    protected void insert(double rayParam, SlownessModel sMod, int index) throws NoSuchLayerException, SlownessModelException, TauModelException {
        int topLayerNum = sMod.layerNumberBelow(this.getTopDepth(), this.isPWave);
        int botLayerNum = sMod.layerNumberAbove(this.getBotDepth(), this.isPWave);
        SlownessLayer topSLayer = sMod.getSlownessLayer(topLayerNum, this.isPWave);
        SlownessLayer botSLayer = sMod.getSlownessLayer(botLayerNum, this.isPWave);
        if (topSLayer.getTopDepth() != this.getTopDepth() || botSLayer.getBotDepth() != this.getBotDepth()) {
            throw new TauModelException("insert: TauBranch depths not compatible with slowness sampling:\ntopDepth: " + this.getTopDepth() + " " + topSLayer.getTopDepth() + "\nbotDepth: " + this.getBotDepth() + " " + botSLayer.getBotDepth());
        }
        TimeDist td = new TimeDist(rayParam, 0.0, 0.0);
        if (topSLayer.getBotP() >= rayParam && topSLayer.getTopP() >= rayParam) {
            for (int i = topLayerNum; i <= botLayerNum && !(sMod.getSlownessLayer(i, this.isPWave).getBotP() < rayParam); ++i) {
                TimeDist temptd = sMod.layerTimeDist(rayParam, i, this.isPWave);
                td = td.add(temptd);
            }
        }
        this.shiftBranch(index);
        this.dist[index] = td.getDistRadian();
        this.time[index] = td.getTime();
        this.tau[index] = td.getTime() - rayParam * td.getDistRadian();
    }

    protected TauBranch difference(TauBranch topBranch, int indexP, int indexS, SlownessModel sMod, double[] rayParams) throws NoSuchLayerException, SlownessModelException, TauModelException {
        if (topBranch.getTopDepth() != this.getTopDepth() || topBranch.getBotDepth() > this.getBotDepth()) {
            if (topBranch.getTopDepth() != this.getTopDepth() && Math.abs(topBranch.getTopDepth() - this.getTopDepth()) < 1.0E-6) {
                this.topDepth = topBranch.getTopDepth();
            } else {
                throw new TauModelException("difference: TauBranch not compatible with slowness sampling:\ntopDepth: " + this.getTopDepth() + " " + topBranch.getTopDepth() + "\nbotDepth: " + this.getBotDepth() + " " + topBranch.getBotDepth());
            }
        }
        if (topBranch.isPWave != this.isPWave) {
            throw new TauModelException("Can't difference branches: topBranch.topDepth=" + topBranch.getTopDepth() + " topDepth=" + this.getTopDepth() + " topBranch.botDepth=" + topBranch.getBotDepth() + " botDepth=" + this.getBotDepth() + " waveTypes:" + topBranch.isPWave + " " + this.isPWave);
        }
        int topLayerNum = sMod.layerNumberBelow(topBranch.getBotDepth(), this.isPWave);
        int botLayerNum = sMod.layerNumberBelow(this.getBotDepth(), this.isPWave);
        SlownessLayer topSLayer = sMod.getSlownessLayer(topLayerNum, this.isPWave);
        SlownessLayer botSLayer = sMod.getSlownessLayer(botLayerNum, this.isPWave);
        if (botSLayer.getTopDepth() == this.getBotDepth() && botSLayer.getBotDepth() > this.getBotDepth()) {
            botSLayer = sMod.getSlownessLayer(--botLayerNum, this.isPWave);
        }
        if (topSLayer.getTopDepth() != topBranch.getBotDepth() || botSLayer.getBotDepth() != this.getBotDepth()) {
            throw new TauModelException("difference: TauBranch not compatible with slowness sampling:\ntopDepth: " + topBranch.getBotDepth() + " " + topSLayer.getTopDepth() + "\nbotDepth: " + this.getBotDepth() + " " + botSLayer.getBotDepth() + "\n" + topSLayer + "\n" + botSLayer);
        }
        SlownessLayer sLayer = sMod.getSlownessLayer(sMod.layerNumberBelow(topBranch.getBotDepth(), true), true);
        if (indexP >= 0 && sLayer.getTopP() != rayParams[indexP]) {
            throw new TauModelException("difference: P wave index doesn't match top layer.\n " + sMod.layerNumberBelow(topBranch.getBotDepth(), true) + "\n" + rayParams[indexP - 1] + "\n" + rayParams[indexP] + "\n" + rayParams[indexP + 1] + "\nP=" + sLayer + "\nS=" + sMod.getSlownessLayer(sMod.layerNumberBelow(topBranch.getBotDepth(), false), false));
        }
        sLayer = sMod.getSlownessLayer(sMod.layerNumberBelow(topBranch.getBotDepth(), false), false);
        if (indexS >= 0 && sLayer.getTopP() != rayParams[indexS]) {
            throw new TauModelException("difference: S wave index doesn't match top layer. " + sMod.layerNumberBelow(topBranch.getBotDepth(), false) + " " + rayParams[indexS - 1] + " " + rayParams[indexS] + " " + rayParams[indexS + 1] + "\n" + sLayer);
        }
        sLayer = null;
        TauBranch botBranch = new TauBranch(topBranch.getBotDepth(), this.getBotDepth(), this.isPWave);
        botBranch.maxRayParam = topBranch.getMinRayParam();
        botBranch.minTurnRayParam = this.getMinTurnRayParam();
        botBranch.minRayParam = this.getMinRayParam();
        double PRayParam = -1.0;
        double SRayParam = -1.0;
        TimeDist timeDistP = new TimeDist();
        TimeDist timeDistS = new TimeDist();
        int arrayLength = this.dist.length;
        if (indexP != -1) {
            ++arrayLength;
            PRayParam = rayParams[indexP];
            timeDistP = botBranch.calcTimeDist(sMod, topLayerNum, botLayerNum, PRayParam);
        }
        if (indexS != -1 && indexS != indexP) {
            ++arrayLength;
            SRayParam = rayParams[indexS];
            timeDistS = botBranch.calcTimeDist(sMod, topLayerNum, botLayerNum, SRayParam);
        } else {
            indexS = -1;
        }
        botBranch.dist = new double[arrayLength];
        botBranch.time = new double[arrayLength];
        botBranch.tau = new double[arrayLength];
        if (indexP == -1) {
            for (int i = 0; i < this.dist.length; ++i) {
                botBranch.dist[i] = this.dist[i] - topBranch.dist[i];
                botBranch.time[i] = this.time[i] - topBranch.time[i];
                botBranch.tau[i] = this.tau[i] - topBranch.tau[i];
            }
        } else if (indexS == -1) {
            int i;
            for (i = 0; i < indexP; ++i) {
                botBranch.dist[i] = this.dist[i] - topBranch.dist[i];
                botBranch.time[i] = this.time[i] - topBranch.time[i];
                botBranch.tau[i] = this.tau[i] - topBranch.tau[i];
            }
            botBranch.dist[indexP] = timeDistP.getDistRadian();
            botBranch.time[indexP] = timeDistP.getTime();
            botBranch.tau[indexP] = timeDistP.getTime() - PRayParam * timeDistP.getDistRadian();
            for (i = indexP + 1; i < topBranch.dist.length; ++i) {
                botBranch.dist[i] = this.dist[i - 1] - topBranch.dist[i];
                botBranch.time[i] = this.time[i - 1] - topBranch.time[i];
                botBranch.tau[i] = this.tau[i - 1] - topBranch.tau[i];
            }
        } else {
            int i;
            for (i = 0; i < indexS; ++i) {
                botBranch.dist[i] = this.dist[i] - topBranch.dist[i];
                botBranch.time[i] = this.time[i] - topBranch.time[i];
                botBranch.tau[i] = this.tau[i] - topBranch.tau[i];
            }
            botBranch.dist[indexS] = timeDistS.getDistRadian();
            botBranch.time[indexS] = timeDistS.getTime();
            botBranch.tau[indexS] = timeDistS.getTime() - SRayParam * timeDistS.getDistRadian();
            for (i = indexS + 1; i < indexP; ++i) {
                botBranch.dist[i] = this.dist[i - 1] - topBranch.dist[i];
                botBranch.time[i] = this.time[i - 1] - topBranch.time[i];
                botBranch.tau[i] = this.tau[i - 1] - topBranch.tau[i];
            }
            botBranch.dist[indexP] = timeDistP.getDistRadian();
            botBranch.time[indexP] = timeDistP.getTime();
            botBranch.tau[indexP] = timeDistP.getTime() - PRayParam * timeDistP.getDistRadian();
            for (i = indexP + 1; i < topBranch.dist.length; ++i) {
                botBranch.dist[i] = this.dist[i - 2] - topBranch.dist[i];
                botBranch.time[i] = this.time[i - 2] - topBranch.time[i];
                botBranch.tau[i] = this.tau[i - 2] - topBranch.tau[i];
            }
        }
        return botBranch;
    }

    public void shiftBranch(int index) {
        double[] newDist = new double[this.dist.length + 1];
        System.arraycopy(this.dist, 0, newDist, 0, index);
        newDist[index] = 0.0;
        System.arraycopy(this.dist, index, newDist, index + 1, this.dist.length - index);
        this.dist = newDist;
        double[] newTime = new double[this.time.length + 1];
        System.arraycopy(this.time, 0, newTime, 0, index);
        newTime[index] = 0.0;
        System.arraycopy(this.time, index, newTime, index + 1, this.time.length - index);
        this.time = newTime;
        double[] newTau = new double[this.tau.length + 1];
        System.arraycopy(this.tau, 0, newTau, 0, index);
        newTau[index] = 0.0;
        System.arraycopy(this.tau, index, newTau, index + 1, this.tau.length - index);
        this.tau = newTau;
    }

    public TimeDist[] path(double rayParam, boolean downgoing, SlownessModel sMod) throws SlownessModelException {
        int botLayerNum;
        int topLayerNum;
        if (rayParam > this.getMaxRayParam()) {
            return null;
        }
        Assert.isTrue(rayParam >= 0.0, "ray parameter must not be negative.");
        try {
            topLayerNum = sMod.layerNumberBelow(this.getTopDepth(), this.isPWave);
            botLayerNum = sMod.layerNumberAbove(this.getBotDepth(), this.isPWave);
        }
        catch (NoSuchLayerException e) {
            throw new SlownessModelException("Caught NoSuchLayerException. This likely means theSlownessModel and TauModel are out of sync. " + e.getMessage());
        }
        TimeDist[] thePath = new TimeDist[botLayerNum - topLayerNum + 1];
        int pathIndex = 0;
        SlownessLayer sLayer = sMod.getSlownessLayer(topLayerNum, this.isPWave);
        if (sLayer.getTopDepth() != this.getTopDepth()) {
            throw new SlownessModelException("Branch and Slowness model are not compatible! " + sLayer.getTopDepth() + " != " + this.getTopDepth() + "=topDepth");
        }
        sLayer = sMod.getSlownessLayer(botLayerNum, this.isPWave);
        if (sLayer.getBotDepth() != this.getBotDepth()) {
            throw new SlownessModelException("Branch and Slowness model are not compatible! " + sLayer.getBotDepth() + " != " + this.getBotDepth() + "=botDepth");
        }
        if (downgoing) {
            int sLayerNum = topLayerNum;
            sLayer = sMod.getSlownessLayer(sLayerNum, this.isPWave);
            while (sLayer.getBotP() >= rayParam && sLayerNum <= botLayerNum) {
                if (!sLayer.isZeroThickness()) {
                    thePath[pathIndex] = sMod.layerTimeDist(rayParam, sLayerNum, this.isPWave, downgoing);
                    ++pathIndex;
                }
                if (++sLayerNum > botLayerNum) continue;
                sLayer = sMod.getSlownessLayer(sLayerNum, this.isPWave);
            }
            if (sLayerNum <= botLayerNum && !sLayer.isZeroThickness()) {
                double turnDepth = sLayer.bullenDepthFor(rayParam, sMod.getRadiusOfEarth());
                SlownessLayer turnSLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), rayParam, turnDepth);
                thePath[pathIndex] = turnSLayer.bullenRadialSlowness(rayParam, sMod.getRadiusOfEarth(), downgoing);
                ++pathIndex;
            }
        } else {
            int sLayerNum = botLayerNum;
            sLayer = sMod.getSlownessLayer(sLayerNum, this.isPWave);
            while ((sLayer.getTopP() <= rayParam || sLayer.isZeroThickness()) && sLayerNum > topLayerNum) {
                sLayer = sMod.getSlownessLayer(--sLayerNum, this.isPWave);
            }
            if (sLayer.getBotP() < rayParam) {
                double turnDepth = sLayer.bullenDepthFor(rayParam, sMod.getRadiusOfEarth());
                SlownessLayer turnSLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), rayParam, turnDepth);
                thePath[pathIndex] = turnSLayer.bullenRadialSlowness(rayParam, sMod.getRadiusOfEarth(), downgoing);
                ++pathIndex;
                if (--sLayerNum >= topLayerNum) {
                    sLayer = sMod.getSlownessLayer(sLayerNum, this.isPWave);
                }
            }
            while (sLayerNum >= topLayerNum) {
                if (!sLayer.isZeroThickness()) {
                    thePath[pathIndex] = sMod.layerTimeDist(rayParam, sLayerNum, this.isPWave, downgoing);
                    ++pathIndex;
                }
                if (--sLayerNum < topLayerNum) continue;
                sLayer = sMod.getSlownessLayer(sLayerNum, this.isPWave);
            }
        }
        TimeDist[] tempPath = new TimeDist[pathIndex];
        System.arraycopy(thePath, 0, tempPath, 0, pathIndex);
        return tempPath;
    }

    public void writeToStream(DataOutputStream dos) throws IOException {
        int i;
        dos.writeInt(this.getClass().getName().length());
        dos.writeBytes(this.getClass().getName());
        dos.writeDouble(this.getTopDepth());
        dos.writeDouble(this.getBotDepth());
        dos.writeDouble(this.getMaxRayParam());
        dos.writeDouble(this.getMinRayParam());
        dos.writeDouble(this.getMinTurnRayParam());
        dos.writeInt(this.dist.length);
        for (i = 0; i < this.dist.length; ++i) {
            dos.writeDouble(this.dist[i]);
        }
        dos.writeInt(this.time.length);
        for (i = 0; i < this.time.length; ++i) {
            dos.writeDouble(this.time[i]);
        }
        dos.writeInt(this.tau.length);
        for (i = 0; i < this.tau.length; ++i) {
            dos.writeDouble(this.tau[i]);
        }
    }

    public static TauBranch readFromStream(DataInputStream dis) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, TauPException {
        int i;
        byte[] classString = new byte[dis.readInt()];
        dis.read(classString);
        Class<?> tBranchClass = Class.forName(new String(classString));
        TauBranch tBranch = null;
        try {
            tBranch = (TauBranch)tBranchClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new TauPException("Problem creating TauBranch", e);
        }
        catch (NoSuchMethodException e) {
            throw new TauPException("Problem creating TauBranch", e);
        }
        tBranch.topDepth = dis.readDouble();
        tBranch.botDepth = dis.readDouble();
        tBranch.maxRayParam = dis.readDouble();
        tBranch.minRayParam = dis.readDouble();
        tBranch.minTurnRayParam = dis.readDouble();
        int length = dis.readInt();
        tBranch.dist = new double[length];
        for (i = 0; i < tBranch.dist.length; ++i) {
            tBranch.dist[i] = dis.readDouble();
        }
        length = dis.readInt();
        tBranch.time = new double[length];
        for (i = 0; i < tBranch.time.length; ++i) {
            tBranch.time[i] = dis.readDouble();
        }
        length = dis.readInt();
        tBranch.tau = new double[length];
        for (i = 0; i < tBranch.tau.length; ++i) {
            tBranch.tau[i] = dis.readDouble();
        }
        return tBranch;
    }

    public TauBranch clone() {
        return new TauBranch(this.isPWave, this.topDepth, this.botDepth, this.maxRayParam, this.minTurnRayParam, this.minRayParam, this.dist, this.time, this.tau);
    }

    public String toString() {
        String desc = "Tau Branch\n";
        desc = desc + " topDepth = " + this.getTopDepth() + "\n";
        desc = desc + " botDepth = " + this.getBotDepth() + "\n";
        desc = desc + " maxRayParam=" + this.getMaxRayParam() + " minTurnRayParam=" + this.getMinTurnRayParam();
        desc = desc + " minRayParam=" + this.getMinRayParam() + "\n";
        return desc;
    }
}

