/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.PlotTicks;
import java.io.PrintWriter;
import java.util.ArrayList;

public class SvgUtil {
    public static void cmdLineArgAsComment(PrintWriter out, String cmd, String[] args) {
        out.println("<!-- ");
        out.println("   created with TauP " + BuildVersion.getVersion());
        out.print("    " + cmd + " ");
        for (String s : args) {
            if (s.startsWith("--")) {
                s = "&#45;&#45;" + s.substring(2);
            }
            out.print(s + " ");
        }
        out.println();
        out.println("-->");
    }

    public static void createXYAxes(PrintWriter out, double minX, double maxX, int numXTicks, double minY, double maxY, int numYTicks, float pixelWidth, float margin, String title) {
        String tick_text;
        double tick_pixel;
        float plotWidth = pixelWidth - margin;
        float tick_length = 10.0f;
        float text_height = 12.0f;
        ArrayList<Double> xTicks = PlotTicks.getTicks(minX, maxX, numXTicks);
        ArrayList<Double> yTicks = PlotTicks.getTicks(minY, maxY, numYTicks);
        out.println("<text x=\"" + (pixelWidth / 2.0f - margin) + "\" y=\"" + -1.0f * margin + "\">" + title + "</text>");
        out.println("<g> <!-- y axis -->");
        out.println("<line x1=\"0\" y1=\"0\" x2=\"0\" y2=\"" + plotWidth + "\" />");
        for (double tick : yTicks) {
            tick_pixel = maxY > minY ? tick / maxY * (double)plotWidth : (minY - tick) / minY * (double)plotWidth;
            tick_text = "" + tick;
            out.println("<text class=\"ytick\" x=\"" + (-1.0f * tick_length - 2.0f) + "\" y=\"" + ((double)plotWidth - tick_pixel) + "\">" + tick_text + "</text>");
            out.println("<line x1=\"0\" y1=\"" + ((double)plotWidth - tick_pixel) + "\" x2=\"-" + tick_length + "\" y2=\"" + ((double)plotWidth - tick_pixel) + "\" />");
        }
        out.println("</g> <!-- y axis -->");
        out.println("<g> <!-- x axis -->");
        out.println("<line x1=\"0\" y1=\"" + plotWidth + "\" x2=\"" + pixelWidth + "\" y2=\"" + plotWidth + "\" />");
        for (double tick : xTicks) {
            tick_pixel = maxX > minX ? tick / maxX * (double)plotWidth : (minX - tick) / minX * (double)plotWidth;
            tick_text = "" + tick;
            out.println("<text class=\"xtick\" x=\"" + tick_pixel + "\" y=\"" + (text_height + tick_length + plotWidth) + "\">" + tick_text + "</text>");
            out.println("<line x1=\"" + tick_pixel + "\" y1=\"" + plotWidth + "\" x2=\"" + tick_pixel + "\" y2=\"" + (plotWidth + tick_length) + "\" />");
        }
        out.println("</g> <!-- x axis -->");
    }
}

