/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Create;
import edu.sc.seis.TauP.VelocityModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class StdModelGenerator {
    public static final void main(String[] args) throws IOException, TauPException {
        File inDir = new File(args[0]);
        File outDir = new File(args[1]);
        StdModelGenerator.createStandardModels(inDir, outDir);
    }

    public static final void createStandardModels(File inDir, File outDir) throws IOException, TauPException {
        TauModel tMod;
        VelocityModel vMod;
        ArrayList<String> tvelModelNames = new ArrayList<String>();
        tvelModelNames.add("iasp91");
        tvelModelNames.add("ak135");
        ArrayList<String> ndModelNames = new ArrayList<String>();
        ndModelNames.add("prem");
        ndModelNames.add("ak135fcont");
        ndModelNames.add("ak135favg");
        TauP_Create taupCreate = new TauP_Create();
        taupCreate.setDirectory(inDir.getPath());
        taupCreate.setVelFileType("tvel");
        for (String modelName : tvelModelNames) {
            taupCreate.setModelFilename(modelName);
            vMod = taupCreate.loadVMod();
            tMod = taupCreate.createTauModel(vMod);
            tMod.writeModel(new File(outDir, modelName + ".taup").getPath());
        }
        taupCreate.setVelFileType("nd");
        for (String modelName : ndModelNames) {
            taupCreate.setModelFilename(modelName);
            vMod = taupCreate.loadVMod();
            tMod = taupCreate.createTauModel(vMod);
            tMod.writeModel(new File(outDir, modelName + ".taup").getPath());
        }
        taupCreate.setVelFileType("tvel");
        taupCreate.setMinDeltaP(0.5f);
        taupCreate.setMaxDeltaP(50.0f);
        taupCreate.setMaxDepthInterval(915.0f);
        taupCreate.setMaxRangeInterval(10.0f);
        taupCreate.setMaxInterpError(1.0f);
        taupCreate.setAllowInnerCoreS(false);
        taupCreate.setModelFilename("iasp91");
        VelocityModel vMod2 = taupCreate.loadVMod();
        vMod2.setModelName("qdt");
        TauModel tMod2 = taupCreate.createTauModel(vMod2);
        tMod2.writeModel(new File(outDir, "qdt.taup").getPath());
    }
}

