/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import java.util.ArrayList;
import java.util.List;

public class SeismicPhaseSegment {
    TauModel tMod;
    int startBranch;
    int endBranch;
    boolean isPWave;
    PhaseInteraction endAction;
    PhaseInteraction prevEndAction = null;
    boolean isDownGoing;
    boolean isFlat = false;
    String legName;

    public SeismicPhaseSegment(TauModel tMod, int startBranch, int endBranch, boolean isPWave, PhaseInteraction endAction, boolean isDownGoing, String legName) {
        this.tMod = tMod;
        this.startBranch = startBranch;
        this.endBranch = endBranch;
        this.isPWave = isPWave;
        this.endAction = endAction;
        this.isDownGoing = isDownGoing;
        this.legName = legName;
    }

    public boolean endsAtTop() throws TauModelException {
        switch (this.endAction) {
            case END: 
            case HEAD: 
            case TRANSUP: 
            case REFLECT_UNDERSIDE: 
            case REFLECT_UNDERSIDE_CRITICAL: {
                return true;
            }
            case TURN: 
            case DIFFRACT: 
            case END_DOWN: 
            case TRANSDOWN: 
            case REFLECT_TOPSIDE: 
            case REFLECT_TOPSIDE_CRITICAL: {
                return false;
            }
            case START: {
                return !this.isDownGoing;
            }
        }
        throw new TauModelException("endAction should never be FAIL or default in SeismicPhaseSegment");
    }

    public static String endActionToString(PhaseInteraction endAction) {
        String action;
        switch (endAction) {
            case START: {
                action = "start";
                break;
            }
            case TURN: {
                action = "turn";
                break;
            }
            case REFLECT_UNDERSIDE: {
                action = "reflect underside";
                break;
            }
            case END_DOWN: {
                action = "end downward";
                break;
            }
            case REFLECT_UNDERSIDE_CRITICAL: {
                action = "critical reflect underside";
                break;
            }
            case REFLECT_TOPSIDE: {
                action = "reflect topside";
                break;
            }
            case REFLECT_TOPSIDE_CRITICAL: {
                action = "critical reflect topside";
                break;
            }
            case TRANSUP: {
                action = "transmit up";
                break;
            }
            case TRANSDOWN: {
                action = "transmit down";
                break;
            }
            case DIFFRACT: {
                action = "diffract";
                break;
            }
            case HEAD: {
                action = "head wave";
                break;
            }
            case SCATTER: {
                action = "scatter";
                break;
            }
            case SCATTER_DOWN: {
                action = "down scatter";
                break;
            }
            case BACKSCATTER: {
                action = "backscatter";
                break;
            }
            case BACKSCATTER_DOWN: {
                action = "down backscatter";
                break;
            }
            case END: {
                action = "end";
                break;
            }
            case FAIL: {
                action = "fail";
                break;
            }
            default: {
                action = "unknown";
            }
        }
        return action;
    }

    public String describeBranchRange(int startBranch, int endBranch) {
        String out = "";
        out = startBranch < this.tMod.getMohoBranch() && endBranch < this.tMod.getMohoBranch() ? "crust" : (startBranch < this.tMod.getCmbBranch() && endBranch < this.tMod.getCmbBranch() ? (startBranch < this.tMod.getMohoBranch() && endBranch >= this.tMod.getMohoBranch() ? "crust/mantle" : (startBranch >= this.tMod.getMohoBranch() && endBranch < this.tMod.getMohoBranch() ? "crust/mantle" : "mantle")) : (startBranch <= this.tMod.getIocbBranch() && endBranch <= this.tMod.getIocbBranch() ? "outer core" : "inner core"));
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String depthRange;
        String branchRange;
        String isPString;
        String desc = "";
        String upDown = this.isFlat ? "flat" : (this.isDownGoing ? "down" : "up  ");
        String action = SeismicPhaseSegment.endActionToString(this.endAction);
        String string = isPString = this.isPWave ? "P" : "S";
        if (!(this.isPWave || this.startBranch != this.tMod.getCmbBranch() && this.endBranch != this.tMod.getCmbBranch())) {
            isPString = "P";
        } else if (this.prevEndAction == PhaseInteraction.KMPS) {
            isPString = "surface wave";
        }
        String string2 = branchRange = this.startBranch == this.endBranch ? " layer " + this.startBranch : " layer " + this.startBranch + " to " + this.endBranch;
        if (this.isFlat) {
            if (this.prevEndAction == null) {
                depthRange = " PrevAction is NULL ";
            } else if (this.prevEndAction == PhaseInteraction.DIFFRACT) {
                depthRange = " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() + " (DIFF)";
            } else if (this.prevEndAction == PhaseInteraction.HEAD) {
                depthRange = " at " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth() + " (HEAD)";
            } else {
                if (this.prevEndAction != PhaseInteraction.KMPS) throw new RuntimeException("isFlat but prev not HEAD or DIFFRACT: " + SeismicPhaseSegment.endActionToString(this.prevEndAction));
                depthRange = " at surface (KMPS)";
            }
        } else {
            depthRange = this.isDownGoing ? this.tMod.getTauBranch(this.startBranch, this.isPWave).getTopDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getBotDepth() : this.tMod.getTauBranch(this.startBranch, this.isPWave).getBotDepth() + " to " + this.tMod.getTauBranch(this.endBranch, this.isPWave).getTopDepth();
        }
        if (this.legName.contentEquals("END")) return desc + "END";
        return desc + this.legName + " going " + upDown + " as a " + isPString + " in the " + this.describeBranchRange(this.startBranch, this.endBranch) + "," + branchRange + ", depths " + depthRange + ", then " + action;
    }

    public List<TimeDist> calcPierceTimeDist(Arrival currArrival) {
        double branchDist = 0.0;
        double branchTime = 0.0;
        double prevBranchTime = 0.0;
        ArrayList<TimeDist> pierce = new ArrayList<TimeDist>();
        for (int i = this.startBranch; i <= this.endBranch; ++i) {
        }
        return pierce;
    }
}

