/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.LegPuller;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.ScatterArrivalFailException;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.ToolRun;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SeismicPhaseFactory {
    boolean DEBUG;
    String name;
    double sourceDepth;
    double receiverDepth;
    TauModel tMod;
    ArrayList<String> legs;
    String puristName;
    int upgoingRecBranch;
    int downgoingRecBranch;
    double nextLegDepth = 0.0;
    boolean isLegDepth;
    boolean isNextLegDepth = false;
    PhaseInteraction prevEndAction = PhaseInteraction.START;
    double[] dist;
    double[] time;
    double[] rayParams;
    protected double minRayParam;
    protected double maxRayParam;
    protected int maxRayParamIndex = -1;
    protected int minRayParamIndex = -1;
    protected double minDistance = 0.0;
    protected double maxDistance = Double.MAX_VALUE;
    protected transient int currBranch;
    protected List<Integer> branchSeq = new ArrayList<Integer>();
    protected List<Integer> headOrDiffractSeq = new ArrayList<Integer>();
    protected List<SeismicPhaseSegment> segmentList = new ArrayList<SeismicPhaseSegment>();
    protected ArrayList<PhaseInteraction> legAction = new ArrayList();
    protected ArrayList<Boolean> downGoing = new ArrayList();
    protected ArrayList<Boolean> waveType = new ArrayList();
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;
    protected static double maxRefraction = 20.0;
    protected static double maxDiffraction = 60.0;
    static double maxKmpsLaps = 1.0;

    public static double getMaxRefraction() {
        return maxRefraction;
    }

    public static void setMaxRefraction(double max) {
        maxRefraction = max;
    }

    public static double getMaxDiffraction() {
        return maxDiffraction;
    }

    public static void setMaxDiffraction(double max) {
        maxDiffraction = max;
    }

    public static double getMaxKmpsLaps() {
        return maxKmpsLaps;
    }

    public static void setMaxKmpsLaps(double max) {
        maxKmpsLaps = max;
    }

    SeismicPhaseFactory(String name, TauModel tMod, double sourceDepth, double receiverDepth, boolean debug) throws TauModelException {
        this.DEBUG = debug;
        if (name == null || name.length() == 0) {
            throw new TauModelException("Phase name cannot be empty to null: " + name);
        }
        TauModel sourceDepthTMod = sourceDepth == tMod.getSourceDepth() ? tMod : tMod.depthCorrect(sourceDepth);
        this.tMod = sourceDepthTMod.splitBranch(receiverDepth);
        this.name = name;
        this.sourceDepth = sourceDepth;
        this.receiverDepth = receiverDepth;
        this.upgoingRecBranch = this.tMod.findBranch(receiverDepth);
        this.downgoingRecBranch = this.upgoingRecBranch - 1;
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod) throws TauModelException {
        return SeismicPhaseFactory.createPhase(name, tMod, tMod.getSourceDepth());
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod, double sourceDepth) throws TauModelException {
        return SeismicPhaseFactory.createPhase(name, tMod, sourceDepth, 0.0);
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod, double sourceDepth, double receiverDepth) throws TauModelException {
        return SeismicPhaseFactory.createPhase(name, tMod, sourceDepth, receiverDepth, ToolRun.DEBUG);
    }

    public static SimpleSeismicPhase createPhase(String name, TauModel tMod, double sourceDepth, double receiverDepth, boolean debug) throws TauModelException {
        SeismicPhaseFactory factory = new SeismicPhaseFactory(name, tMod, sourceDepth, receiverDepth, debug);
        return factory.internalCreatePhase();
    }

    public static void configure(Properties toolProps) {
        if (toolProps.containsKey("taup.maxRefraction")) {
            SeismicPhaseFactory.setMaxRefraction(Double.parseDouble(toolProps.getProperty("taup.maxRefraction")));
        }
        if (toolProps.containsKey("taup.maxDiffraction")) {
            SeismicPhaseFactory.setMaxDiffraction(Double.parseDouble(toolProps.getProperty("taup.maxDiffraction")));
        }
        if (toolProps.containsKey("taup.maxKmpsLaps")) {
            SeismicPhaseFactory.setMaxKmpsLaps(Double.parseDouble(toolProps.getProperty("taup.maxKmpsLaps")));
        }
    }

    public static List<SeismicPhase> createSeismicPhases(String name, TauModel tMod, double sourceDepth, double receiverDepth, double scattererDepth, double scattererDistanceDeg, boolean debug) throws TauModelException {
        ArrayList<SeismicPhase> phaseList = new ArrayList<SeismicPhase>();
        if (name.contains("o") || name.contains("O")) {
            String[] in_scat = name.split("(o|O)");
            if (in_scat.length != 2) {
                throw new TauModelException("Scatter phase doesn't have two segments: " + name);
            }
            if (scattererDistanceDeg == 0.0) {
                throw new ScatterArrivalFailException("Attempt to use scatter phase but scatter distance is zero: " + name);
            }
            boolean isBackscatter = false;
            if (name.contains("O")) {
                isBackscatter = true;
            }
            TauModel tModDepthCorrected = tMod.depthCorrect(sourceDepth);
            tModDepthCorrected = tModDepthCorrected.splitBranch(receiverDepth);
            SimpleSeismicPhase inPhase = SeismicPhaseFactory.createPhase(in_scat[0], tModDepthCorrected, sourceDepth, scattererDepth, debug);
            SeismicPhaseSegment lastSegment = inPhase.getPhaseSegments().get(inPhase.getPhaseSegments().size() - 1);
            PhaseInteraction endAction = lastSegment.endAction;
            if (endAction == PhaseInteraction.END_DOWN) {
                lastSegment.endAction = isBackscatter ? PhaseInteraction.BACKSCATTER_DOWN : PhaseInteraction.SCATTER_DOWN;
            } else if (endAction == PhaseInteraction.END) {
                lastSegment.endAction = isBackscatter ? PhaseInteraction.BACKSCATTER : PhaseInteraction.SCATTER;
            }
            TauModel scatTMod = tModDepthCorrected.depthRecorrect(scattererDepth);
            SimpleSeismicPhase scatPhase = SeismicPhaseFactory.createPhase(in_scat[1], scatTMod, scattererDepth, receiverDepth, debug);
            List<Arrival> inArrivals = inPhase.calcTime(scattererDistanceDeg);
            if (inArrivals.size() == 0) {
                throw new ScatterArrivalFailException("No inbound arrivals to the scatterer for " + name + " at " + scattererDepth + " km depth and " + scattererDistanceDeg + " deg. Distance range for scatterer at this depth is " + inPhase.getMinDistanceDeg() + " " + inPhase.getMaxDistanceDeg() + " deg.");
            }
            for (Arrival inArr : inArrivals) {
                ScatteredSeismicPhase seismicPhase = new ScatteredSeismicPhase(inArr, scatPhase, scattererDepth, scattererDistanceDeg, isBackscatter);
                phaseList.add(seismicPhase);
            }
        } else {
            TauModel tModDepthCorrected = tMod.depthCorrect(sourceDepth);
            tModDepthCorrected = tModDepthCorrected.splitBranch(receiverDepth);
            SimpleSeismicPhase seismicPhase = SeismicPhaseFactory.createPhase(name, tModDepthCorrected, sourceDepth, receiverDepth, debug);
            phaseList.add(seismicPhase);
        }
        return phaseList;
    }

    SimpleSeismicPhase internalCreatePhase() throws TauModelException {
        this.legs = LegPuller.legPuller(this.name);
        this.puristName = LegPuller.createPuristName(this.tMod, this.legs);
        this.parseName(this.tMod);
        this.sumBranches(this.tMod);
        SimpleSeismicPhase phase = new SimpleSeismicPhase(this.name, this.tMod, this.receiverDepth, this.legs, this.puristName, this.rayParams, this.time, this.dist, this.minRayParam, this.maxRayParam, this.minRayParamIndex, this.maxRayParamIndex, this.minDistance, this.maxDistance, this.branchSeq, this.headOrDiffractSeq, this.segmentList, this.legAction, this.downGoing, this.waveType, this.DEBUG);
        return phase;
    }

    public String getName() {
        return this.name;
    }

    public Boolean legIsPWave(String currLeg) {
        if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.startsWith("I") || currLeg.equals("y") || currLeg.startsWith("K") || currLeg.equals("k")) {
            return true;
        }
        if (currLeg.equals("s") || currLeg.startsWith("S") || currLeg.equals("J") || currLeg.equals("j")) {
            return false;
        }
        return null;
    }

    public boolean[] legsArePWave() {
        boolean[] isPWaveForLegs = new boolean[this.legs.size()];
        int legNum = 0;
        boolean prevWaveType = true;
        for (String currLeg : this.legs) {
            Boolean currWaveType;
            if (currLeg.equals("END")) {
                currWaveType = prevWaveType;
            } else {
                currWaveType = this.legIsPWave(currLeg);
                if (currWaveType == null) {
                    if (legNum == this.legs.size() - 2) {
                        currWaveType = prevWaveType;
                    } else if (legNum < this.legs.size() - 1) {
                        currWaveType = this.legIsPWave(this.legs.get(legNum + 1));
                        if (currWaveType == null) {
                            throw new RuntimeException("next wavetype is null: " + currLeg + " in " + this.name + " " + legNum + " of " + this.legs.size());
                        }
                    } else {
                        throw new RuntimeException("SHould never happen: " + currLeg + " of " + this.name + " " + legNum);
                    }
                }
            }
            isPWaveForLegs[legNum] = currWaveType;
            ++legNum;
            prevWaveType = currWaveType;
        }
        return isPWaveForLegs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseName(TauModel tMod) throws TauModelException {
        int sLayerNum;
        boolean isPWave;
        String currLeg;
        String nextLeg = currLeg = this.legs.get(0);
        this.branchSeq.clear();
        boolean prevIsPWave = isPWave = true;
        PhaseInteraction endAction = PhaseInteraction.TRANSDOWN;
        if (this.legs.size() == 2 && currLeg.endsWith("kmps")) {
            try {
                double d = Double.valueOf(currLeg.substring(0, this.name.length() - 4));
            }
            catch (NumberFormatException e) {
                throw new TauModelException(this.getName() + " Illegal surface wave velocity " + this.name.substring(0, this.name.length() - 4), e);
            }
            SeismicPhaseSegment flatSegment = this.addFlatBranch(tMod, 0, false, PhaseInteraction.KMPS, PhaseInteraction.END, currLeg);
            return;
        }
        if (!(this.name.indexOf(74) == -1 && this.name.indexOf(106) == -1 || tMod.getSlownessModel().isAllowInnerCoreS())) {
            throw new TauModelException(this.getName() + " 'J' phases were not created for this model: " + tMod.getModelName());
        }
        for (String leg : this.legs) {
            if (tMod.getCmbBranch() == tMod.getNumBranches() && (leg.startsWith("K") || leg.equals("k") || leg.equals("c"))) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot have K leg in model with no outer core within phase " + this.name);
                return;
            }
            if (tMod.getIocbBranch() != tMod.getNumBranches() || !leg.startsWith("I") && !leg.startsWith("J") && !leg.equals("j") && !leg.equals("y") && !leg.equals("i")) continue;
            this.maxRayParam = -1.0;
            this.minRayParam = -1.0;
            if (!this.DEBUG) return;
            System.out.println("Cannot have I,J,y,j,i leg in model with no inner core within phase " + this.name);
            return;
        }
        if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.startsWith("K") || currLeg.equals("k") || currLeg.startsWith("I") || currLeg.equals("y")) {
            prevIsPWave = isPWave = true;
        } else {
            if (!currLeg.equals("s") && !currLeg.startsWith("S") && !currLeg.startsWith("J") && !currLeg.equals("j")) throw new TauModelException(this.getName() + " Unknown starting phase: " + currLeg);
            prevIsPWave = isPWave = false;
        }
        if (currLeg.startsWith("s") || currLeg.startsWith("S")) {
            double sdep = tMod.getSourceDepth();
            if (tMod.getSlownessModel().depthInFluid(sdep, new DepthRange())) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot have S wave with starting depth in fluid layer" + currLeg + " within phase " + this.name);
                return;
            }
        }
        if (currLeg.startsWith("P") || currLeg.startsWith("S") || currLeg.startsWith("K") || currLeg.startsWith("I") || currLeg.startsWith("J")) {
            if ((currLeg.startsWith("P") || currLeg.startsWith("S")) && tMod.getSourceDepth() > tMod.getCmbDepth()) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Source must be in crust/mantle for " + currLeg + " within phase " + this.name);
                return;
            }
            if (currLeg.startsWith("K") && (tMod.getSourceDepth() < tMod.getCmbDepth() || tMod.getSourceDepth() > tMod.getIocbDepth())) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Source must be in outer core for " + currLeg + " within phase " + this.name);
                return;
            }
            if ((currLeg.startsWith("I") || currLeg.startsWith("J")) && tMod.getSourceDepth() < tMod.getIocbDepth()) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Source must be in inner core for " + currLeg + " within phase " + this.name);
                return;
            }
            this.currBranch = tMod.getSourceBranch();
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            try {
                sLayerNum = tMod.getSlownessModel().layerNumberBelow(tMod.getSourceDepth(), prevIsPWave);
                this.maxRayParam = tMod.getSlownessModel().getSlownessLayer(sLayerNum, prevIsPWave).getTopP();
            }
            catch (NoSuchLayerException e) {
                throw new RuntimeException("Should not happen", e);
            }
            this.maxRayParam = tMod.getTauBranch(tMod.getSourceBranch(), isPWave).getMaxRayParam();
        } else {
            if (!currLeg.equals("p") && !currLeg.equals("s") && !currLeg.equals("y") && !currLeg.equals("j") && !currLeg.startsWith("k")) throw new TauModelException(this.getName() + " First phase not recognized: " + currLeg + " Must be one of P, Pg, Pn, Pdiff, p, Ped or the S equivalents in crust/mantle, or k, K, I, J, j for core sources.");
            if ((currLeg.startsWith("p") || currLeg.startsWith("s")) && tMod.getSourceDepth() > tMod.getCmbDepth()) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Source must be in crust/mantle for " + currLeg + " within phase " + this.name);
                return;
            }
            if (currLeg.startsWith("k") && (tMod.getSourceDepth() < tMod.getCmbDepth() || tMod.getSourceDepth() > tMod.getIocbDepth())) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Source must be in outer core for " + currLeg + " within phase " + this.name);
                return;
            }
            if ((currLeg.startsWith("y") || currLeg.startsWith("j")) && tMod.getSourceDepth() < tMod.getIocbDepth()) {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Source must be in inner core for " + currLeg + " within phase " + this.name);
                return;
            }
            endAction = PhaseInteraction.REFLECT_TOPSIDE;
            try {
                sLayerNum = tMod.getSlownessModel().layerNumberAbove(tMod.getSourceDepth(), prevIsPWave);
                this.maxRayParam = tMod.getSlownessModel().getSlownessLayer(sLayerNum, prevIsPWave).getBotP();
                DepthRange highSZoneDepth = new DepthRange();
                if (tMod.getSlownessModel().depthInHighSlowness(tMod.getSourceDepth(), this.maxRayParam, highSZoneDepth, prevIsPWave)) {
                    this.maxRayParam = Math.min(this.maxRayParam, highSZoneDepth.rayParam);
                }
            }
            catch (NoSuchLayerException e) {
                throw new RuntimeException("Should not happen", e);
            }
            if (tMod.getSourceBranch() != 0) {
                this.currBranch = tMod.getSourceBranch() - 1;
            } else {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println(this.getName() + " Upgoing initial leg but already at surface, so no ray parameters satisfy path.");
                return;
            }
        }
        if (this.receiverDepth != 0.0) {
            this.maxRayParam = this.legs.get(this.legs.size() - 2).equals("Ped") || this.legs.get(this.legs.size() - 2).equals("Sed") || this.legs.get(this.legs.size() - 2).equals("Ked") || this.legs.get(this.legs.size() - 2).equals("Ied") || this.legs.get(this.legs.size() - 2).equals("Jed") ? Math.min(tMod.getTauBranch(this.downgoingRecBranch, isPWave).getMinTurnRayParam(), this.maxRayParam) : Math.min(tMod.getTauBranch(this.upgoingRecBranch, isPWave).getMaxRayParam(), this.maxRayParam);
        }
        this.minRayParam = 0.0;
        if (this.maxRayParam < 0.0) {
            this.minRayParam = this.maxRayParam;
        }
        boolean[] isLegPWave = this.legsArePWave();
        currLeg = "START";
        for (int legNum = 0; legNum < this.legs.size(); ++legNum) {
            String prevLeg = currLeg;
            currLeg = nextLeg;
            nextLeg = legNum < this.legs.size() - 1 ? this.legs.get(legNum + 1) : "END";
            if (this.DEBUG) {
                System.out.println("Iterate legs: " + legNum + "  " + prevLeg + "  cur=" + currLeg + "  " + nextLeg);
            }
            if (currLeg.contentEquals("END") && this.segmentList.size() > 0) {
                this.segmentList.get((int)(this.segmentList.size() - 1)).endAction = PhaseInteraction.END;
                continue;
            }
            this.isLegDepth = this.isNextLegDepth;
            try {
                this.nextLegDepth = Double.parseDouble(nextLeg);
                this.isNextLegDepth = true;
            }
            catch (NumberFormatException e) {
                this.nextLegDepth = -1.0;
                this.isNextLegDepth = false;
            }
            prevIsPWave = isPWave;
            boolean nextIsPWave = isPWave = isLegPWave[legNum];
            if (legNum < isLegPWave.length - 1) {
                nextIsPWave = isLegPWave[legNum + 1];
            }
            if (currLeg.equals("Ped") || currLeg.equals("Sed")) {
                endAction = this.currLegIs_Ped_Sed(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if (currLeg.equals("p") || currLeg.equals("s")) {
                endAction = this.currLegIs_p_s(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if (currLeg.equals("P") || currLeg.equals("S")) {
                endAction = this.currLegIs_P_S(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if ((currLeg.startsWith("P") || currLeg.startsWith("S")) && currLeg.endsWith("diff")) {
                endAction = this.currLegIs_Pdiff_Sdiff(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if ((currLeg.startsWith("P") || currLeg.startsWith("S")) && (currLeg.endsWith("n") || currLeg.endsWith("g"))) {
                endAction = this.currLegIs_Pn_Sn(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            } else if (currLeg.equals("K")) {
                endAction = this.checkDegenerateOuterCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_K(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if (currLeg.equals("Ked")) {
                endAction = this.checkDegenerateOuterCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_Ked(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if (currLeg.startsWith("K") && currLeg.endsWith("diff")) {
                endAction = this.checkDegenerateOuterCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_Kdiff(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if (currLeg.equals("k")) {
                endAction = this.checkDegenerateOuterCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_k(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if (currLeg.equals("I") || currLeg.equals("J")) {
                endAction = this.checkDegenerateInnerCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_I_J(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if ((currLeg.startsWith("I") || currLeg.startsWith("J")) && currLeg.endsWith("diff")) {
                endAction = this.checkDegenerateInnerCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_I_Jdiff(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if (currLeg.equals("Ied") || currLeg.equals("Jed")) {
                endAction = this.checkDegenerateInnerCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_Ied_Jed(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if (currLeg.equals("y") || currLeg.equals("j")) {
                endAction = this.checkDegenerateInnerCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum) ? this.currLegIs_y_j(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum) : PhaseInteraction.FAIL;
            } else if (currLeg.equals("m") || currLeg.equals("c") || currLeg.equals("cx") || currLeg.equals("i") || currLeg.equals("ix")) {
                if ((currLeg.equals("c") || currLeg.equals("cx")) && !this.checkDegenerateOuterCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum)) {
                    endAction = PhaseInteraction.FAIL;
                }
                if ((currLeg.equals("i") || currLeg.equals("ix")) && !this.checkDegenerateInnerCore(prevLeg, currLeg, nextLeg, isPWave, prevIsPWave, legNum)) {
                    endAction = PhaseInteraction.FAIL;
                }
                if (nextLeg.equals("END")) {
                    throw new TauModelException(this.getName() + " Phase not recognized (12): " + currLeg + " as last leg, then " + nextLeg);
                }
            } else if (currLeg.startsWith("^")) {
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                if (nextLeg.equals("END")) {
                    throw new TauModelException(this.getName() + " Phase not recognized (12): " + currLeg + " as last leg, then " + nextLeg);
                }
            } else if (currLeg.startsWith("v") || currLeg.startsWith("V")) {
                if (nextLeg.equals("END")) {
                    throw new TauModelException(this.getName() + " Phase not recognized (12): " + currLeg + " as last leg, then " + nextLeg);
                }
                String depthString = currLeg.substring(1);
                int b = LegPuller.closestBranchToDepth(tMod, depthString);
                if (b == 0) {
                    throw new TauModelException(this.getName() + " Phase not recognized: " + currLeg + " looks like a top side reflection at the free surface.");
                }
            } else if (this.isLegDepth) {
                int b = LegPuller.closestBranchToDepth(tMod, currLeg);
                if (b == 0 && (nextLeg.equals("p") || nextLeg.equals("s"))) {
                    throw new TauModelException(this.getName() + " Phase not recognized: " + currLeg + " followed by " + nextLeg + " looks like a upgoing wave from the free surface as closest discontinuity to " + currLeg + " is zero depth.");
                }
            } else {
                if (!currLeg.endsWith("n")) throw new TauModelException(this.getName() + " Phase not recognized (10): " + currLeg + " followed by " + nextLeg);
                this.currLegIs_OtherHead(prevLeg, currLeg, nextLeg, prevIsPWave, isPWave, nextIsPWave, legNum);
            }
            if (endAction == PhaseInteraction.FAIL || this.maxRayParam < 0.0) break;
            this.prevEndAction = endAction;
        }
        if (endAction == PhaseInteraction.FAIL || this.maxRayParam == -1.0) return;
        if (this.branchSeq.size() > 0 && this.branchSeq.get(this.branchSeq.size() - 1) != this.upgoingRecBranch && this.branchSeq.get(this.branchSeq.size() - 1) != this.downgoingRecBranch) {
            throw new TauModelException(this.getName() + " Phase does not end at the receiver branch, last: " + this.branchSeq.get(this.branchSeq.size() - 1) + " down Rec: " + this.downgoingRecBranch + " up Rec: " + this.upgoingRecBranch);
        }
        if ((endAction == PhaseInteraction.REFLECT_UNDERSIDE || endAction == PhaseInteraction.REFLECT_UNDERSIDE) && this.downgoingRecBranch == this.branchSeq.get(this.branchSeq.size() - 1)) {
            if (this.DEBUG) {
                System.out.println("Phase ends upgoing, but receiver is not on upgoing end of last branch");
            }
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            return;
        } else if ((endAction == PhaseInteraction.REFLECT_TOPSIDE || endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) && this.upgoingRecBranch == this.branchSeq.get(this.branchSeq.size() - 1)) {
            if (this.DEBUG) {
                System.out.println("Phase ends downgoing, but receiver is not on downgoing end of last branch");
                System.out.println(SeismicPhaseFactory.endActionString(endAction) + " upgoingRecBranch=" + this.upgoingRecBranch + "  bs=" + this.branchSeq.get(this.branchSeq.size() - 1));
            }
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            return;
        } else {
            if (!this.DEBUG) return;
            System.out.println("Last action is: " + SeismicPhaseFactory.endActionString(endAction) + " upR=" + this.upgoingRecBranch + " downR=" + this.downgoingRecBranch + " last=" + this.branchSeq.get(this.branchSeq.size() - 1));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PhaseInteraction currLegIs_p_s(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (this.tMod.getVelocityModel().cmbDepth == 0.0) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            throw new TauModelException(this.getName() + " p and s and k must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + currLeg + " nextLeg=" + nextLeg);
        }
        if (nextLeg.equals("p") || nextLeg.equals("s")) {
            throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg);
        }
        if (nextLeg.startsWith("^")) {
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (this.currBranch < disconBranch) throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.equals("m") && this.currBranch >= this.tMod.getMohoBranch()) {
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getMohoBranch(), isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.equals("END")) {
            int disconBranch;
            if (nextLeg.equals("END")) {
                disconBranch = this.upgoingRecBranch;
                if (this.currBranch < this.upgoingRecBranch) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return PhaseInteraction.FAIL;
                    System.out.println(this.name + " (currBranch >= receiverBranch() " + this.currBranch + " " + this.upgoingRecBranch + " so there cannot be a " + currLeg + " phase for this sourceDepth, receiverDepth and/or path.");
                    return PhaseInteraction.FAIL;
                }
            } else {
                disconBranch = 0;
            }
            endAction = nextLeg.equals("END") ? PhaseInteraction.END : PhaseInteraction.REFLECT_UNDERSIDE;
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else {
            if (nextLeg.equals("c") || nextLeg.equals("i") || nextLeg.equals("I") || nextLeg.equals("J") || nextLeg.equals("j")) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", p and s must be upgoing in mantle and so cannot hit core.");
            }
            if (!this.isLegDepth(currLeg)) throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg);
            double nextLegDepth = Double.parseDouble(currLeg);
            if (nextLegDepth >= this.tMod.getCmbDepth()) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", p and s must be upgoing in mantle and so cannot hit core.");
            }
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg);
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
        }
        return endAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PhaseInteraction currLegIs_P_S(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        Object prevSegment = null;
        if (this.segmentList.size() > 0) {
            this.segmentList.get(this.segmentList.size() - 1);
        }
        if (this.tMod.getVelocityModel().cmbDepth == 0.0) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.equals("P") || nextLeg.equals("S") || nextLeg.equals("Pn") || nextLeg.equals("Sn") || nextLeg.equals("Pdiff") || nextLeg.equals("Sdiff") || nextLeg.equals("END")) {
            if (this.prevEndAction == PhaseInteraction.START || this.prevEndAction == PhaseInteraction.TRANSDOWN || this.prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE || this.prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                endAction = PhaseInteraction.TURN;
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, isPWave, endAction, currLeg);
            }
            if (nextLeg.equals("END")) {
                endAction = PhaseInteraction.END;
                this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            } else {
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                this.addToBranch(this.tMod, this.currBranch, 0, isPWave, nextIsPWave, endAction, currLeg);
            }
            return endAction;
        }
        if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            endAction = nextLeg.startsWith("V") ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg.substring(1));
            if (this.currBranch <= disconBranch - 1) {
                this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.startsWith("^")) {
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (disconBranch == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println("Attempt to underside reflect from center of earth: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            if (prevLeg.equals("K")) {
                this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            } else if (prevLeg.startsWith("^") || prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("p") || prevLeg.equals("s") || prevLeg.equals("m") || prevLeg.equals("START")) {
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, isPWave, PhaseInteraction.TURN, currLeg);
                this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            } else {
                if ((!prevLeg.startsWith("v") && !prevLeg.startsWith("V") || disconBranch >= LegPuller.closestBranchToDepth(this.tMod, prevLeg.substring(1))) && (!prevLeg.equals("m") || disconBranch >= this.tMod.getMohoBranch()) && (!prevLeg.equals("c") || disconBranch >= this.tMod.getCmbBranch())) throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch + " , prev=" + prevLeg);
                if (disconBranch == this.tMod.getNumBranches()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return PhaseInteraction.FAIL;
                    System.out.println("Attempt to reflect from center of earth: " + nextLeg);
                    return PhaseInteraction.FAIL;
                }
                this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            }
            return endAction;
        }
        if (nextLeg.equals("c")) {
            if (this.tMod.getCmbBranch() == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println("Attempt to reflect from center of earth: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            endAction = PhaseInteraction.REFLECT_TOPSIDE;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("K") && prevLeg.equals("K")) {
            throw new TauModelException(this.getName() + " Phase not recognized (5.5): " + currLeg + " followed by " + nextLeg + " and preceeded by " + prevLeg + " when currBranch=" + this.currBranch);
        }
        if (nextLeg.startsWith("K")) {
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("I") || nextLeg.equals("J")) {
            if (this.tMod.getCmbDepth() != this.tMod.getIocbDepth()) throw new TauModelException(this.getName() + " P or S followed by I or J can only exist if model has no outer core: " + currLeg + " followed by " + nextLeg);
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("m") || this.isNextLegDepth && this.nextLegDepth < this.tMod.getCmbDepth()) {
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg);
            if (this.DEBUG) {
                System.out.println("DisconBranch=" + disconBranch + " for " + nextLeg);
                System.out.println(this.tMod.getTauBranch(disconBranch, isPWave).getTopDepth());
            }
            if (this.prevEndAction == PhaseInteraction.TURN || this.prevEndAction == PhaseInteraction.REFLECT_TOPSIDE || this.prevEndAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL || this.prevEndAction == PhaseInteraction.TRANSUP) {
                if (disconBranch > this.currBranch) {
                    throw new TauModelException(this.getName() + " Phase not recognized (6): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                }
                endAction = PhaseInteraction.TRANSUP;
                this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            String nextNextLeg = this.legs.get(legNum + 2);
            if (nextNextLeg.equals("p") || nextNextLeg.equals("s")) {
                endAction = PhaseInteraction.TURN;
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, isPWave, endAction, currLeg);
                endAction = PhaseInteraction.TRANSUP;
                this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            if (!nextNextLeg.equals("P") && !nextNextLeg.equals("S")) throw new TauModelException(this.getName() + " Phase not recognized (7): " + currLeg + " followed by " + nextLeg + " followed by " + nextNextLeg);
            if (disconBranch > this.currBranch) {
                endAction = PhaseInteraction.TRANSDOWN;
                this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            this.maxRayParam = -1.0;
            if (!this.DEBUG) return PhaseInteraction.FAIL;
            System.out.println("Cannot phase convert on the downgoing side if the discontinuity is above the phase leg starting point, " + currLeg + " " + nextLeg + " " + nextNextLeg + ", so this phase, " + this.getName() + " is illegal for this sourceDepth.");
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = nextLeg.substring(0, nextLeg.length() - 1);
            try {
                double headDepth = Double.parseDouble(numString);
                int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
                endAction = PhaseInteraction.HEAD;
                this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            catch (NumberFormatException e) {
                throw new TauModelException(this.getName() + " Phase not recognized (7): " + currLeg + " followed by " + nextLeg + " expected number but was `" + numString + "`", e);
            }
        }
        if (!nextLeg.endsWith("diff") || nextLeg.length() <= 4) throw new TauModelException(this.getName() + " Phase not recognized (8): " + currLeg + " followed by " + nextLeg);
        String numString = nextLeg.substring(0, nextLeg.length() - 4);
        try {
            double diffDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (this.prevEndAction == PhaseInteraction.START || this.prevEndAction == PhaseInteraction.TRANSDOWN || this.prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE || this.prevEndAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                endAction = PhaseInteraction.TURN;
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, isPWave, endAction, currLeg);
            }
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            this.addToBranch(this.tMod, this.currBranch, 0, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        catch (NumberFormatException e) {
            throw new TauModelException(this.getName() + " Phase not recognized (7): " + currLeg + " followed by " + nextLeg + " expected number but was `" + numString + "`", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    PhaseInteraction currLegIs_Ped_Sed(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (this.tMod.getVelocityModel().cmbDepth == 0.0) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.equals("END")) {
            if (this.receiverDepth > 0.0) {
                endAction = PhaseInteraction.END_DOWN;
                this.addToBranch(this.tMod, this.currBranch, this.downgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            this.maxRayParam = -1.0;
            this.minRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.equals("Pdiff") || nextLeg.equals("Sdiff")) {
            endAction = PhaseInteraction.DIFFRACT;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = nextLeg.substring(0, nextLeg.length() - 1);
            double headDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            endAction = PhaseInteraction.HEAD;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.endsWith("diff") && nextLeg.length() > 4) {
            String numString = nextLeg.substring(0, nextLeg.length() - 4);
            double diffDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            endAction = PhaseInteraction.DIFFRACT;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("K") || nextLeg.equals("Ked") || nextLeg.equals("Kdiff")) {
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("m")) {
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getMohoBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (this.isLegDepth) {
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg);
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("c") || nextLeg.equals("i")) {
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg);
            endAction = PhaseInteraction.REFLECT_TOPSIDE;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            endAction = nextLeg.startsWith("V") ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg.substring(1));
            if (this.currBranch > disconBranch - 1) throw new TauModelException(this.getName() + " Phase not recognized (4): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (!nextLeg.equals("I")) {
            if (!nextLeg.equals("J")) throw new TauModelException(this.getName() + " Phase not recognized (1): " + currLeg + " followed by " + nextLeg);
        }
        if (this.tMod.getCmbDepth() == this.tMod.getIocbDepth()) {
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        this.maxRayParam = -1.0;
        if (!this.DEBUG) return PhaseInteraction.FAIL;
        System.out.println("P or S followed by I or J can only exist if model has no outer core");
        return PhaseInteraction.FAIL;
    }

    /*
     * Enabled aggressive block sorting
     */
    PhaseInteraction currLegIs_Pdiff_Sdiff(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (this.tMod.getVelocityModel().cmbDepth == 0.0) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (currLeg.equals("Pdiff") || currLeg.equals("Sdiff")) {
            endAction = PhaseInteraction.DIFFRACT;
            if (this.maxRayParam >= this.tMod.getTauBranch(this.tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam() && this.minRayParam <= this.tMod.getTauBranch(this.tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam()) {
                SeismicPhaseSegment prevSegment;
                SeismicPhaseSegment seismicPhaseSegment = prevSegment = this.segmentList.size() > 0 ? this.segmentList.get(this.segmentList.size() - 1) : null;
                if (this.currBranch < this.tMod.getCmbBranch() - 1 || this.prevEndAction == PhaseInteraction.START || this.currBranch == this.tMod.getCmbBranch() && prevSegment != null && prevSegment.endsAtTop()) {
                    endAction = PhaseInteraction.DIFFRACT;
                    this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
                } else {
                    if (this.currBranch != this.tMod.getCmbBranch() - 1) throw new TauModelException("Unable to diffract, " + this.currBranch + " to cmb " + (this.tMod.getCmbBranch() - 1) + " " + SeismicPhaseFactory.endActionString(this.prevEndAction) + " " + prevSegment);
                    if (prevSegment.endAction != PhaseInteraction.DIFFRACT) {
                        if (prevSegment.endAction != PhaseInteraction.TRANSUP) throw new TauModelException("Unable to diffract, " + this.currBranch + " to cmb " + (this.tMod.getCmbBranch() - 1) + " " + SeismicPhaseFactory.endActionString(this.prevEndAction) + " " + prevSegment);
                    }
                }
                if (nextLeg.startsWith("K") || nextLeg.equals("I") || nextLeg.equals("J")) {
                    this.addFlatBranch(this.tMod, this.tMod.getCmbBranch() - 1, isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
                } else {
                    this.addFlatBranch(this.tMod, this.tMod.getCmbBranch() - 1, isPWave, endAction, PhaseInteraction.TURN, currLeg);
                }
                if (nextLeg.equals("END")) {
                    endAction = PhaseInteraction.END;
                    this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                    return endAction;
                }
                if (nextLeg.equals("K") || nextLeg.equals("Ked")) {
                    endAction = PhaseInteraction.TRANSDOWN;
                    ++this.currBranch;
                    return endAction;
                }
                if (nextLeg.startsWith("^")) {
                    String depthString = nextLeg.substring(1);
                    endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                    int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
                    if (disconBranch >= this.tMod.getCmbBranch()) {
                        this.maxRayParam = -1.0;
                        if (!this.DEBUG) return PhaseInteraction.FAIL;
                        System.out.println(this.getName() + " Attempt to underside reflect " + currLeg + " from deeper layer: " + nextLeg);
                        return PhaseInteraction.FAIL;
                    }
                    this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                    return endAction;
                }
                if (!nextLeg.startsWith("P") && !nextLeg.startsWith("S")) {
                    if (nextLeg.equals("p")) return endAction;
                    if (!nextLeg.equals("s")) throw new TauModelException(this.getName() + " Phase not recognized (12): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch);
                    return endAction;
                }
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                this.addToBranch(this.tMod, this.currBranch, 0, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            if (this.DEBUG) {
                System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
                System.out.println(this.maxRayParam + " >= " + this.tMod.getTauBranch(this.tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam() + " && " + this.minRayParam + " <= " + this.tMod.getTauBranch(this.tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam());
            }
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (!currLeg.endsWith("diff")) throw new TauModelException(this.getName() + " Phase not recognized for P,S: " + currLeg + " followed by " + nextLeg);
        if (currLeg.length() <= 5) throw new TauModelException(this.getName() + " Phase not recognized for P,S: " + currLeg + " followed by " + nextLeg);
        int depthIdx = 0;
        if (currLeg.startsWith("P") || currLeg.startsWith("S")) {
            depthIdx = 1;
        }
        String numString = currLeg.substring(depthIdx, currLeg.length() - 4);
        double diffDepth = Double.parseDouble(numString);
        int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
        endAction = PhaseInteraction.DIFFRACT;
        this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        if (nextLeg.startsWith("K") || nextLeg.equals("I") || nextLeg.equals("J")) {
            this.addFlatBranch(this.tMod, disconBranch - 1, isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
        } else {
            this.addFlatBranch(this.tMod, disconBranch - 1, isPWave, endAction, PhaseInteraction.TURN, currLeg);
        }
        if (!nextLeg.equals("END")) return endAction;
        endAction = PhaseInteraction.END;
        this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
        return endAction;
    }

    /*
     * Enabled aggressive block sorting
     */
    PhaseInteraction currLegIs_Pn_Sn(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (this.tMod.getVelocityModel().cmbDepth == 0.0) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (currLeg.endsWith("n") && currLeg.length() > 2) {
            int depthIdx = 0;
            if (currLeg.startsWith("P") || currLeg.startsWith("S")) {
                depthIdx = 1;
            }
            String numString = currLeg.substring(depthIdx, currLeg.length() - 1);
            double diffDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            endAction = PhaseInteraction.HEAD;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            if (nextLeg.startsWith("K") || nextLeg.equals("I") || nextLeg.equals("J")) {
                this.addFlatBranch(this.tMod, disconBranch, isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
            } else {
                this.addFlatBranch(this.tMod, disconBranch, isPWave, endAction, PhaseInteraction.TRANSUP, currLeg);
            }
            this.currBranch = disconBranch;
            if (!nextLeg.equals("END")) return endAction;
            endAction = PhaseInteraction.END;
            this.addToBranch(this.tMod, this.currBranch - 1, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (!(currLeg.equals("Pg") || currLeg.equals("Sg") || currLeg.equals("Pn"))) {
            if (!currLeg.equals("Sn")) throw new TauModelException(this.getName() + " Phase not recognized for P,S: " + currLeg + " followed by " + nextLeg);
        }
        endAction = PhaseInteraction.TURN;
        if (this.currBranch >= this.tMod.getMohoBranch()) {
            this.maxRayParam = -1.0;
            if (!this.DEBUG) return PhaseInteraction.FAIL;
            System.out.println("(currBranch >= tMod.getMohoBranch() " + this.currBranch + " " + this.tMod.getMohoBranch() + " so there cannot be a " + currLeg + " phase for this sourceDepth and/or path.");
            return PhaseInteraction.FAIL;
        }
        if (currLeg.equals("Pg") || currLeg.equals("Sg")) {
            endAction = PhaseInteraction.TURN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getMohoBranch() - 1, isPWave, isPWave, endAction, currLeg);
            if (nextLeg.equals("END")) {
                endAction = PhaseInteraction.END;
                this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            if (nextLeg.startsWith("P") || nextLeg.startsWith("S")) {
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                this.addToBranch(this.tMod, this.currBranch, 0, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            if (!nextLeg.startsWith("^")) throw new TauModelException(this.getName() + " Phase not recognized (12): " + currLeg + " followed by " + nextLeg);
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (disconBranch >= this.tMod.getMohoBranch()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println(this.getName() + " Attempt to underside reflect " + currLeg + " from deeper layer: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (!currLeg.equals("Pn")) {
            if (!currLeg.equals("Sn")) return endAction;
        }
        if (this.maxRayParam >= this.tMod.getTauBranch(this.tMod.getMohoBranch(), isPWave).getMaxRayParam() && this.minRayParam <= this.tMod.getTauBranch(this.tMod.getMohoBranch(), isPWave).getMaxRayParam()) {
            endAction = PhaseInteraction.HEAD;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getMohoBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            this.minRayParam = this.maxRayParam;
            if (nextLeg.equals("Ped") || nextLeg.equals("Sed")) {
                this.addFlatBranch(this.tMod, this.tMod.getMohoBranch(), isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
            } else {
                this.addFlatBranch(this.tMod, this.tMod.getMohoBranch(), isPWave, endAction, PhaseInteraction.TRANSUP, currLeg);
            }
            if (nextLeg.equals("END")) {
                endAction = PhaseInteraction.END;
                if (this.currBranch >= this.upgoingRecBranch) {
                    this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                    return endAction;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth, receiverDepth and/or path.");
                return PhaseInteraction.FAIL;
            }
            if (nextLeg.startsWith("P") || nextLeg.startsWith("S")) {
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                this.addToBranch(this.tMod, this.currBranch, 0, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            if (!nextLeg.startsWith("^")) throw new TauModelException(this.getName() + " Phase not recognized (12): " + currLeg + " followed by " + nextLeg);
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (disconBranch >= this.tMod.getMohoBranch()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println(this.getName() + " Attempt to underside reflect " + currLeg + " from deeper layer: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        this.maxRayParam = -1.0;
        if (!this.DEBUG) return PhaseInteraction.FAIL;
        System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
        return PhaseInteraction.FAIL;
    }

    PhaseInteraction currLegIs_OtherHead(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        if (currLeg.endsWith("n")) {
            if (!nextLeg.equals("END")) {
                throw new TauModelException(this.getName() + " Phase not recognized for non-standard diffraction: " + currLeg + " followed by " + nextLeg);
            }
        } else {
            throw new TauModelException(this.getName() + " Phase not recognized for non-standard diffraction: " + currLeg + " followed by " + nextLeg);
        }
        PhaseInteraction endAction = PhaseInteraction.END;
        this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
        return endAction;
    }

    boolean checkDegenerateOuterCore(String prevLeg, String currLeg, String nextLeg, boolean isPWave, boolean isPWavePrev, int legNum) throws TauModelException {
        if (this.tMod.getCmbDepth() == this.tMod.getRadiusOfEarth()) {
            this.maxRayParam = -1.0;
            if (this.DEBUG) {
                System.out.println("Cannot have K phase " + currLeg + " within phase " + this.name + " for this model as it has no core, cmb depth = radius of Earth.");
            }
            return false;
        }
        if (this.tMod.getCmbDepth() == this.tMod.getIocbDepth()) {
            this.maxRayParam = -1.0;
            if (this.DEBUG) {
                System.out.println("Cannot have K phase " + currLeg + " within phase " + this.name + " for this model as it has no outer core, cmb depth = iocb depth, " + this.tMod.getCmbDepth());
            }
            return false;
        }
        return true;
    }

    PhaseInteraction currLegIs_Kdiff(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        if (this.tMod.getCmbBranch() == this.tMod.tauBranches[0].length || this.tMod.getIocbBranch() == this.tMod.tauBranches[0].length) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        int disconBranch = this.tMod.getIocbBranch();
        if (currLeg.equals("Kdiff")) {
            disconBranch = this.tMod.getIocbBranch();
        } else if (currLeg.endsWith("diff") && currLeg.length() > 5) {
            int depthIdx = 0;
            if (currLeg.startsWith("K")) {
                depthIdx = 1;
            }
            String numString = currLeg.substring(depthIdx, currLeg.length() - 4);
            double diffDepth = Double.parseDouble(numString);
            disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
        } else {
            throw new TauModelException("Not Kdiff " + currLeg + " in currLegIs_Kdiff " + this.getName());
        }
        PhaseInteraction endAction = PhaseInteraction.DIFFRACT;
        this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, true, nextIsPWave, endAction, currLeg);
        if (nextLeg.equals("I") || nextLeg.equals("J")) {
            this.addFlatBranch(this.tMod, disconBranch - 1, isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
        } else {
            this.addFlatBranch(this.tMod, disconBranch - 1, isPWave, endAction, PhaseInteraction.TURN, currLeg);
        }
        if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.equals("p") || nextLeg.equals("s")) {
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch(), true, nextIsPWave, endAction, currLeg);
        } else if (nextLeg.equals("K") || nextLeg.startsWith("K") && nextLeg.endsWith("diff")) {
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch(), true, nextIsPWave, endAction, currLeg);
        } else if (nextLeg.startsWith("^")) {
            String reflectdepthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int reflectBranch = LegPuller.closestBranchToDepth(this.tMod, reflectdepthString);
            if (reflectBranch < this.tMod.getCmbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (5a): " + currLeg + " followed by " + nextLeg + " when reflectBranch=" + reflectBranch + " < cmbBranch=" + this.tMod.getCmbBranch() + ", likely need P or S leg , prev=" + prevLeg);
            }
            if (reflectBranch >= disconBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5b): " + currLeg + " followed by " + nextLeg + " when reflectBranch=" + reflectBranch + " > disconBranch=" + disconBranch + ", likely need K, I or J leg , prev=" + prevLeg);
            }
            if (reflectBranch == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (this.DEBUG) {
                    System.out.println("Attempt to underside reflect from center of earth: " + nextLeg);
                }
                return PhaseInteraction.FAIL;
            }
            this.addToBranch(this.tMod, this.currBranch, reflectBranch, isPWave, nextIsPWave, endAction, currLeg);
        } else {
            throw new TauModelException("Should not allow " + currLeg + " followed by " + nextLeg);
        }
        return endAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PhaseInteraction currLegIs_K(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (!currLeg.equals("K")) throw new TauModelException(this.getName() + " Phase not recognized (9): " + currLeg + " followed by " + nextLeg);
        if (this.tMod.getCmbBranch() == this.tMod.tauBranches[0].length) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.equals("P") || nextLeg.equals("S") || nextLeg.equals("p") || nextLeg.equals("s") || nextLeg.equals("Pdiff") || nextLeg.equals("Sdiff")) {
            if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("Ped") || prevLeg.equals("Sed") || prevLeg.equals("Pdiff") || prevLeg.equals("Sdiff") || prevLeg.equals("K") || prevLeg.equals("k") || prevLeg.startsWith("^") || prevLeg.equals("START")) {
                endAction = PhaseInteraction.TURN;
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, isPWave, endAction, currLeg);
            }
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch(), isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.equals("K") || nextLeg.equals("Ked") || nextLeg.equals("END")) {
            if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("K")) {
                endAction = PhaseInteraction.TURN;
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, isPWave, endAction, currLeg);
            }
            if (nextLeg.equals("END")) {
                endAction = PhaseInteraction.END;
                this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            } else {
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getCmbBranch(), isPWave, nextIsPWave, endAction, currLeg);
            }
            return endAction;
        } else if (nextLeg.startsWith("I") || nextLeg.startsWith("J")) {
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.equals("i")) {
            if (this.tMod.getIocbBranch() == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println("Attempt to reflect from center of earth: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            endAction = PhaseInteraction.REFLECT_TOPSIDE;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            endAction = nextLeg.startsWith("V") ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg.substring(1));
            if (this.currBranch > disconBranch - 1) throw new TauModelException(this.getName() + " Phase not recognized (4): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.startsWith("^")) {
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (disconBranch < this.tMod.getCmbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (5a): " + currLeg + " followed by " + nextLeg + " when disconBranch=" + disconBranch + " < cmbBranch=" + this.tMod.getCmbBranch() + ", likely need P or S leg , prev=" + prevLeg);
            }
            if (disconBranch >= this.tMod.getIocbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (5b): " + currLeg + " followed by " + nextLeg + " when disconBranch=" + disconBranch + " > iocbBranch=" + this.tMod.getIocbBranch() + ", likely need Ior J leg , prev=" + prevLeg);
            }
            if (disconBranch == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println("Attempt to underside reflect from center of earth: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            if (prevLeg.startsWith("I") || prevLeg.startsWith("J") || prevLeg.equals("i") || prevLeg.equals("j") || prevLeg.equals("k")) {
                this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            } else if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.startsWith("^") || prevLeg.equals("K") || prevLeg.equals("START")) {
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, isPWave, PhaseInteraction.TURN, currLeg);
                this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            } else {
                if (!prevLeg.startsWith("v") && !prevLeg.startsWith("V")) throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch + " , prev=" + prevLeg);
                String prevDepthString = prevLeg.substring(1);
                int prevdisconBranch = LegPuller.closestBranchToDepth(this.tMod, prevDepthString);
                if (disconBranch < prevdisconBranch) {
                    this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                    return endAction;
                } else {
                    this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, isPWave, PhaseInteraction.TURN, currLeg);
                    this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
                }
            }
            return endAction;
        } else if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = nextLeg.substring(0, nextLeg.length() - 1);
            double headDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (disconBranch < this.tMod.cmbBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when cmbBranch < disconBranch=" + disconBranch + " , prev=" + prevLeg);
            }
            endAction = PhaseInteraction.HEAD;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else {
            if (!nextLeg.endsWith("diff") || nextLeg.length() <= 4) throw new TauModelException(this.getName() + " Phase not recognized (9b): " + currLeg + " followed by " + nextLeg);
            String numString = nextLeg.substring(0, nextLeg.length() - 4);
            double diffDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (disconBranch < this.tMod.cmbBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when cmbBranch < disconBranch=" + disconBranch + " , prev=" + prevLeg);
            }
            endAction = PhaseInteraction.DIFFRACT;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        }
        return endAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PhaseInteraction currLegIs_Ked(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (!currLeg.equals("Ked")) throw new TauModelException(this.getName() + " Phase not recognized (9): " + currLeg + " followed by " + nextLeg);
        if (this.tMod.getCmbBranch() == this.tMod.tauBranches[0].length) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        if (nextLeg.equals("END")) {
            endAction = PhaseInteraction.END_DOWN;
            this.addToBranch(this.tMod, this.currBranch, this.downgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.equals("I") || nextLeg.equals("J")) {
            endAction = PhaseInteraction.TRANSDOWN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.equals("i")) {
            if (this.tMod.getIocbBranch() == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println("Attempt to reflect from center of earth: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            endAction = PhaseInteraction.REFLECT_TOPSIDE;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch() - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            endAction = nextLeg.startsWith("V") ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg.substring(1));
            if (this.currBranch > disconBranch - 1) throw new TauModelException(this.getName() + " Phase not recognized (4): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = nextLeg.substring(0, nextLeg.length() - 1);
            double headDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (disconBranch < this.tMod.cmbBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when cmbBranch < disconBranch=" + disconBranch + " , prev=" + prevLeg);
            }
            endAction = PhaseInteraction.HEAD;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else {
            if (!nextLeg.endsWith("diff") || nextLeg.length() <= 4) throw new TauModelException(this.getName() + " Phase not recognized (9b): " + currLeg + " followed by " + nextLeg);
            String numString = nextLeg.substring(0, nextLeg.length() - 4);
            double diffDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (disconBranch < this.tMod.cmbBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when cmbBranch < disconBranch=" + disconBranch + " , prev=" + prevLeg);
            }
            endAction = PhaseInteraction.DIFFRACT;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        }
        return endAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PhaseInteraction currLegIs_k(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            throw new TauModelException(this.getName() + " k must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + currLeg + " nextLeg=" + nextLeg);
        }
        if (nextLeg.startsWith("^")) {
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (disconBranch < this.tMod.getCmbBranch() || disconBranch >= this.tMod.getIocbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + ", discon not in outer core.");
            }
            if (this.currBranch < disconBranch) throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.equals("p") || nextLeg.equals("s") || nextLeg.equals("c") || nextLeg.equals("K") || nextLeg.equals("Ked") || nextLeg.equals("END")) {
            int disconBranch;
            if (nextLeg.equals("END")) {
                disconBranch = this.upgoingRecBranch;
                if (this.currBranch < this.upgoingRecBranch) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return PhaseInteraction.FAIL;
                    System.out.println(this.name + " (currBranch >= receiverBranch() " + this.currBranch + " " + this.upgoingRecBranch + " so there cannot be a " + currLeg + " phase for this sourceDepth, receiverDepth and/or path.");
                    return PhaseInteraction.FAIL;
                }
            } else {
                disconBranch = this.tMod.getCmbBranch();
            }
            if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.startsWith("p") || nextLeg.startsWith("s") || nextLeg.equals("c")) {
                endAction = PhaseInteraction.TRANSUP;
            } else if (nextLeg.equals("END")) {
                endAction = PhaseInteraction.END;
            } else {
                if (!nextLeg.equals("K") && !nextLeg.equals("Ked")) throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg);
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            }
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else {
            if (nextLeg.equals("c")) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", k must be upgoing in outer core and so cannot hit cmb from above.");
            }
            if (nextLeg.equals("i") || nextLeg.equals("I") || nextLeg.equals("J") || nextLeg.equals("j")) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", k must be upgoing in outer core and so cannot hit inner core.");
            }
            if (nextLeg.equals("k")) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", k must be upgoing in outer core and so repeat.");
            }
            if (!this.isLegDepth(currLeg)) throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg);
            double nextLegDepth = Double.parseDouble(currLeg);
            if (nextLegDepth >= this.tMod.getCmbDepth()) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", p and s must be upgoing in mantle and so cannot hit core.");
            }
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg);
            if (disconBranch < this.tMod.getCmbBranch() || disconBranch >= this.tMod.getIocbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + ", discon not in outer core.");
            }
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
        }
        return endAction;
    }

    boolean checkDegenerateInnerCore(String prevLeg, String currLeg, String nextLeg, boolean isPWave, boolean isPWavePrev, int legNum) throws TauModelException {
        if (this.tMod.getIocbDepth() == this.tMod.getRadiusOfEarth()) {
            this.maxRayParam = -1.0;
            if (this.DEBUG) {
                System.out.println("Cannot have I or J phase " + currLeg + " within phase " + this.name + " for this model as it has no inner core, iocb depth = radius of Earth.");
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    PhaseInteraction currLegIs_I_J(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (!(nextLeg.startsWith("v") || nextLeg.startsWith("V") || this.prevEndAction != PhaseInteraction.START && this.prevEndAction != PhaseInteraction.TRANSDOWN && this.prevEndAction != PhaseInteraction.REFLECT_UNDERSIDE && this.prevEndAction != PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL)) {
            endAction = PhaseInteraction.TURN;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getNumBranches() - 1, isPWave, isPWave, endAction, currLeg);
        }
        if (nextLeg.equals("END")) {
            endAction = PhaseInteraction.END;
            this.addToBranch(this.tMod, this.currBranch, this.upgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("I") || nextLeg.equals("J")) {
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch(), isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equals("K") || nextLeg.equals("k")) {
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch(), isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            endAction = nextLeg.startsWith("V") ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg.substring(1));
            if (this.currBranch > disconBranch - 1) throw new TauModelException(this.getName() + " Phase not recognized (4): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.startsWith("^")) {
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (disconBranch < this.tMod.getIocbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (6a): " + currLeg + " followed by " + nextLeg + " when disconBranch=" + disconBranch + " < iocbBranch=" + this.tMod.getIocbBranch() + ", likely need K leg , prev=" + prevLeg);
            }
            if (disconBranch == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return PhaseInteraction.FAIL;
                System.out.println("Attempt to underside reflect from center of earth: " + nextLeg);
                return PhaseInteraction.FAIL;
            }
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (nextLeg.equalsIgnoreCase("P") || nextLeg.equalsIgnoreCase("S")) {
            if (this.tMod.getCmbDepth() == this.tMod.getIocbDepth()) {
                endAction = PhaseInteraction.TRANSUP;
                this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch(), isPWave, nextIsPWave, endAction, currLeg);
                return endAction;
            }
            this.maxRayParam = -1.0;
            endAction = PhaseInteraction.FAIL;
            throw new TauModelException(this.getName() + " Cannot have I or J phase " + currLeg + " followed by " + nextLeg + " within phase " + this.name + " for this model as it has an outer core so need K,k in between.");
        }
        if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = nextLeg.substring(0, nextLeg.length() - 1);
            double headDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (disconBranch < this.tMod.iocbBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when iocbBranch < disconBranch=" + disconBranch + " , prev=" + prevLeg);
            }
            endAction = PhaseInteraction.HEAD;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        }
        if (!nextLeg.endsWith("diff")) throw new TauModelException(this.getName() + " Phase not recognized (6a): " + currLeg + " followed by " + nextLeg);
        if (nextLeg.length() <= 4) throw new TauModelException(this.getName() + " Phase not recognized (6a): " + currLeg + " followed by " + nextLeg);
        String numString = nextLeg.substring(0, nextLeg.length() - 4);
        double diffDepth = Double.parseDouble(numString);
        int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
        if (disconBranch < this.tMod.iocbBranch) {
            throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when iocbBranch=" + this.tMod.getIocbBranch() + " < disconBranch=" + disconBranch + " , prev=" + prevLeg);
        }
        endAction = PhaseInteraction.DIFFRACT;
        this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        return endAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PhaseInteraction currLegIs_Ied_Jed(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (!currLeg.equals("Ied") && !currLeg.equals("Jed")) throw new TauModelException(this.getName() + " Phase not recognized (9): " + currLeg + " followed by " + nextLeg);
        if (nextLeg.equals("END")) {
            endAction = PhaseInteraction.END_DOWN;
            this.addToBranch(this.tMod, this.currBranch, this.downgoingRecBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            endAction = nextLeg.startsWith("V") ? PhaseInteraction.REFLECT_TOPSIDE_CRITICAL : PhaseInteraction.REFLECT_TOPSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg.substring(1));
            if (this.currBranch > disconBranch - 1) throw new TauModelException(this.getName() + " Phase not recognized (4): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.endsWith("n") && nextLeg.length() > 1) {
            String numString = nextLeg.substring(0, nextLeg.length() - 1);
            double headDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (disconBranch < this.tMod.iocbBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when iocbBranch < disconBranch=" + disconBranch + " , prev=" + prevLeg);
            }
            endAction = PhaseInteraction.HEAD;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else {
            if (!nextLeg.endsWith("diff") || nextLeg.length() <= 4) throw new TauModelException(this.getName() + " Phase not recognized (9b): " + currLeg + " followed by " + nextLeg);
            String numString = nextLeg.substring(0, nextLeg.length() - 4);
            double diffDepth = Double.parseDouble(numString);
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
            if (disconBranch < this.tMod.iocbBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5): " + currLeg + " followed by " + nextLeg + " when iocbBranch < disconBranch=" + disconBranch + " , prev=" + prevLeg);
            }
            endAction = PhaseInteraction.DIFFRACT;
            this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, isPWave, nextIsPWave, endAction, currLeg);
        }
        return endAction;
    }

    PhaseInteraction currLegIs_I_Jdiff(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        int depthIdx;
        if (this.tMod.getIocbBranch() == this.tMod.tauBranches[0].length) {
            this.maxRayParam = -1.0;
            return PhaseInteraction.FAIL;
        }
        int disconBranch = this.tMod.getIocbBranch();
        if (currLeg.endsWith("diff") && currLeg.length() > 5) {
            depthIdx = 0;
            if (currLeg.startsWith("I") || currLeg.startsWith("J")) {
                depthIdx = 1;
            }
        } else {
            throw new TauModelException("Not I or Jdiff " + currLeg + " in currLegIs_I_Jdiff " + this.getName());
        }
        String numString = currLeg.substring(depthIdx, currLeg.length() - 4);
        double diffDepth = Double.parseDouble(numString);
        disconBranch = LegPuller.closestBranchToDepth(this.tMod, numString);
        PhaseInteraction endAction = PhaseInteraction.DIFFRACT;
        this.addToBranch(this.tMod, this.currBranch, disconBranch - 1, true, nextIsPWave, endAction, currLeg);
        if (nextLeg.equals("I") || nextLeg.equals("J")) {
            this.addFlatBranch(this.tMod, disconBranch - 1, isPWave, endAction, PhaseInteraction.TRANSDOWN, currLeg);
        } else {
            this.addFlatBranch(this.tMod, disconBranch - 1, isPWave, endAction, PhaseInteraction.TURN, currLeg);
        }
        if (nextLeg.startsWith("K") || nextLeg.equals("k")) {
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch(), true, nextIsPWave, endAction, currLeg);
        } else if (nextLeg.equals("I") || nextLeg.equals("I") || (nextLeg.startsWith("I") || nextLeg.startsWith("J")) && nextLeg.endsWith("diff")) {
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            this.addToBranch(this.tMod, this.currBranch, this.tMod.getIocbBranch(), true, nextIsPWave, endAction, currLeg);
        } else if (nextLeg.startsWith("^")) {
            String reflectdepthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int reflectBranch = LegPuller.closestBranchToDepth(this.tMod, reflectdepthString);
            if (reflectBranch < this.tMod.getIocbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (5a): " + currLeg + " followed by " + nextLeg + " when reflectBranch=" + reflectBranch + " < iocbBranch=" + this.tMod.getIocbBranch() + ", likely need P or S leg , prev=" + prevLeg);
            }
            if (reflectBranch >= disconBranch) {
                throw new TauModelException(this.getName() + " Phase not recognized (5b): " + currLeg + " followed by " + nextLeg + " when reflectBranch=" + reflectBranch + " > disconBranch=" + disconBranch + ", likely need K, I or J leg , prev=" + prevLeg);
            }
            if (reflectBranch == this.tMod.getNumBranches()) {
                this.maxRayParam = -1.0;
                if (this.DEBUG) {
                    System.out.println("Attempt to underside reflect from center of earth: " + nextLeg);
                }
                return PhaseInteraction.FAIL;
            }
            this.addToBranch(this.tMod, this.currBranch, reflectBranch, isPWave, nextIsPWave, endAction, currLeg);
        } else {
            throw new TauModelException("Should not allow " + currLeg + " followed by " + nextLeg);
        }
        return endAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PhaseInteraction currLegIs_y_j(String prevLeg, String currLeg, String nextLeg, boolean prevIsPWave, boolean isPWave, boolean nextIsPWave, int legNum) throws TauModelException {
        PhaseInteraction endAction;
        if (nextLeg.startsWith("v") || nextLeg.startsWith("V")) {
            throw new TauModelException(this.getName() + " y,j must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + currLeg + " nextLeg=" + nextLeg);
        }
        if (nextLeg.startsWith("^")) {
            String depthString = nextLeg.substring(1);
            endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, depthString);
            if (disconBranch < this.tMod.getIocbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + ", discon not in inner core.");
            }
            if (this.currBranch < disconBranch) throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.equals("p") || nextLeg.equals("s") || nextLeg.equals("c") || nextLeg.equals("K") || nextLeg.equals("Ked") || nextLeg.equals("k") || nextLeg.equals("Ked") || nextLeg.equals("I") || nextLeg.equals("Ied") || nextLeg.equals("J") || nextLeg.equals("Jed") || nextLeg.equals("END")) {
            int disconBranch;
            if (nextLeg.equals("END")) {
                disconBranch = this.upgoingRecBranch;
                if (this.currBranch < this.upgoingRecBranch) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return PhaseInteraction.FAIL;
                    System.out.println(this.name + " (currBranch >= receiverBranch() " + this.currBranch + " " + this.upgoingRecBranch + " so there cannot be a " + currLeg + " phase for this sourceDepth, receiverDepth and/or path.");
                    return PhaseInteraction.FAIL;
                }
            } else {
                disconBranch = this.tMod.getIocbBranch();
            }
            if (nextLeg.startsWith("K") || nextLeg.startsWith("k")) {
                endAction = PhaseInteraction.TRANSUP;
            } else if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.startsWith("p") || nextLeg.startsWith("s") || nextLeg.equals("c")) {
                if (this.tMod.getCmbBranch() != this.tMod.getIocbBranch()) throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", outer core leg would be K or k");
                endAction = PhaseInteraction.TRANSUP;
            } else if (nextLeg.equals("END")) {
                endAction = PhaseInteraction.END;
            } else {
                if (!nextLeg.equals("I") && !nextLeg.equals("Ied") && !nextLeg.equals("J") && !nextLeg.equals("Jed")) throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg);
                endAction = PhaseInteraction.REFLECT_UNDERSIDE;
            }
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
            return endAction;
        } else {
            if (nextLeg.equals("i")) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", y,j must be upgoing in inner core and so cannot hit iomb from above.");
            }
            if (nextLeg.equals("I") || nextLeg.equals("J")) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", y,j must be upgoing in outer core and so cannot hit inner core.");
            }
            if (nextLeg.equals("y") || nextLeg.equals("j")) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", y,j must be upgoing in inner core and so cannot repeat.");
            }
            if (!this.isLegDepth(currLeg)) throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg);
            double nextLegDepth = Double.parseDouble(currLeg);
            if (nextLegDepth >= this.tMod.getCmbDepth()) {
                throw new TauModelException(this.getName() + " Phase not recognized (3): " + currLeg + " followed by " + nextLeg + ", y and j must be upgoing in inner core and so cannot hit depth " + nextLegDepth);
            }
            int disconBranch = LegPuller.closestBranchToDepth(this.tMod, nextLeg);
            if (disconBranch < this.tMod.getIocbBranch()) {
                throw new TauModelException(this.getName() + " Phase not recognized (2): " + currLeg + " followed by " + nextLeg + ", discon not in inner core.");
            }
            endAction = PhaseInteraction.TRANSUP;
            this.addToBranch(this.tMod, this.currBranch, disconBranch, isPWave, nextIsPWave, endAction, currLeg);
        }
        return endAction;
    }

    protected SeismicPhaseSegment addToBranch(TauModel tMod, int startBranch, int endBranch, boolean isPWave, boolean nextIsPWave, PhaseInteraction endAction, String currLeg) throws TauModelException {
        SlownessLayer sLayer;
        boolean isDownGoing;
        int endOffset;
        if (startBranch < 0 || startBranch > tMod.getNumBranches()) {
            throw new IllegalArgumentException(this.getName() + ": start branch outside range: (0-" + tMod.getNumBranches() + ") " + startBranch);
        }
        if (endBranch < 0 || endBranch > tMod.getNumBranches()) {
            throw new IllegalArgumentException(this.getName() + ": end branch outside range: " + endBranch);
        }
        if (endAction == PhaseInteraction.TRANSUP && endBranch == 0) {
            throw new IllegalArgumentException(this.getName() + ": cannot TRANSUP with end branch zero: " + endBranch);
        }
        if (!isPWave && tMod.getSlownessModel().depthInFluid(tMod.getTauBranch(startBranch, isPWave).getTopDepth())) {
            throw new TauModelException("Attempt to have S wave in fluid layer in " + this.name + " " + startBranch + " to " + endBranch + " " + SeismicPhaseFactory.endActionString(endAction));
        }
        if (this.DEBUG) {
            System.out.println("before addToBranch: minRP=" + this.minRayParam + "  maxRP=" + this.maxRayParam);
            System.out.println("addToBranch( start=" + startBranch + " end=" + endBranch + " endAction=" + SeismicPhaseFactory.endActionString(endAction) + " " + currLeg + ") isP:" + (isPWave ? "P" : "S"));
        }
        if (endAction == PhaseInteraction.TURN) {
            if (isPWave != nextIsPWave) {
                throw new TauModelException(this.name + " phase conversion not allowed for TURN");
            }
            endOffset = 0;
            isDownGoing = true;
            this.minRayParam = Math.max(this.minRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
            for (int bNum = endBranch; bNum >= startBranch && tMod.getSlownessModel().depthInHighSlowness(tMod.getTauBranch(bNum, isPWave).getTopDepth(), this.minRayParam, isPWave) && (bNum + 1 >= tMod.getNumBranches() || this.minRayParam <= tMod.getTauBranch(bNum + 1, isPWave).getMaxRayParam()); --bNum) {
                if (this.DEBUG) {
                    System.out.println("Warn, ray cannot turn in layer " + bNum + " due to high slowness layer at bottom depth " + tMod.getTauBranch(bNum, isPWave).getBotDepth());
                }
                endBranch = bNum - 1;
            }
        } else if (endAction == PhaseInteraction.REFLECT_UNDERSIDE || endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
            endOffset = 0;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
            if (isPWave != nextIsPWave) {
                this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, nextIsPWave).getMaxRayParam());
            }
            if (endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                try {
                    TauBranch endTauBranch = tMod.getTauBranch(endBranch, isPWave);
                    int slayAbove = tMod.getSlownessModel().layerNumberAbove(endTauBranch.getTopDepth(), isPWave);
                    sLayer = tMod.getSlownessModel().getSlownessLayer(slayAbove, isPWave);
                    this.minRayParam = Math.max(this.minRayParam, sLayer.getBotP());
                }
                catch (NoSuchLayerException e) {
                    throw new TauModelException(e);
                }
            }
        } else if (endAction == PhaseInteraction.END) {
            endOffset = 0;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
        } else if (endAction == PhaseInteraction.END_DOWN) {
            endOffset = 0;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
        } else if (endAction == PhaseInteraction.REFLECT_TOPSIDE || endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
            endOffset = 0;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
            if (isPWave != nextIsPWave) {
                this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, nextIsPWave).getMinTurnRayParam());
            }
            if (endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
                try {
                    TauBranch endTauBranch = tMod.getTauBranch(endBranch, isPWave);
                    int slayBelow = tMod.getSlownessModel().layerNumberBelow(endTauBranch.getBotDepth(), isPWave);
                    sLayer = tMod.getSlownessModel().getSlownessLayer(slayBelow, isPWave);
                    this.minRayParam = Math.max(this.minRayParam, sLayer.getTopP());
                }
                catch (NoSuchLayerException e) {
                    throw new TauModelException(e);
                }
            }
        } else if (endAction == PhaseInteraction.TRANSUP) {
            endOffset = -1;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch - 1, nextIsPWave).getMinTurnRayParam());
        } else if (endAction == PhaseInteraction.TRANSDOWN) {
            endOffset = 1;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
            if (endBranch == tMod.getNumBranches() - 1) {
                throw new TauModelException(this.name + " Cannot TRANSDOWN if endBranch: " + endBranch + " == numBranchs: " + tMod.getNumBranches());
            }
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch + 1, nextIsPWave).getMaxRayParam());
        } else if (endAction == PhaseInteraction.HEAD) {
            endOffset = 0;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch + 1, nextIsPWave).getMaxRayParam());
            this.minRayParam = Math.max(this.minRayParam, this.maxRayParam);
        } else if (endAction == PhaseInteraction.DIFFRACT) {
            endOffset = 0;
            isDownGoing = this.prevEndAction != PhaseInteraction.TRANSUP;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
            if (isPWave != nextIsPWave) {
                this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, nextIsPWave).getMinTurnRayParam());
            }
            this.minRayParam = Math.max(this.minRayParam, this.maxRayParam);
            double depth = tMod.getTauBranch(endBranch, isPWave).getBotDepth();
            if (depth == tMod.radiusOfEarth || tMod.getSlownessModel().depthInHighSlowness(depth - 1.0E-10, this.minRayParam, isPWave)) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
            }
        } else {
            throw new TauModelException(this.getName() + ": Illegal endAction: endAction=" + (Object)((Object)endAction));
        }
        SeismicPhaseSegment segment = new SeismicPhaseSegment(tMod, startBranch, endBranch, isPWave, endAction, isDownGoing, currLeg);
        if (this.segmentList.size() == 0) {
            segment.prevEndAction = PhaseInteraction.START;
        } else {
            SeismicPhaseSegment prevSegment = this.segmentList.get(this.segmentList.size() - 1);
            segment.prevEndAction = prevSegment.endAction;
            if (prevSegment.isFlat) {
                if (isDownGoing) {
                    if (prevSegment.endsAtTop() && prevSegment.endBranch != startBranch) {
                        throw new TauModelException(this.getName() + ": Flat Segment is ends at top, but start is not current branch: " + currLeg);
                    }
                    if (!prevSegment.endsAtTop() && prevSegment.endBranch != startBranch - 1) {
                        throw new TauModelException(this.getName() + ": Flat Segment is ends at bottom, but start is not next deeper branch: " + currLeg);
                    }
                } else {
                    if (prevSegment.endsAtTop() && prevSegment.endBranch != startBranch + 1) {
                        System.out.println(prevSegment.toString());
                        throw new TauModelException(this.getName() + ": Flat Segment is ends at top, but start is not next shallower branch: " + currLeg + " " + prevSegment.endBranch + "!= " + startBranch + "+1");
                    }
                    if (!prevSegment.endsAtTop() && prevSegment.endBranch != startBranch) {
                        throw new TauModelException(this.getName() + ": Flat Segment is ends at bottom, but start is not current branch: " + currLeg + " " + prevSegment.endBranch + "!= " + startBranch);
                    }
                }
            } else if (isDownGoing) {
                if (prevSegment.endBranch > startBranch) {
                    throw new TauModelException(this.getName() + ": Segment is downgoing, but we are already below the start: " + currLeg);
                }
                if (prevSegment.endAction == PhaseInteraction.REFLECT_TOPSIDE || prevSegment.endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
                    throw new TauModelException(this.getName() + ": Segment is downgoing, but previous action was to reflect up: " + currLeg);
                }
                if (prevSegment.endAction == PhaseInteraction.TURN) {
                    throw new TauModelException(this.getName() + ": Segment is downgoing, but previous action was to turn: " + currLeg);
                }
                if (prevSegment.endAction == PhaseInteraction.TRANSUP) {
                    throw new TauModelException(this.getName() + ": Segment is downgoing, but previous action was to transmit up: " + currLeg);
                }
                if (prevSegment.endBranch == startBranch && !prevSegment.isDownGoing && prevSegment.endAction != PhaseInteraction.REFLECT_UNDERSIDE && prevSegment.endAction != PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                    throw new TauModelException(this.getName() + ": Segment " + currLeg + " is downgoing, but previous action was not to reflect underside: " + currLeg + " " + SeismicPhaseFactory.endActionString(prevSegment.endAction));
                }
            } else {
                if (prevSegment.endBranch < startBranch) {
                    throw new TauModelException(this.getName() + ": Segment is upgoing, but we are already above the start: " + currLeg);
                }
                if (prevSegment.endAction == PhaseInteraction.REFLECT_UNDERSIDE || prevSegment.endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
                    throw new TauModelException(this.getName() + ": Segment is upgoing, but previous action was to underside reflect down: " + currLeg);
                }
                if (prevSegment.endAction == PhaseInteraction.TRANSDOWN) {
                    throw new TauModelException(this.getName() + ": Segment is upgoing, but previous action was  to trans down: " + currLeg);
                }
                if (prevSegment.endBranch == startBranch && prevSegment.isDownGoing && prevSegment.endAction != PhaseInteraction.TURN && prevSegment.endAction != PhaseInteraction.DIFFRACT && prevSegment.endAction != PhaseInteraction.HEAD && prevSegment.endAction != PhaseInteraction.REFLECT_TOPSIDE && prevSegment.endAction != PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
                    throw new TauModelException(this.getName() + ": Segment is upgoing, but previous action was not to reflect topside: " + currLeg + " " + SeismicPhaseFactory.endActionString(prevSegment.endAction));
                }
            }
        }
        if (!(isPWave || currLeg.startsWith("K") || currLeg.equals("k"))) {
            for (int i = Math.min(startBranch, endBranch); i <= Math.max(startBranch, endBranch); ++i) {
                TauBranch tb = tMod.getTauBranch(i, isPWave);
                for (DepthRange fluidDR : tMod.getSlownessModel().fluidLayerDepths) {
                    if (!(tb.getTopDepth() >= fluidDR.topDepth && tb.getTopDepth() < fluidDR.botDepth) && (!(tb.getBotDepth() > fluidDR.topDepth) || !(tb.getBotDepth() <= fluidDR.botDepth))) continue;
                    throw new TauModelException("S wave branch in " + this.getName() + " is in fluid: " + tb + " " + fluidDR);
                }
            }
        }
        this.segmentList.add(segment);
        if (isDownGoing) {
            int i;
            if (startBranch > endBranch) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
                throw new TauModelException("can't be downgoing as we are already below: " + startBranch + " " + endBranch + " in " + this.getName());
            }
            for (i = startBranch; i <= endBranch; ++i) {
                this.branchSeq.add(i);
                this.downGoing.add(isDownGoing);
                this.waveType.add(isPWave);
                this.legAction.add(endAction);
            }
            if (this.DEBUG) {
                for (i = startBranch; i <= endBranch; ++i) {
                    System.out.println("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + SeismicPhaseFactory.endActionString(endAction));
                }
            }
        } else {
            int i;
            if (startBranch < endBranch) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
                throw new TauModelException("can't be upgoing as we are already above: " + startBranch + " " + endBranch + " " + currLeg + " in " + this.getName());
            }
            for (i = startBranch; i >= endBranch; --i) {
                this.branchSeq.add(i);
                this.downGoing.add(isDownGoing);
                this.waveType.add(isPWave);
                this.legAction.add(endAction);
            }
            if (this.DEBUG) {
                for (i = startBranch; i >= endBranch; --i) {
                    System.out.println("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + SeismicPhaseFactory.endActionString(endAction));
                }
            }
        }
        this.currBranch = endBranch + endOffset;
        if (this.DEBUG) {
            System.out.println("after addToBranch: minRP=" + this.minRayParam + "  maxRP=" + this.maxRayParam + " endOffset=" + endOffset + " isDownGoing=" + isDownGoing);
        }
        return segment;
    }

    protected SeismicPhaseSegment addFlatBranch(TauModel tMod, int branch, boolean isPWave, PhaseInteraction prevEndAction, PhaseInteraction endAction, String currLeg) throws TauModelException {
        SeismicPhaseSegment flatSegment;
        if (this.DEBUG) {
            System.out.println("before addFlatBranch: minRP=" + this.minRayParam + "  maxRP=" + this.maxRayParam);
            System.out.println("addFlatBranch( " + branch + " endAction=" + SeismicPhaseFactory.endActionString(endAction) + " " + currLeg + ") isP:" + (isPWave ? "P" : "S"));
        }
        boolean flatIsDownGoing = false;
        if (prevEndAction == PhaseInteraction.HEAD) {
            flatSegment = new SeismicPhaseSegment(tMod, branch, branch, isPWave, endAction, flatIsDownGoing, currLeg);
            double headRP = tMod.getTauBranch(branch, isPWave).getMaxRayParam();
            if (this.minRayParam > headRP || this.maxRayParam < headRP) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
            } else {
                this.minRayParam = headRP;
                this.maxRayParam = headRP;
            }
        } else if (prevEndAction == PhaseInteraction.DIFFRACT) {
            flatSegment = new SeismicPhaseSegment(tMod, branch, branch, isPWave, endAction, flatIsDownGoing, currLeg);
            double diffRP = tMod.getTauBranch(branch, isPWave).getMinTurnRayParam();
            if (this.minRayParam > diffRP || this.maxRayParam < diffRP) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
            } else {
                this.minRayParam = diffRP;
                this.maxRayParam = diffRP;
            }
        } else if (prevEndAction == PhaseInteraction.KMPS && currLeg.endsWith("kmps")) {
            flatSegment = new SeismicPhaseSegment(tMod, branch, branch, isPWave, endAction, flatIsDownGoing, currLeg);
            double velocity = Double.valueOf(currLeg.substring(0, currLeg.length() - 4));
            this.maxRayParam = this.minRayParam = tMod.radiusOfEarth / velocity;
        } else {
            throw new TauModelException("Cannot addFlatBranch for prevEndAction: " + (Object)((Object)prevEndAction) + " for " + currLeg);
        }
        flatSegment.isFlat = true;
        flatSegment.prevEndAction = prevEndAction;
        this.segmentList.add(flatSegment);
        this.headOrDiffractSeq.add(this.branchSeq.size() - 1);
        return flatSegment;
    }

    protected static int[][] calcBranchMultiplier(TauModel tMod, List<Integer> branchSeq, List<Boolean> waveType) {
        int i;
        int[][] timesBranches = new int[2][tMod.getNumBranches()];
        for (i = 0; i < timesBranches[0].length; ++i) {
            timesBranches[0][i] = 0;
            timesBranches[1][i] = 0;
        }
        for (i = 0; i < branchSeq.size(); ++i) {
            if (waveType.get(i).booleanValue()) {
                int[] nArray = timesBranches[0];
                int n = branchSeq.get(i);
                nArray[n] = nArray[n] + 1;
                continue;
            }
            int[] nArray = timesBranches[1];
            int n = branchSeq.get(i);
            nArray[n] = nArray[n] + 1;
        }
        return timesBranches;
    }

    protected void sumBranches(TauModel tMod) throws TauModelException {
        if (this.maxRayParam < 0.0 || this.minRayParam > this.maxRayParam) {
            this.rayParams = new double[0];
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            this.dist = new double[0];
            this.time = new double[0];
            this.maxDistance = -1.0;
            return;
        }
        if (this.name.endsWith("kmps")) {
            try {
                this.dist = new double[2];
                this.time = new double[2];
                this.rayParams = new double[2];
                this.dist[0] = 0.0;
                this.time[0] = 0.0;
                double velocity = Double.valueOf(this.name.substring(0, this.name.length() - 4));
                this.rayParams[0] = tMod.radiusOfEarth / velocity;
                this.dist[1] = SeismicPhaseFactory.getMaxKmpsLaps() * 2.0 * Math.PI;
                this.time[1] = SeismicPhaseFactory.getMaxKmpsLaps() * 2.0 * Math.PI * tMod.radiusOfEarth / velocity;
                this.rayParams[1] = this.rayParams[0];
                this.minDistance = this.dist[0];
                this.maxDistance = this.dist[1];
                this.minRayParam = this.rayParams[0];
                this.maxRayParam = this.rayParams[0];
                this.downGoing.add(true);
                return;
            }
            catch (NumberFormatException e) {
                throw new TauModelException(this.getName() + " Illegal surface wave velocity " + this.name.substring(0, this.name.length() - 4), e);
            }
        }
        for (int i = 0; i < tMod.rayParams.length; ++i) {
            if (tMod.rayParams[i] >= this.minRayParam) {
                this.minRayParamIndex = i;
            }
            if (!(tMod.rayParams[i] >= this.maxRayParam)) continue;
            this.maxRayParamIndex = i;
        }
        if (this.maxRayParamIndex < 0) {
            throw new RuntimeException(this.getName() + " Should not happen, did not find max ray param" + this.maxRayParam);
        }
        if (this.minRayParamIndex < 0) {
            throw new RuntimeException(this.getName() + " Should not happen, did not find min ray param" + this.minRayParam);
        }
        if (this.maxRayParamIndex == 0 && this.minRayParamIndex == tMod.rayParams.length - 1) {
            this.rayParams = new double[tMod.rayParams.length];
            System.arraycopy(tMod.rayParams, 0, this.rayParams, 0, tMod.rayParams.length);
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            this.rayParams = new double[2];
            this.rayParams[0] = this.minRayParam;
            this.rayParams[1] = this.minRayParam;
        } else {
            if (this.DEBUG) {
                System.out.println("SumBranches() maxRayParamIndex=" + this.maxRayParamIndex + " minRayParamIndex=" + this.minRayParamIndex + " tMod.rayParams.length=" + tMod.rayParams.length + " tMod.rayParams[0]=" + tMod.rayParams[0] + "\n tMod.rayParams[" + this.minRayParamIndex + "]=" + tMod.rayParams[this.minRayParamIndex] + "\n tMod.rayParams[" + this.maxRayParamIndex + "]=" + tMod.rayParams[this.maxRayParamIndex] + " maxRayParam=" + this.maxRayParam);
            }
            this.rayParams = new double[this.minRayParamIndex - this.maxRayParamIndex + 1];
            System.arraycopy(tMod.rayParams, this.maxRayParamIndex, this.rayParams, 0, this.minRayParamIndex - this.maxRayParamIndex + 1);
        }
        this.dist = new double[this.rayParams.length];
        this.time = new double[this.rayParams.length];
        int[][] timesBranches = SeismicPhaseFactory.calcBranchMultiplier(tMod, this.branchSeq, this.waveType);
        for (int j = 0; j < tMod.getNumBranches(); ++j) {
            int i;
            if (timesBranches[0][j] != 0) {
                for (i = this.maxRayParamIndex; i < this.minRayParamIndex + 1; ++i) {
                    int n = i - this.maxRayParamIndex;
                    this.dist[n] = this.dist[n] + (double)timesBranches[0][j] * tMod.getTauBranch(j, true).getDist(i);
                    int n2 = i - this.maxRayParamIndex;
                    this.time[n2] = this.time[n2] + (double)timesBranches[0][j] * tMod.getTauBranch((int)j, (boolean)true).time[i];
                }
            }
            if (timesBranches[1][j] == 0) continue;
            for (i = this.maxRayParamIndex; i < this.minRayParamIndex + 1; ++i) {
                int n = i - this.maxRayParamIndex;
                this.dist[n] = this.dist[n] + (double)timesBranches[1][j] * tMod.getTauBranch(j, false).getDist(i);
                int n3 = i - this.maxRayParamIndex;
                this.time[n3] = this.time[n3] + (double)timesBranches[1][j] * tMod.getTauBranch((int)j, (boolean)false).time[i];
            }
        }
        int numHead = 0;
        int numDiff = 0;
        for (SeismicPhaseSegment seg : this.segmentList) {
            if (seg.prevEndAction.equals((Object)PhaseInteraction.DIFFRACT)) {
                ++numDiff;
                continue;
            }
            if (!seg.prevEndAction.equals((Object)PhaseInteraction.HEAD)) continue;
            ++numHead;
        }
        if (numDiff > 0 || numHead > 0) {
            double horizontalDistDeg = (double)(numHead / (numHead + numDiff)) * SeismicPhaseFactory.getMaxRefraction() + (double)(numDiff / (numHead + numDiff)) * SeismicPhaseFactory.getMaxDiffraction();
            this.dist[1] = this.dist[0] + horizontalDistDeg * Math.PI / 180.0;
            this.time[1] = this.time[0] + horizontalDistDeg * Math.PI / 180.0 * this.minRayParam;
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            System.out.println("one ray param but no head/diff phases");
            this.dist[1] = this.dist[0];
            this.time[1] = this.time[0];
        }
        this.minDistance = Double.MAX_VALUE;
        this.maxDistance = 0.0;
        for (int j = 0; j < this.dist.length; ++j) {
            if (this.dist[j] < this.minDistance) {
                this.minDistance = this.dist[j];
            }
            if (!(this.dist[j] > this.maxDistance)) continue;
            this.maxDistance = this.dist[j];
        }
        boolean foundOverlap = false;
        boolean isPWave = true;
        for (int dummy = 0; dummy < 2; ++dummy) {
            DepthRange[] hsz = tMod.getSlownessModel().getHighSlowness(isPWave);
            int hSZIndex = 0;
            int indexOffset = 0;
            for (int i = 0; i < hsz.length; ++i) {
                int j;
                if (!(this.maxRayParam > hsz[i].rayParam) || !(hsz[i].rayParam > this.minRayParam)) continue;
                int branchNum = tMod.findBranch(hsz[i].topDepth);
                foundOverlap = false;
                for (int legNum = 0; legNum < this.branchSeq.size(); ++legNum) {
                    if (this.branchSeq.get(legNum) != branchNum || this.waveType.get(legNum) != isPWave || !this.downGoing.get(legNum).booleanValue() || this.branchSeq.get(legNum - 1) != branchNum - 1 || this.waveType.get(legNum - 1) != isPWave || !this.downGoing.get(legNum - 1).booleanValue()) continue;
                    foundOverlap = true;
                    break;
                }
                if (!foundOverlap) continue;
                double[] newdist = new double[this.dist.length + 1];
                double[] newtime = new double[this.time.length + 1];
                double[] newrayParams = new double[this.rayParams.length + 1];
                for (j = 0; j < this.rayParams.length; ++j) {
                    if (this.rayParams[j] != hsz[i].rayParam) continue;
                    hSZIndex = j;
                    break;
                }
                System.arraycopy(this.dist, 0, newdist, 0, hSZIndex);
                System.arraycopy(this.time, 0, newtime, 0, hSZIndex);
                System.arraycopy(this.rayParams, 0, newrayParams, 0, hSZIndex);
                newrayParams[hSZIndex] = hsz[i].rayParam;
                newdist[hSZIndex] = 0.0;
                newtime[hSZIndex] = 0.0;
                for (j = 0; j < tMod.getNumBranches(); ++j) {
                    if (timesBranches[0][j] != 0 && tMod.getTauBranch(j, true).getTopDepth() < hsz[i].topDepth) {
                        int n = hSZIndex;
                        newdist[n] = newdist[n] + (double)timesBranches[0][j] * tMod.getTauBranch((int)j, (boolean)true).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                        int n4 = hSZIndex;
                        newtime[n4] = newtime[n4] + (double)timesBranches[0][j] * tMod.getTauBranch((int)j, (boolean)true).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                    }
                    if (timesBranches[1][j] == 0 || !(tMod.getTauBranch(j, false).getTopDepth() < hsz[i].topDepth)) continue;
                    int n = hSZIndex;
                    newdist[n] = newdist[n] + (double)timesBranches[1][j] * tMod.getTauBranch((int)j, (boolean)false).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                    int n5 = hSZIndex;
                    newtime[n5] = newtime[n5] + (double)timesBranches[1][j] * tMod.getTauBranch((int)j, (boolean)false).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                }
                System.arraycopy(this.dist, hSZIndex, newdist, hSZIndex + 1, this.dist.length - hSZIndex);
                System.arraycopy(this.time, hSZIndex, newtime, hSZIndex + 1, this.time.length - hSZIndex);
                System.arraycopy(this.rayParams, hSZIndex, newrayParams, hSZIndex + 1, this.rayParams.length - hSZIndex);
                ++indexOffset;
                this.dist = newdist;
                this.time = newtime;
                this.rayParams = newrayParams;
            }
            isPWave = false;
        }
    }

    public boolean isLegDepth(String leg) {
        boolean isNextLegDepth;
        try {
            double nextLegDepth = Double.parseDouble(leg);
            isNextLegDepth = true;
        }
        catch (NumberFormatException e) {
            isNextLegDepth = false;
        }
        return isNextLegDepth;
    }

    public static final String endActionString(PhaseInteraction endAction) {
        if (endAction == PhaseInteraction.START) {
            return "START";
        }
        if (endAction == PhaseInteraction.TURN) {
            return "TURN";
        }
        if (endAction == PhaseInteraction.REFLECT_UNDERSIDE) {
            return "REFLECT_UNDERSIDE";
        }
        if (endAction == PhaseInteraction.REFLECT_UNDERSIDE_CRITICAL) {
            return "REFLECT_UNDERSIDE_CRITICAL";
        }
        if (endAction == PhaseInteraction.SCATTER) {
            return "SCATTER";
        }
        if (endAction == PhaseInteraction.SCATTER_DOWN) {
            return "SCATTER_DOWN";
        }
        if (endAction == PhaseInteraction.BACKSCATTER) {
            return "BACKSCATTER";
        }
        if (endAction == PhaseInteraction.BACKSCATTER_DOWN) {
            return "BACKSCATTER_DOWN";
        }
        if (endAction == PhaseInteraction.END) {
            return "END";
        }
        if (endAction == PhaseInteraction.END_DOWN) {
            return "END_DOWN";
        }
        if (endAction == PhaseInteraction.REFLECT_TOPSIDE) {
            return "REFLECT_TOPSIDE";
        }
        if (endAction == PhaseInteraction.REFLECT_TOPSIDE_CRITICAL) {
            return "REFLECT_TOPSIDE_CRITICAL";
        }
        if (endAction == PhaseInteraction.TRANSUP) {
            return "TRANSUP";
        }
        if (endAction == PhaseInteraction.TRANSDOWN) {
            return "TRANSDOWN";
        }
        if (endAction == PhaseInteraction.DIFFRACT) {
            return "DIFFRACT";
        }
        if (endAction == PhaseInteraction.HEAD) {
            return "HEAD WAVE";
        }
        if (endAction == PhaseInteraction.FAIL) {
            return "FAIL";
        }
        throw new RuntimeException("UNKNOWN Action: " + (Object)((Object)endAction));
    }
}

