/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TimeDist;
import java.io.Serializable;
import java.util.List;

public interface SeismicPhase
extends Serializable,
Cloneable {
    public static double getMaxRefraction() {
        return SeismicPhaseFactory.getMaxRefraction();
    }

    public static void setMaxRefraction(double max) {
        SeismicPhaseFactory.setMaxRefraction(max);
    }

    public static double getMaxDiffraction() {
        return SeismicPhaseFactory.getMaxDiffraction();
    }

    public static void setMaxDiffraction(double max) {
        SeismicPhaseFactory.setMaxDiffraction(max);
    }

    public static Arrival getEarliestArrival(List<SeismicPhase> phases, double degrees) {
        Arrival minArrival = null;
        for (SeismicPhase seismicPhase : phases) {
            seismicPhase.calcTime(degrees);
            Arrival currArrival = seismicPhase.getEarliestArrival(degrees);
            if (currArrival == null || minArrival != null && !(minArrival.getTime() > currArrival.getTime())) continue;
            minArrival = currArrival;
        }
        return minArrival;
    }

    public boolean phasesExistsInModel();

    public Arrival getEarliestArrival(double var1);

    public TauModel getTauModel();

    public double getMinDistanceDeg();

    public double getMinDistance();

    public double getMaxDistanceDeg();

    public double getMaxDistance();

    public double getMaxRayParam();

    public double getMinRayParam();

    public int getMaxRayParamIndex();

    public int getMinRayParamIndex();

    public String getName();

    public String getPuristName();

    public double getSourceDepth();

    public double getReceiverDepth();

    public List<String> getLegs();

    public List<SeismicPhaseSegment> getPhaseSegments();

    public double getRayParams(int var1);

    public double[] getRayParams();

    public double getDist(int var1);

    public double[] getDist();

    public double getTime(int var1);

    public double[] getTime();

    public double getTau(int var1);

    public double[] getTau();

    public boolean[] getDownGoing();

    public boolean[] getWaveType();

    public int[] getLegAction();

    public boolean hasArrivals();

    public static double distanceTrim180(double deg) {
        double tempDeg = deg;
        if (tempDeg < 0.0) {
            tempDeg *= -1.0;
        }
        while (tempDeg > 360.0) {
            tempDeg -= 360.0;
        }
        if (tempDeg > 180.0) {
            tempDeg = 360.0 - tempDeg;
        }
        return tempDeg;
    }

    public List<Arrival> calcTime(double var1);

    public Arrival shootRay(double var1) throws SlownessModelException, NoSuchLayerException;

    public double calcRayParamForTakeoffAngle(double var1);

    public double calcTakeoffAngle(double var1);

    public double calcIncidentAngle(double var1);

    public String describe();

    public String toString();

    public void dump();

    public List<TimeDist> calcPierceTimeDist(Arrival var1);

    public List<TimeDist> calcPathTimeDist(Arrival var1);

    public static String baseDescribe(SeismicPhase phase) {
        String desc = "";
        if (phase.phasesExistsInModel()) {
            String mod180Min = "";
            if (phase.getMinDistanceDeg() > 180.0 || phase.getMinDistanceDeg() < -180.0) {
                mod180Min = " (" + Outputs.formatDistanceNoPad(SeismicPhase.distanceTrim180(phase.getMinDistanceDeg())) + ") ";
            }
            String mod180Max = "";
            if (phase.getMaxDistanceDeg() > 180.0 || phase.getMaxDistanceDeg() < -180.0) {
                mod180Max = " (" + Outputs.formatDistanceNoPad(SeismicPhase.distanceTrim180(phase.getMaxDistanceDeg())) + ") ";
            }
            desc = desc + "  exists from " + Outputs.formatDistanceNoPad(phase.getMinDistanceDeg()) + mod180Min + " to " + Outputs.formatDistanceNoPad(phase.getMaxDistanceDeg()) + mod180Max + " degrees.\n";
            desc = phase.getMaxRayParam() > phase.getMinRayParam() ? desc + "  with ray parameter from " + Outputs.formatRayParam(phase.getMaxRayParam() / 57.29577951308232) + " down to " + Outputs.formatRayParam(phase.getMinRayParam() / 57.29577951308232) + " sec/deg.\n" : desc + "  with degenerate ray parameter of " + Outputs.formatRayParam(phase.getMaxRayParam() / 57.29577951308232) + " sec/deg.\n";
            double[] time = phase.getTime();
            double[] dist = phase.getDist();
            double[] rayParams = phase.getRayParams();
            desc = desc + "  travel times from " + Outputs.formatTimeNoPad(time[0]) + " to " + Outputs.formatTimeNoPad(time[time.length - 1]) + " sec";
            for (int i = 0; i < dist.length; ++i) {
                if (i >= dist.length - 1 || rayParams[i] != rayParams[i + 1] || rayParams.length <= 2) continue;
                desc = desc + "\n  with shadow zone between " + Outputs.formatDistance(57.29577951308232 * dist[i]) + " and " + Outputs.formatDistance(57.29577951308232 * dist[i + 1]) + " deg";
            }
            desc = desc + ".\n";
        } else {
            desc = desc + "  FAILS to exist, because no ray parameters satisfy the path.\n";
        }
        return desc;
    }

    public static String segmentDescribe(SeismicPhase phase) {
        String desc = "";
        String indent = "  ";
        for (SeismicPhaseSegment segment : phase.getPhaseSegments()) {
            desc = desc + indent + segment.toString() + "\n";
        }
        return desc;
    }
}

