/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.TimeDist;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScatteredSeismicPhase
implements SeismicPhase {
    private final Arrival inboundArrival;
    private final SimpleSeismicPhase scatteredPhase;
    private final double scattererDepth;
    private final double scattererDistanceDeg;
    private final boolean backscatter;

    public ScatteredSeismicPhase(Arrival inboundArrival, SimpleSeismicPhase scatteredPhase, double scattererDepth, double scattererDistanceDeg, boolean backscatter) {
        this.inboundArrival = inboundArrival;
        this.scatteredPhase = scatteredPhase;
        this.scattererDepth = scattererDepth;
        this.scattererDistanceDeg = scattererDistanceDeg;
        this.backscatter = backscatter;
    }

    public double getScattererDepth() {
        return this.scattererDepth;
    }

    public double getScattererDistance() {
        return this.scattererDistanceDeg * (Math.PI / 180);
    }

    public double getScattererDistanceDeg() {
        return this.scattererDistanceDeg;
    }

    public boolean isBackscatter() {
        return this.backscatter;
    }

    @Override
    public boolean phasesExistsInModel() {
        return this.inboundArrival != null && this.scatteredPhase.phasesExistsInModel();
    }

    @Override
    public Arrival getEarliestArrival(double degrees) {
        return Arrival.getEarliestArrival(this.calcTime(degrees));
    }

    @Override
    public TauModel getTauModel() {
        return this.scatteredPhase.getTauModel();
    }

    @Override
    public double getMinDistanceDeg() {
        int mulFac = this.isBackscatter() ? -1 : 1;
        return this.getScattererDistanceDeg() + (double)mulFac * this.scatteredPhase.getMinDistanceDeg();
    }

    @Override
    public double getMinDistance() {
        int mulFac = this.isBackscatter() ? -1 : 1;
        return this.getScattererDistance() + (double)mulFac * this.scatteredPhase.getMinDistance();
    }

    @Override
    public double getMaxDistanceDeg() {
        int mulFac = this.isBackscatter() ? -1 : 1;
        return this.getScattererDistanceDeg() + (double)mulFac * this.scatteredPhase.getMaxDistanceDeg();
    }

    @Override
    public double getMaxDistance() {
        int mulFac = this.isBackscatter() ? -1 : 1;
        return this.getScattererDistance() + (double)mulFac * this.scatteredPhase.getMaxDistance();
    }

    @Override
    public double getMaxRayParam() {
        return this.scatteredPhase.getMaxRayParam();
    }

    @Override
    public double getMinRayParam() {
        return this.scatteredPhase.getMinRayParam();
    }

    @Override
    public int getMaxRayParamIndex() {
        return this.scatteredPhase.getMaxRayParamIndex();
    }

    @Override
    public int getMinRayParamIndex() {
        return this.scatteredPhase.getMinRayParamIndex();
    }

    @Override
    public double getSourceDepth() {
        return this.inboundArrival.getSourceDepth();
    }

    @Override
    public double getReceiverDepth() {
        return this.scatteredPhase.getReceiverDepth();
    }

    @Override
    public String getName() {
        return ScatteredArrival.formScatterPhaseName(this.inboundArrival.getName(), this.scatteredPhase.getName(), this.isBackscatter());
    }

    @Override
    public String getPuristName() {
        return ScatteredArrival.formScatterPhaseName(this.inboundArrival.getPuristName(), this.scatteredPhase.getPuristName(), this.isBackscatter());
    }

    @Override
    public List<String> getLegs() {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(this.inboundArrival.getPhase().getLegs());
        out.addAll(this.scatteredPhase.getLegs());
        return out;
    }

    @Override
    public List<SeismicPhaseSegment> getPhaseSegments() {
        ArrayList<SeismicPhaseSegment> out = new ArrayList<SeismicPhaseSegment>();
        out.addAll(this.inboundArrival.getPhase().getPhaseSegments());
        out.addAll(this.scatteredPhase.getPhaseSegments());
        return out;
    }

    @Override
    public double getRayParams(int i) {
        return this.scatteredPhase.getRayParams(i);
    }

    @Override
    public double[] getRayParams() {
        return this.scatteredPhase.getRayParams();
    }

    @Override
    public double getDist(int i) {
        return this.inboundArrival.getDist() + this.scatteredPhase.getDist(i);
    }

    @Override
    public double[] getDist() {
        double[] scatDist = this.scatteredPhase.getDist();
        double[] out = new double[scatDist.length];
        for (int i = 0; i < scatDist.length; ++i) {
            out[i] = this.getScattererDistance() + scatDist[i];
        }
        return out;
    }

    @Override
    public double getTime(int i) {
        return this.inboundArrival.getTime() + this.scatteredPhase.getTime(i);
    }

    @Override
    public double[] getTime() {
        double[] scatTime = this.scatteredPhase.getTime();
        double[] out = new double[scatTime.length];
        for (int i = 0; i < scatTime.length; ++i) {
            out[i] = this.inboundArrival.getTime() + scatTime[i];
        }
        return out;
    }

    @Override
    public double getTau(int i) {
        return 0.0;
    }

    @Override
    public double[] getTau() {
        return new double[0];
    }

    @Override
    public boolean[] getDownGoing() {
        boolean[] inDowngoing = this.inboundArrival.getPhase().getDownGoing();
        boolean[] scatDownGoing = this.scatteredPhase.getDownGoing();
        boolean[] out = new boolean[inDowngoing.length + scatDownGoing.length];
        System.arraycopy(inDowngoing, 0, out, 0, inDowngoing.length);
        System.arraycopy(scatDownGoing, 0, out, inDowngoing.length, scatDownGoing.length);
        return out;
    }

    @Override
    public boolean[] getWaveType() {
        boolean[] in = this.inboundArrival.getPhase().getWaveType();
        boolean[] scat = this.scatteredPhase.getWaveType();
        boolean[] out = new boolean[in.length + scat.length];
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(scat, 0, out, in.length, scat.length);
        return out;
    }

    @Override
    public int[] getLegAction() {
        int[] in = this.inboundArrival.getPhase().getLegAction();
        int[] scat = this.scatteredPhase.getLegAction();
        int[] out = new int[in.length + scat.length];
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(scat, 0, out, in.length, scat.length);
        return out;
    }

    @Override
    public boolean hasArrivals() {
        return this.inboundArrival != null && this.scatteredPhase.hasArrivals();
    }

    @Override
    public List<Arrival> calcTime(double deg) {
        ArrayList<Arrival> out = new ArrayList<Arrival>();
        double scatDist = ScatteredSeismicPhase.calcScatterDistDeg(deg, this.getScattererDistanceDeg(), this.isBackscatter()) % 360.0;
        if (scatDist < 0.0) {
            scatDist += 360.0;
        }
        ArrayList<Arrival> scat = new ArrayList<Arrival>();
        for (double calcScatRad = scatDist * (Math.PI / 180); calcScatRad < this.scatteredPhase.getMaxDistance(); calcScatRad += Math.PI * 2) {
            List<Arrival> scatAtDist = this.scatteredPhase.calcTimeExactDistance(calcScatRad);
            for (Arrival a : scatAtDist) {
                a.setSearchDistDeg(scatDist);
                if (Math.abs((a.getDistDeg() - scatDist) % 360.0) < 1.0E-6) {
                    ScatteredArrival b = new ScatteredArrival(this, deg, this.inboundArrival, a, this.isBackscatter());
                    b.setSearchDistDeg(deg);
                    out.add(b);
                    continue;
                }
                if (!TauP_Tool.DEBUG) continue;
                System.out.println("Arrival not scatter to rec: " + deg + " scat: " + this.getScattererDistanceDeg() + " a: " + a.getDistDeg());
            }
            scat.addAll(scatAtDist);
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double calcScatterDistDeg(double deg, double scattererDeg, boolean backscatter) {
        double calcDeg = deg % 360.0;
        double calcScatDeg = (180.0 + scattererDeg) % 360.0 - 180.0;
        if (deg > 180.0) {
            calcDeg = 360.0 - calcDeg;
            calcScatDeg *= -1.0;
        }
        if (backscatter) {
            if (calcScatDeg >= 0.0 && calcScatDeg <= calcDeg) {
                return 360.0 - calcDeg + calcScatDeg;
            }
            if (calcScatDeg > calcDeg) {
                return calcScatDeg - calcDeg;
            }
            if (!(calcScatDeg < 0.0)) throw new RuntimeException("Should never happen " + deg + " " + scattererDeg);
            return calcDeg - calcScatDeg;
        }
        if (calcScatDeg >= 0.0 && calcScatDeg <= calcDeg) {
            return calcDeg - calcScatDeg;
        }
        if (calcScatDeg > calcDeg) {
            return 360.0 - calcScatDeg + calcDeg;
        }
        if (!(calcScatDeg < 0.0)) throw new RuntimeException("Should never happen " + deg + " " + scattererDeg);
        return 360.0 + calcScatDeg - calcDeg;
    }

    @Override
    public Arrival shootRay(double rayParam) throws SlownessModelException, NoSuchLayerException {
        return null;
    }

    @Override
    public double calcRayParamForTakeoffAngle(double takeoffDegree) {
        return this.inboundArrival.getRayParam();
    }

    @Override
    public double calcTakeoffAngle(double arrivalRayParam) {
        return this.inboundArrival.getTakeoffAngle();
    }

    @Override
    public double calcIncidentAngle(double arrivalRayParam) {
        return this.scatteredPhase.calcIncidentAngle(arrivalRayParam);
    }

    @Override
    public String describe() {
        String desc = this.getName() + " scattered at " + this.getScattererDepth() + " km and " + this.getScattererDistanceDeg() + " deg:\n";
        desc = desc + SeismicPhase.baseDescribe(this);
        desc = desc + SeismicPhase.segmentDescribe(this);
        String scat_direction = this.isBackscatter() ? "Backscatter" : "Scatter";
        desc = desc + "\nInbound to Scatterer: " + this.inboundArrival.getPhase().getName() + "\n" + SeismicPhase.baseDescribe(this.inboundArrival.getPhase()) + "Arrival at Scatterer: " + this.inboundArrival + "\n" + scat_direction + " from " + this.scattererDepth + ", " + this.scattererDistanceDeg + "\nOutbound from Scatterer: " + this.scatteredPhase.getName() + "\n" + SeismicPhase.baseDescribe(this.scatteredPhase);
        return desc;
    }

    @Override
    public void dump() {
        double[] dist = this.scatteredPhase.getDist();
        double[] rayParams = this.scatteredPhase.getRayParams();
        for (int j = 0; j < dist.length; ++j) {
            System.out.println(j + "  " + (this.scattererDistanceDeg + dist[j]) + "  " + rayParams[j]);
        }
    }

    @Override
    public List<TimeDist> calcPierceTimeDist(Arrival arrival) {
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        ScatteredArrival scatA = (ScatteredArrival)arrival;
        double scatDistance = this.inboundArrival.getDist();
        if (scatA.isInboundNegativeDirection()) {
            scatDistance = -1.0 * scatDistance;
            for (TimeDist td : this.inboundArrival.getPierce()) {
                TimeDist btd = new TimeDist(td.getP(), td.getTime(), -1.0 * td.getDistRadian(), td.getDepth());
                out.add(btd);
            }
        } else {
            out.addAll(Arrays.asList(this.inboundArrival.getPierce()));
        }
        List<TimeDist> scatPierce = this.scatteredPhase.calcPierceTimeDist(scatA.getScatteredArrival());
        int scatNegative = 1;
        if (scatA.isScatterNegativeDirection()) {
            scatNegative = -1;
        }
        for (TimeDist td : scatPierce) {
            out.add(new TimeDist(td.getP(), this.inboundArrival.getTime() + td.getTime(), scatDistance + (double)scatNegative * td.getDistRadian(), td.getDepth()));
        }
        return out;
    }

    @Override
    public List<TimeDist> calcPathTimeDist(Arrival arrival) {
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        ScatteredArrival scatA = (ScatteredArrival)arrival;
        double scatDistance = this.inboundArrival.getDist();
        TimeDist[] inPath = this.inboundArrival.getPath();
        if (scatA.isInboundNegativeDirection()) {
            scatDistance = -1.0 * scatDistance;
            for (TimeDist td : this.inboundArrival.getPath()) {
                TimeDist btd = new TimeDist(td.getP(), td.getTime(), -1.0 * td.getDistRadian(), td.getDepth());
                out.add(btd);
            }
        } else {
            out.addAll(Arrays.asList(this.inboundArrival.getPath()));
        }
        List<TimeDist> scatPath = this.scatteredPhase.calcPathTimeDist(scatA.getScatteredArrival());
        scatPath = scatPath.subList(1, scatPath.size());
        int scatNegative = 1;
        if (scatA.isScatterNegativeDirection()) {
            scatNegative = -1;
        }
        for (TimeDist td : scatPath) {
            out.add(new TimeDist(td.getP(), this.inboundArrival.getTime() + td.getTime(), scatDistance + (double)scatNegative * td.getDistRadian(), td.getDepth()));
        }
        return out;
    }
}

