/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ScatteredSeismicPhase;

public class ScatteredArrival
extends Arrival {
    private final Arrival inboundArrival;
    private final Arrival scatteredArrival;
    private final boolean isBackscatter;

    public static String formScatterPhaseName(String inboundName, String scatterName, boolean isBackscatter) {
        if (isBackscatter) {
            return inboundName + 'O' + scatterName;
        }
        return inboundName + 'o' + scatterName;
    }

    public ScatteredArrival(ScatteredSeismicPhase phase, double deg, Arrival inboundArrival, Arrival scatteredArrival, boolean isBackscatter) {
        super(phase, inboundArrival.getTime() + scatteredArrival.getTime(), inboundArrival.getDist() + (double)(isBackscatter ? -1 : 1) * scatteredArrival.getDist(), scatteredArrival.getRayParam(), scatteredArrival.getRayParamIndex(), deg, ScatteredArrival.formScatterPhaseName(inboundArrival.getName(), scatteredArrival.getName(), isBackscatter), ScatteredArrival.formScatterPhaseName(inboundArrival.getPuristName(), scatteredArrival.getPuristName(), isBackscatter), inboundArrival.getPhase().getSourceDepth(), scatteredArrival.getPhase().getReceiverDepth(), inboundArrival.getPhase().calcTakeoffAngle(inboundArrival.getRayParam()), scatteredArrival.getPhase().calcIncidentAngle(scatteredArrival.getRayParam()));
        this.inboundArrival = inboundArrival;
        this.scatteredArrival = scatteredArrival;
        this.isBackscatter = isBackscatter;
    }

    public ScatteredSeismicPhase getScatteredSeismicPhase() {
        return (ScatteredSeismicPhase)this.getPhase();
    }

    public Arrival getInboundArrival() {
        return this.inboundArrival;
    }

    public Arrival getScatteredArrival() {
        return this.scatteredArrival;
    }

    public boolean isBackscatter() {
        return this.isBackscatter;
    }

    @Override
    public boolean isLongWayAround() {
        return false;
    }

    public boolean isInboundNegativeDirection() {
        return this.getScatteredSeismicPhase().getScattererDistanceDeg() < 0.0;
    }

    public boolean isScatterNegativeDirection() {
        double scatDist = this.getScatteredSeismicPhase().getScattererDistanceDeg();
        return scatDist >= 0.0 && this.isBackscatter() || scatDist < 0.0 && !this.isBackscatter();
    }
}

