/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertyLoader {
    protected static String jarFileName = "taup.jar";
    protected static String defaultPropFileName = "defaultProps";
    protected static String packageName = "/edu/sc/seis/TauP";
    protected static String userPropFileName = ".taup";

    public static Properties load() throws IOException {
        Properties defaultProps = new Properties();
        try {
            String classPath = System.getProperty("java.class.path");
            String pathEntry = "";
            boolean offset = false;
            Class<?> c = null;
            try {
                c = Class.forName("edu.sc.seis.TauP.PropertyLoader");
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream in = c.getResourceAsStream(packageName + "/" + defaultPropFileName);
            if (in != null) {
                defaultProps.load(new BufferedInputStream(in));
            } else {
                System.err.println("Warning: unable to load default configuration properties from jar, " + packageName + "/" + defaultPropFileName);
            }
        }
        catch (FileNotFoundException classPath) {
            // empty catch block
        }
        Properties applicationProps = new Properties();
        applicationProps.putAll((Map<?, ?>)defaultProps);
        try {
            applicationProps.load(new FileInputStream(System.getProperty("user.home") + System.getProperty("file.separator") + ".taup"));
        }
        catch (FileNotFoundException pathEntry) {
            // empty catch block
        }
        try {
            applicationProps.load(new FileInputStream(System.getProperty("user.dir") + System.getProperty("file.separator") + ".taup"));
        }
        catch (FileNotFoundException pathEntry) {
            // empty catch block
        }
        String taupPath = "taup.model.path";
        Properties sysProps = System.getProperties();
        if (sysProps.containsKey(taupPath)) {
            if (applicationProps.containsKey(taupPath)) {
                applicationProps.put(taupPath, sysProps.getProperty(taupPath) + sysProps.getProperty("path.separator") + applicationProps.getProperty(taupPath));
            } else {
                applicationProps.put(taupPath, sysProps.getProperty(taupPath));
            }
        }
        return applicationProps;
    }

    public static void save(Properties props) throws IOException {
        PropertyLoader.save(props, ".taup");
    }

    public static void save(Properties props, String filename) throws IOException {
        FileOutputStream propFile = new FileOutputStream(filename);
        props.store(propFile, "---Properties for the TauP toolkit---");
        propFile.close();
    }

    public static void main(String[] args) {
        try {
            Properties props = PropertyLoader.load();
            props.put("Key", "Value and another value");
            PropertyLoader.save(props, "testProperties");
        }
        catch (IOException e) {
            System.out.println("Caught IOException: " + e.getMessage());
        }
    }
}

