/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TimeDist;
import java.time.Duration;
import java.util.List;

public class Arrival {
    private SeismicPhase phase;
    private double time;
    private double dist;
    private double rayParam;
    private int rayParamIndex;
    private double searchDist;
    private double searchDistDeg;
    private String name;
    private String puristName;
    private double sourceDepth;
    private double receiverDepth;
    private TimeDist[] pierce;
    private TimeDist[] path;
    private double incidentAngle;
    private double takeoffAngle;
    public static final double MANY_LAPS_PLUS_180 = 36180.0;
    protected static final double TWOPI = Math.PI * 2;
    protected static final double DtoR = Math.PI / 180;
    protected static final double RtoD = 57.29577951308232;

    public Arrival(SeismicPhase phase, double time, double dist, double rayParam, int rayParamIndex) {
        this(phase, time, dist, rayParam, rayParamIndex, dist, phase.getName(), phase.getPuristName(), phase.getSourceDepth(), phase.getReceiverDepth(), phase.calcTakeoffAngle(rayParam), phase.calcIncidentAngle(rayParam));
    }

    public Arrival(SeismicPhase phase, double time, double dist, double rayParam, int rayParamIndex, double searchDist, String name, String puristName, double sourceDepth, double receiverDepth, double takeoffAngle, double incidentAngle) {
        if (Double.isNaN(time)) {
            throw new IllegalArgumentException("Time cannot be NaN");
        }
        if (rayParamIndex < 0) {
            throw new IllegalArgumentException("rayParamIndex cannot be negative: " + rayParamIndex);
        }
        this.phase = phase;
        this.time = time;
        this.dist = dist;
        this.rayParam = rayParam;
        this.rayParamIndex = rayParamIndex;
        this.searchDist = searchDist;
        this.name = name;
        this.puristName = puristName;
        this.sourceDepth = sourceDepth;
        this.receiverDepth = receiverDepth;
        this.takeoffAngle = takeoffAngle;
        this.incidentAngle = incidentAngle;
    }

    public SeismicPhase getPhase() {
        return this.phase;
    }

    public double getTime() {
        return this.time;
    }

    public Duration getDuration() {
        return Duration.ofNanos(Math.round(this.getTime() * 1.0E9));
    }

    public double getDist() {
        return this.dist;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDist();
    }

    public double getModuloDist() {
        double moduloDist = this.getDist() % (Math.PI * 2);
        if (moduloDist > Math.PI) {
            moduloDist = Math.PI * 2 - moduloDist;
        }
        return moduloDist;
    }

    public double getModuloDistDeg() {
        return SeismicPhase.distanceTrim180(this.getDistDeg());
    }

    public void setSearchDistDeg(double searchDistDeg) {
        this.searchDistDeg = searchDistDeg;
    }

    public double getSearchDistDeg() {
        return this.searchDistDeg;
    }

    public double getModuloSearchDistDeg() {
        return SeismicPhase.distanceTrim180(this.getSearchDistDeg());
    }

    public boolean isLongWayAround() {
        double shortWay = (36180.0 + this.getSearchDistDeg() - this.getDistDeg()) % 360.0 - 180.0;
        double longWay = (36180.0 + this.getSearchDistDeg() - (360.0 - this.getDistDeg())) % 360.0 - 180.0;
        return Math.abs(longWay) < Math.abs(shortWay);
    }

    public double getRayParam() {
        return this.rayParam;
    }

    public double getRayParamDeg() {
        return this.getRayParam() / 57.29577951308232;
    }

    public double getIncidentAngle() {
        return this.incidentAngle;
    }

    public double getTakeoffAngle() {
        return this.takeoffAngle;
    }

    public int getRayParamIndex() {
        return this.rayParamIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.puristName;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public TimeDist[] getPierce() {
        if (this.pierce == null) {
            this.pierce = this.getPhase().calcPierceTimeDist(this).toArray(new TimeDist[0]);
        }
        return this.pierce;
    }

    public TimeDist[] getPath() {
        if (this.path == null) {
            this.path = this.getPhase().calcPathTimeDist(this).toArray(new TimeDist[0]);
        }
        return this.path;
    }

    public String toString() {
        String desc = Outputs.formatDistance(this.getModuloDistDeg()) + Outputs.formatDepth(this.getSourceDepth()) + "   " + this.getName() + "  " + Outputs.formatTime(this.getTime()) + "  " + Outputs.formatRayParam(Math.PI / 180 * this.getRayParam()) + "  " + Outputs.formatDistance(this.getTakeoffAngle()) + " " + Outputs.formatDistance(this.getIncidentAngle()) + " " + Outputs.formatDistance(this.getDistDeg()) + " " + this.getRayParamIndex();
        desc = this.getName().equals(this.getPuristName()) ? desc + "   = " : desc + "   * ";
        desc = desc + this.getPuristName();
        return desc;
    }

    public int getNumPiercePoints() {
        if (this.pierce != null) {
            return this.pierce.length;
        }
        return 0;
    }

    public int getNumPathPoints() {
        if (this.path != null) {
            return this.path.length;
        }
        return 0;
    }

    public TimeDist getPiercePoint(int i) {
        return this.pierce[i];
    }

    public TimeDist getFirstPiercePoint(double depth) {
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].getDepth() != depth) continue;
            return this.pierce[i];
        }
        throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
    }

    public TimeDist getLastPiercePoint(double depth) {
        TimeDist piercepoint = null;
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].getDepth() != depth) continue;
            piercepoint = this.pierce[i];
        }
        if (piercepoint == null) {
            throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
        }
        return piercepoint;
    }

    public TimeDist getPathPoint(int i) {
        return this.path[i];
    }

    public static Arrival getEarliestArrival(List<Arrival> arrivals) {
        double soonest = Double.MAX_VALUE;
        Arrival soonestArrival = null;
        for (Arrival a : arrivals) {
            if (!(a.getTime() < soonest)) continue;
            soonestArrival = a;
            soonest = a.getTime();
        }
        return soonestArrival;
    }

    public static Arrival getLatestArrival(List<Arrival> arrivals) {
        double latest = Double.MAX_VALUE;
        Arrival latestArrival = null;
        for (Arrival a : arrivals) {
            if (!(a.getTime() < latest)) continue;
            latestArrival = a;
            latest = a.getTime();
        }
        return latestArrival;
    }

    public String asJSON(boolean pretty, String indent) {
        String NL = "";
        if (pretty) {
            NL = "\n";
        }
        String Q = "\"";
        String COMMA = ",";
        String QCOMMA = Q + COMMA;
        String COLON = ": ";
        String S = "  ";
        String QC = Q + COLON;
        String QCQ = QC + Q;
        String SS = S + S;
        String SQ = S + Q;
        String SSQ = S + SQ;
        StringBuilder out = new StringBuilder();
        out.append(indent + "{" + NL);
        out.append(indent + SQ + "distdeg" + QC + (float)this.getModuloDistDeg() + COMMA + NL);
        out.append(indent + SQ + "phase" + QCQ + this.getName() + QCOMMA + NL);
        out.append(indent + SQ + "time" + QC + (float)this.getTime() + COMMA + NL);
        out.append(indent + SQ + "rayparam" + QC + (float)(Math.PI / 180 * this.getRayParam()) + COMMA + NL);
        out.append(indent + SQ + "takeoff" + QC + (float)this.getTakeoffAngle() + COMMA + NL);
        out.append(indent + SQ + "incident" + QC + (float)this.getIncidentAngle() + COMMA + NL);
        out.append(indent + SQ + "puristdist" + QC + (float)this.getDistDeg() + COMMA + NL);
        out.append(indent + SQ + "puristname" + QCQ + this.getPuristName() + Q);
        if (this.getPhase() instanceof ScatteredSeismicPhase) {
            ScatteredSeismicPhase scatPhase = (ScatteredSeismicPhase)this.getPhase();
            out.append(COMMA + NL);
            out.append(indent + SQ + "scatterdepth" + QC + (float)scatPhase.getScattererDepth() + COMMA + NL);
            out.append(indent + SQ + "scatterdistdeg" + QC + scatPhase.getScattererDistanceDeg() + NL);
        } else {
            out.append(NL);
        }
        out.append(indent + "}");
        return out.toString();
    }
}

