/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.iir;

import com.oregondsp.signalProcessing.filter.Rational;
import com.oregondsp.signalProcessing.filter.iir.AnalogPrototype;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import com.oregondsp.signalProcessing.filter.iir.PassbandType;
import com.oregondsp.signalProcessing.filter.iir.SecondOrderSection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;

public class IIRFilter {
    protected ArrayList<SecondOrderSection> sections;
    protected Rational T;

    public IIRFilter(AnalogPrototype baseFilter, PassbandType type, double f1, double f2, double delta) {
        AnalogPrototype prototype;
        switch (type) {
            case LOWPASS: {
                prototype = baseFilter.lptolp(this.warp(f2, delta));
                break;
            }
            case BANDPASS: {
                prototype = baseFilter.lptobp(this.warp(f1, delta), this.warp(f2, delta));
                break;
            }
            case HIGHPASS: {
                prototype = baseFilter.lptohp(this.warp(f1, delta));
                break;
            }
            default: {
                throw new IllegalStateException("Undefined passband type");
            }
        }
        double[] tn = new double[2];
        double[] td = new double[2];
        tn[0] = 1.0;
        tn[1] = -1.0;
        td[0] = 1.0;
        td[1] = 1.0;
        Rational S = new Rational(tn, td);
        this.T = new Rational(1.0);
        this.sections = new ArrayList();
        for (int i = 0; i < prototype.nSections(); ++i) {
            Rational R = prototype.getSection(i).map(S);
            this.T.timesEquals(R);
            double[] cn = R.numerator().coefficients();
            double[] cd = R.denominator().coefficients();
            double s = 1.0;
            if (cd[0] != 0.0) {
                s = cd[0];
            }
            double b0 = cn[0] / s;
            double b1 = 0.0;
            if (cn.length >= 2) {
                b1 = cn[1] / s;
            }
            double b2 = 0.0;
            if (cn.length >= 3) {
                b2 = cn[2] / s;
            }
            double a1 = 0.0;
            if (cd.length >= 2) {
                a1 = cd[1] / s;
            }
            double a2 = 0.0;
            if (cd.length >= 3) {
                a2 = cd[2] / s;
            }
            this.sections.add(new SecondOrderSection(b0, b1, b2, a1, a2));
        }
    }

    public void initialize() {
        for (int i = 0; i < this.sections.size(); ++i) {
            this.sections.get(i).initialize();
        }
    }

    public float filter(float x) {
        float retval = this.sections.get(0).filter(x);
        for (int i = 1; i < this.sections.size(); ++i) {
            retval = this.sections.get(i).filter(retval);
        }
        return retval;
    }

    public void filter(float[] x, float[] y) {
        Arrays.fill(y, 0.0f);
        this.sections.get(0).filter(x, y);
        for (int i = 1; i < this.sections.size(); ++i) {
            this.sections.get(i).filter(y, y);
        }
    }

    public void filter(float[] x) {
        for (SecondOrderSection section : this.sections) {
            section.filter(x, x);
        }
    }

    public Complex evaluate(double Omega) {
        Complex ejOmega = Complex.exp(new Complex(0.0, -Omega));
        return this.T.evaluate(ejOmega);
    }

    public double groupDelay(double Omega) {
        return this.T.discreteTimeGroupDelay(Omega);
    }

    public void print(PrintStream ps) {
        ps.println("IIR Filter:");
        for (int i = 0; i < this.sections.size(); ++i) {
            ps.println("\n  Section " + i + "\n");
            this.sections.get(i).print(ps);
            ps.println();
        }
    }

    private double warp(double f, double delta) {
        return Math.tan(Math.PI * f * delta);
    }
}

