/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.iir;

import com.oregondsp.signalProcessing.filter.iir.AnalogChebyshevI;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import com.oregondsp.signalProcessing.filter.iir.IIRFilter;
import com.oregondsp.signalProcessing.filter.iir.PassbandType;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class ChebyshevI
extends IIRFilter {
    public ChebyshevI(int order, double epsilon, PassbandType type, double f1, double f2, double delta) {
        super(new AnalogChebyshevI(order, epsilon), type, f1, f2, delta);
    }

    public static void main(String[] args) {
        int i;
        PrintStream ps;
        double epsilon = 0.50885;
        ChebyshevI F = new ChebyshevI(4, epsilon, PassbandType.LOWPASS, 2.0, 0.0, 0.05);
        F.print(System.out);
        float[] tmp = new float[201];
        for (int i2 = 0; i2 < 201; ++i2) {
            Complex C = F.evaluate(0.015707963267948967 * (double)i2);
            tmp[i2] = (float)Complex.abs(C);
        }
        float[] x = new float[1001];
        x[200] = 1.0f;
        float[] y = new float[1001];
        F.filter(x, y);
        try {
            ps = new PrintStream(new FileOutputStream("C:\\DATA\\Test\\Response.m"));
            ps.print("R = [ ");
            for (i = 0; i < 200; ++i) {
                ps.println(tmp[i] + "; ...");
            }
            ps.println(tmp[200] + "];");
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            ps = new PrintStream(new FileOutputStream("C:\\DATA\\Test\\ImpulseResponse.m"));
            ps.print("IR = [ ");
            for (i = 0; i < 1000; ++i) {
                ps.println(y[i] + "; ...");
            }
            ps.println(y[1000] + "];");
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

