/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.iir;

import com.oregondsp.signalProcessing.filter.Polynomial;
import com.oregondsp.signalProcessing.filter.Rational;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import java.io.PrintStream;
import java.util.ArrayList;

public class AnalogPrototype {
    protected ArrayList<Rational> sections = new ArrayList();
    protected Rational T = null;

    public void addSection(Rational R) {
        this.sections.add(R);
    }

    public int nSections() {
        return this.sections.size();
    }

    public Rational getSection(int index) {
        return new Rational(this.sections.get(index));
    }

    public AnalogPrototype lptolp(double omega0) {
        double[] tn = new double[]{0.0, 1.0};
        double[] td = new double[]{omega0};
        Rational T = new Rational(tn, td);
        AnalogPrototype retval = new AnalogPrototype();
        for (int i = 0; i < this.sections.size(); ++i) {
            retval.addSection(this.sections.get(i).map(T));
        }
        return retval;
    }

    public AnalogPrototype lptohp(double omega0) {
        double[] tn = new double[]{omega0};
        double[] td = new double[]{0.0, 1.0};
        Rational T = new Rational(tn, td);
        AnalogPrototype retval = new AnalogPrototype();
        for (int i = 0; i < this.sections.size(); ++i) {
            retval.addSection(this.sections.get(i).map(T));
        }
        return retval;
    }

    public AnalogPrototype lptobp(double omega1, double omega2) {
        double BW = omega2 - omega1;
        double prod = omega1 * omega2;
        double[] tn = new double[]{prod, 0.0, 1.0};
        double[] td = new double[]{0.0, BW};
        Rational T = new Rational(tn, td);
        AnalogPrototype retval = new AnalogPrototype();
        double A = 1.0;
        for (int i = 0; i < this.sections.size(); ++i) {
            Rational section = this.sections.get(i);
            Rational Tsection = section.map(T);
            A *= Tsection.canonicalForm();
            int[] order = section.order();
            if (order[0] < 2 && order[1] < 2) {
                retval.addSection(Tsection);
                continue;
            }
            if (order[1] != 2) continue;
            Polynomial[] DT = AnalogPrototype.lptobpFactors(section.denominator(), BW, prod);
            double[] t1 = new double[]{0.0, 1.0};
            if (order[0] == 0) {
                retval.addSection(new Rational(new Polynomial(t1), DT[0]));
                retval.addSection(new Rational(new Polynomial(t1), DT[1]));
                continue;
            }
            if (order[0] == 1) {
                retval.addSection(new Rational(new Polynomial(t1), DT[0]));
                double[] t2 = new double[3];
                double[] tc = Tsection.numerator().coefficients();
                for (int j = 0; j < 3; ++j) {
                    t2[j] = tc[j + 1];
                }
                retval.addSection(new Rational(new Polynomial(t2), DT[1]));
                continue;
            }
            if (order[0] != 2) continue;
            Polynomial[] NT = AnalogPrototype.lptobpFactors(section.numerator(), BW, prod);
            retval.addSection(new Rational(NT[0], DT[0]));
            retval.addSection(new Rational(NT[1], DT[1]));
        }
        retval.sections.get(0).timesEquals(A);
        return retval;
    }

    private static Polynomial[] lptobpFactors(Polynomial P, double BW, double prod) {
        double c;
        Polynomial[] retval = new Polynomial[2];
        double[] p = P.coefficients();
        double b = p[1] / p[2];
        double discriminant = b * b - 4.0 * (c = p[0] / p[2]);
        if (discriminant >= 0.0) {
            double root = (-b + Math.sqrt(discriminant)) / 2.0;
            double f1 = root * BW / 2.0;
            double f2 = f1 * f1 - prod;
            Complex C = new Complex(f1).plus(Complex.sqrt(new Complex(f2)));
            double[] t0 = new double[]{C.conjugate().times(C).real(), -2.0 * C.real(), 1.0};
            retval[0] = new Polynomial(t0);
            root = (-b - Math.sqrt(discriminant)) / 2.0;
            f1 = root * BW / 2.0;
            f2 = f1 * f1 - prod;
            C = new Complex(f1).plus(Complex.sqrt(new Complex(f2)));
            double[] t1 = new double[]{C.conjugate().times(C).real(), -2.0 * C.real(), 1.0};
            retval[1] = new Polynomial(t1);
        } else {
            Complex root = new Complex(-b / 2.0, Math.sqrt(-discriminant) / 2.0);
            Complex f1 = root.times(BW / 2.0);
            Complex f2 = f1.times(f1).minus(prod);
            Complex C = f1.plus(Complex.sqrt(f2));
            double[] t0 = new double[]{C.conjugate().times(C).real(), -2.0 * C.real(), 1.0};
            retval[0] = new Polynomial(t0);
            C = f1.minus(Complex.sqrt(f2));
            double[] t1 = new double[]{C.conjugate().times(C).real(), -2.0 * C.real(), 1.0};
            retval[1] = new Polynomial(t1);
        }
        return retval;
    }

    protected void computeTransferFunction() {
        this.T = new Rational(1.0);
        for (int i = 0; i < this.sections.size(); ++i) {
            this.T.timesEquals(this.sections.get(i));
        }
    }

    public Rational getTransferFunction() {
        if (this.T == null) {
            this.computeTransferFunction();
        }
        return new Rational(this.T);
    }

    protected Complex evaluate(double omega) {
        if (this.T == null) {
            this.computeTransferFunction();
        }
        return this.T.evaluate(new Complex(0.0, omega));
    }

    protected double groupDelay(double omega) {
        if (this.T == null) {
            this.computeTransferFunction();
        }
        return this.T.groupDelay(omega);
    }

    public void print(PrintStream ps) {
        ps.println("AnalogPrototype: \n");
        for (int i = 0; i < this.sections.size(); ++i) {
            ps.println("  section " + i + ":");
            this.sections.get(i).print(ps);
        }
    }
}

