/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.iir;

import com.oregondsp.signalProcessing.filter.Polynomial;
import com.oregondsp.signalProcessing.filter.Rational;
import com.oregondsp.signalProcessing.filter.iir.AnalogPrototype;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class AnalogChebyshevII
extends AnalogPrototype {
    public AnalogChebyshevII(int order, double epsilon) {
        double alpha = (1.0 + Math.sqrt(1.0 + epsilon * epsilon)) / epsilon;
        double p = Math.pow(alpha, 1.0 / (double)order);
        double a = 0.5 * (p - 1.0 / p);
        double b = 0.5 * (p + 1.0 / p);
        System.out.println("alpha: " + alpha);
        System.out.println("p:     " + p);
        System.out.println("a:     " + a);
        System.out.println("b:     " + b);
        int nRealPoles = order - 2 * (order / 2);
        int nComplexPolePairs = order / 2;
        int nPoles = nRealPoles + 2 * nComplexPolePairs;
        if (nRealPoles == 1) {
            double[] td = new double[]{1.0 / a, 1.0};
            this.addSection(new Rational(new Polynomial(1.0), new Polynomial(td)));
        }
        double dAngle = Math.PI / (double)nPoles;
        for (int i = 0; i < nComplexPolePairs; ++i) {
            double angle = -1.5707963267948966 + dAngle / 2.0 * (double)(1 + nRealPoles) + (double)i * dAngle;
            Complex pole = Complex.divide(1.0, new Complex(a * Math.sin(angle), b * Math.cos(angle)));
            double[] td = new double[]{pole.real() * pole.real() + pole.imag() * pole.imag(), -2.0 * pole.real(), 1.0};
            double zeroimag = 1.0 / Math.cos((double)(2 * i + 1) * Math.PI / (double)(2 * order));
            double[] tn = new double[]{zeroimag * zeroimag, 0.0, 1.0};
            this.addSection(new Rational(new Polynomial(tn), new Polynomial(td)));
        }
        double DCvalue = this.evaluate(0.0).abs();
        ((Rational)this.sections.get(0)).timesEquals(1.0 / DCvalue);
    }

    public static void main(String[] args) {
        AnalogChebyshevII A = new AnalogChebyshevII(8, 0.1);
        float[] tmp = new float[201];
        for (int i = 0; i < 201; ++i) {
            Complex C = A.evaluate((double)i * 0.02);
            tmp[i] = (float)Complex.abs(C);
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("C:\\DATA\\Test\\AnalogResponse.m"));
            ps.print("R = [ ");
            for (int i = 0; i < 200; ++i) {
                ps.println(tmp[i] + "; ...");
            }
            ps.println(tmp[200] + "];");
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

