/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.iir;

import com.oregondsp.signalProcessing.filter.Polynomial;
import com.oregondsp.signalProcessing.filter.Rational;
import com.oregondsp.signalProcessing.filter.iir.AnalogPrototype;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class AnalogChebyshevI
extends AnalogPrototype {
    public AnalogChebyshevI(int order, double epsilon) {
        double alpha = (1.0 + Math.sqrt(1.0 + epsilon * epsilon)) / epsilon;
        double p = Math.pow(alpha, 1.0 / (double)order);
        double a = 0.5 * (p - 1.0 / p);
        double b = 0.5 * (p + 1.0 / p);
        System.out.println("alpha: " + alpha);
        System.out.println("p:     " + p);
        System.out.println("a:     " + a);
        System.out.println("b:     " + b);
        int nRealPoles = order - 2 * (order / 2);
        int nComplexPolePairs = order / 2;
        int nPoles = nRealPoles + 2 * nComplexPolePairs;
        if (nRealPoles == 1) {
            double[] td = new double[]{a, 1.0};
            this.addSection(new Rational(new Polynomial(1.0), new Polynomial(td)));
        }
        double dAngle = Math.PI / (double)nPoles;
        for (int i = 0; i < nComplexPolePairs; ++i) {
            double angle = -1.5707963267948966 + dAngle / 2.0 * (double)(1 + nRealPoles) + (double)i * dAngle;
            Complex pole = new Complex(a * Math.sin(angle), b * Math.cos(angle));
            double[] td = new double[]{pole.real() * pole.real() + pole.imag() * pole.imag(), -2.0 * pole.real(), 1.0};
            this.addSection(new Rational(new Polynomial(1.0), new Polynomial(td)));
        }
        ((Rational)this.sections.get(0)).timesEquals(1.0 / (Math.pow(2.0, order - 1) * epsilon));
    }

    public static void main(String[] args) {
        AnalogChebyshevI A = new AnalogChebyshevI(4, 0.50885);
        AnalogPrototype B = A.lptolp(0.6283185307179586);
        float[] tmp = new float[201];
        for (int i = 0; i < 201; ++i) {
            Complex C = B.evaluate((double)i * 0.02);
            tmp[i] = (float)Complex.abs(C);
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("C:\\DATA\\Test\\AnalogResponse.m"));
            ps.print("R = [ ");
            for (int i = 0; i < 200; ++i) {
                ps.println(tmp[i] + "; ...");
            }
            ps.println(tmp[200] + "];");
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

