/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.iir;

import com.oregondsp.signalProcessing.filter.Polynomial;
import com.oregondsp.signalProcessing.filter.Rational;
import com.oregondsp.signalProcessing.filter.iir.AnalogPrototype;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class AnalogButterworth
extends AnalogPrototype {
    public AnalogButterworth(int order) {
        int nRealPoles = order - 2 * (order / 2);
        int nComplexPolePairs = order / 2;
        int nPoles = nRealPoles + 2 * nComplexPolePairs;
        if (nRealPoles == 1) {
            double[] td = new double[]{1.0, 1.0};
            this.addSection(new Rational(new Polynomial(1.0), new Polynomial(td)));
        }
        double dAngle = Math.PI / (double)nPoles;
        for (int i = 0; i < nComplexPolePairs; ++i) {
            double angle = -1.5707963267948966 + dAngle / 2.0 * (double)(1 + nRealPoles) + (double)i * dAngle;
            double[] td = new double[]{1.0, -2.0 * Math.sin(angle), 1.0};
            this.addSection(new Rational(new Polynomial(1.0), new Polynomial(td)));
        }
    }

    public static void main(String[] args) {
        AnalogButterworth B = new AnalogButterworth(6);
        AnalogPrototype A = B.lptobp(Math.PI * 4, Math.PI * 6);
        float[] tmp = new float[201];
        float[] gd = new float[201];
        for (int i = 0; i < 201; ++i) {
            double omega = (double)i * 2.0 * Math.PI / 20.0;
            tmp[i] = (float)Complex.abs(A.evaluate(omega));
            gd[i] = (float)A.groupDelay(omega);
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("C:\\DATA\\Test\\AnalogButterworthResponse.m"));
            ps.print("R = [ ");
            for (int i = 0; i < 200; ++i) {
                ps.println(tmp[i] + "; ...");
            }
            ps.println(tmp[200] + "];");
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("C:\\DATA\\Test\\AnalogButterworthGroupDelay.m"));
            ps.print("gd = [ ");
            for (int i = 0; i < 200; ++i) {
                ps.println(gd[i] + "; ...");
            }
            ps.println(gd[200] + "];");
            ps.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

