/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.iir;

import com.oregondsp.signalProcessing.filter.Polynomial;
import com.oregondsp.signalProcessing.filter.Rational;
import com.oregondsp.signalProcessing.filter.iir.Complex;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Arrays;

public class Allpass {
    protected double[] k;
    protected int order;
    protected double[] state;
    protected Rational T;

    public Allpass(int order) {
        this.order = order;
        this.k = new double[order];
        this.state = new double[order + 1];
        this.constructRationalRepresentation();
    }

    public Allpass(Polynomial A) {
        this.k = A.reflectionCoefficients();
        this.order = this.k.length;
        this.state = new double[this.order + 1];
        this.constructRationalRepresentation();
    }

    public Allpass(double[] k) {
        this.k = (double[])k.clone();
        this.order = this.k.length;
        this.state = new double[this.order + 1];
        this.constructRationalRepresentation();
    }

    public void initialize() {
        Arrays.fill(this.state, 0.0);
    }

    public float filter(float x) {
        for (int stage = this.order; stage >= 0; --stage) {
            if (stage > 0) {
                x = (float)((double)x - this.k[stage - 1] * this.state[stage - 1]);
                this.state[stage] = this.k[stage - 1] * (double)x + this.state[stage - 1];
                continue;
            }
            this.state[stage] = x;
        }
        return (float)this.state[this.order];
    }

    public void filter(float[] x) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.filter(x[i]);
        }
    }

    public Complex evaluate(double omega) {
        Complex ejOmega = Complex.exp(new Complex(0.0, -omega));
        return this.T.evaluate(ejOmega);
    }

    public double groupDelay(double Omega) {
        return this.T.discreteTimeGroupDelay(Omega);
    }

    protected void constructRationalRepresentation() {
        double[] a = new double[this.order + 1];
        double[] b = new double[this.order + 1];
        a[0] = 1.0;
        for (int p = 0; p < this.order; ++p) {
            Arrays.fill(b, 0.0);
            for (int i = 0; i <= p; ++i) {
                int n = i;
                b[n] = b[n] + a[i];
                int n2 = i + 1;
                b[n2] = b[n2] + this.k[p] * a[p - i];
            }
            System.arraycopy(b, 0, a, 0, p + 2);
        }
        Arrays.fill(b, 0.0);
        for (int i = 0; i <= this.order; ++i) {
            b[i] = a[this.order - i];
        }
        this.T = new Rational(new Polynomial(b), new Polynomial(a));
    }

    public Rational rationalRepresentation() {
        return new Rational(this.T);
    }

    public void print(PrintStream ps) {
        DecimalFormat DF = new DecimalFormat("0.000000");
        ps.println("Allpass order:  " + this.order);
        for (int i = 0; i < this.order; ++i) {
            if (i < this.order) {
                if (this.k[i] < 0.0) {
                    ps.println("  " + DF.format(this.k[i]) + "  " + this.state[i]);
                    continue;
                }
                ps.println("   " + DF.format(this.k[i]) + "  " + this.state[i]);
                continue;
            }
            ps.println("             " + this.state[i]);
        }
    }
}

