/*
 * Decompiled with CFR 0.152.
 */
package com.oregondsp.signalProcessing.filter.fir.equiripple;

import com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeIV;

public class StaggeredDifferentiator
extends FIRTypeIV {
    private double delta;

    public StaggeredDifferentiator(int N, double delta) {
        super(1, N);
        this.bands[0][0] = 1.0 / (double)(2 * N);
        this.bands[0][1] = 1.0;
        this.delta = delta;
        this.generateCoefficients();
    }

    @Override
    double desiredResponse(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = -Math.PI * Omega / this.delta;
        }
        return retval;
    }

    @Override
    double weight(double Omega) {
        double retval = 0.0;
        if (this.LTE(this.bands[0][0], Omega) && this.LTE(Omega, this.bands[0][1])) {
            retval = 1.0 / Omega;
        }
        return retval;
    }
}

